/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl.servers;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.internal.core.Messages;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServer
implements IServer {
    private static final IProcess[] NO_PROCESS = new IProcess[0];
    protected Set<IServer> servers = new TreeSet<IServer>(new Comparator<IServer>(){

        @Override
        public int compare(IServer o1, IServer o2) {
            return o1.getId().compareToIgnoreCase(o2.getId());
        }
    });
    private String name;
    private String host;
    private String id;
    private IServerType type;

    public GroupServer(String id, IServerType type) {
        this.id = id;
        this.type = type;
    }

    public void addServer(IServer server) {
        this.servers.add(server);
    }

    public void removeServer(IServer server) {
        this.servers.remove(server);
    }

    public void clearServers() {
        this.servers.clear();
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    @Override
    public void addOperationListener(IOperationListener listener) {
        for (IServer server : this.servers) {
            server.addOperationListener(listener);
        }
    }

    @Override
    public void addServerListener(IServerListener listener) {
        for (IServer server : this.servers) {
            server.addServerListener(listener);
        }
    }

    @Override
    public IStatus canDelete() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus askStopBeforeDelete() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus canHaveModule(IModule module) {
        return null;
    }

    @Override
    public IStatus canModify() {
        return new Status(4, "com.aptana.ide.server", 4, Messages.GroupServer_Status_CannotModify, null);
    }

    @Override
    public IStatus canModifyInStoppedStateOnly() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus canPublish() {
        return new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)Messages.AbstractServer_DOES_NOT_SUPPORTS_PUBLISH, (String)this.getName()), null);
    }

    @Override
    public IStatus canRestart(String mode) {
        for (IServer server : this.servers) {
            if (!Status.OK_STATUS.equals(server.canRestart(mode))) continue;
            return Status.OK_STATUS;
        }
        return new Status(4, "com.aptana.ide.server", 4, Messages.GroupServer_Status_NoServerRestart, null);
    }

    @Override
    public IStatus canStart(String launchMode) {
        for (IServer server : this.servers) {
            if (!Status.OK_STATUS.equals(server.canStart(launchMode))) continue;
            return Status.OK_STATUS;
        }
        return new Status(4, "com.aptana.ide.server", 4, Messages.GroupServer_Status_NoServerStart, null);
    }

    @Override
    public IStatus canStop() {
        for (IServer server : this.servers) {
            if (!Status.OK_STATUS.equals(server.canStop())) continue;
            return Status.OK_STATUS;
        }
        return new Status(4, "com.aptana.ide.server", 4, Messages.GroupServer_Status_NoServerStop, null);
    }

    @Override
    public void configureModule(IModule module, IOperationListener listener, IProgressMonitor monitor) {
    }

    @Override
    public void configureModule(IAbstractConfiguration config, IOperationListener listener, IProgressMonitor monitor) {
    }

    @Override
    public String fetchStatistics() {
        return null;
    }

    @Override
    public IServer[] getAssociatedServers() {
        return new IServer[0];
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public IPath getDocumentRoot() {
        return null;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getHostname() {
        return this.host;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ILaunch getLaunch() {
        return null;
    }

    @Override
    public ILog getLog() {
        return null;
    }

    @Override
    public String getMode() {
        return null;
    }

    @Override
    public IModule[] getModules() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public IProcess[] getProcesses() {
        return NO_PROCESS;
    }

    @Override
    public IPath getServerRoot() {
        return null;
    }

    @Override
    public int getServerState() {
        return 6;
    }

    @Override
    public IServerType getServerType() {
        return this.type;
    }

    @Override
    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    @Override
    public boolean isConfigured(IModule module) {
        return false;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isWebServer() {
        return false;
    }

    @Override
    public void publish(int kind, IModule[] modules, IOperationListener listener, IProgressMonitor monitor) {
    }

    @Override
    public void reconfigure(IAbstractConfiguration configuration) throws CoreException {
    }

    @Override
    public void removeOperationListener(IServerListener listener) {
        for (IServer server : this.servers) {
            server.removeOperationListener(listener);
        }
    }

    @Override
    public void removeServerListener(IServerListener listener) {
        for (IServer server : this.servers) {
            server.removeServerListener(listener);
        }
    }

    @Override
    public void restart(String mode, IOperationListener listener, IProgressMonitor monitor) {
        for (IServer server : this.servers) {
            if (!Status.OK_STATUS.equals(server.canRestart(mode))) continue;
            server.restart(mode, listener, monitor);
        }
    }

    @Override
    public void showStatisticsInterface() {
    }

    @Override
    public void start(String mode, IOperationListener listener, IProgressMonitor monitor) {
    }

    @Override
    public void stop(boolean force, IOperationListener listener, IProgressMonitor monitor) {
    }

    @Override
    public void storeConfiguration(IAbstractConfiguration configuration) {
    }

    @Override
    public boolean suppliesStatistics() {
        return false;
    }

    @Override
    public boolean suppliesStatisticsInterface() {
        return false;
    }

    @Override
    public void unconfigureModule(IModule module, IOperationListener listener, IProgressMonitor monitor) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Set<IServer> getServers() {
        return this.servers;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public ILog[] getAllLogs() {
        return null;
    }
}

