/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class ServerFileTypeHandlers {
    private static final String EXTENSION_POINT_NAME = "previewFileTypeHandler";
    private static final String HANDLER_ELEMENT_NAME = "handler";
    private static final String EXTENSION_ATTRIBUTE_NAME = "extension";
    private static final String SERVER_ID_ATTRIBUTE_NAME = "serverID";
    private static final String SERVER_TYPE_ID_ATTRIBUTE_NAME = "serverTypeID";
    private static final String PATH_HEADER_ATTRIBUTE_NAME = "pathHeader";

    public static PreviewInfo getPreviewInfoByExtension(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.ide.server", EXTENSION_POINT_NAME);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String extension;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (HANDLER_ELEMENT_NAME.equals(element.getName()) && fileExtension.equals(extension = element.getAttribute(EXTENSION_ATTRIBUTE_NAME))) {
                String serverID = element.getAttribute(SERVER_ID_ATTRIBUTE_NAME);
                String serverTypeID = element.getAttribute(SERVER_TYPE_ID_ATTRIBUTE_NAME);
                String pathHeader = element.getAttribute(PATH_HEADER_ATTRIBUTE_NAME);
                if (serverID != null) {
                    PreviewInfo toReturn = new PreviewInfo();
                    toReturn.serverID = serverID;
                    toReturn.pathHeader = pathHeader;
                    toReturn.serverTypeID = serverTypeID;
                    return toReturn;
                }
            }
            ++n2;
        }
        return null;
    }

    public static PreviewInfo getPreviewInfoFromURL(String url) {
        String fileExtension = ServerFileTypeHandlers.getFileExtensionFromURL(url);
        return ServerFileTypeHandlers.getPreviewInfoByExtension(fileExtension);
    }

    private static String getFileExtensionFromURL(String url) {
        int pointIndex = url.lastIndexOf(".");
        if (pointIndex == -1) {
            return null;
        }
        if (pointIndex == url.length() - 1) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = pointIndex + 1;
        while (i < url.length()) {
            char ch = url.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                return result.toString();
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    private ServerFileTypeHandlers() {
    }

    public static class PreviewInfo {
        public String serverID;
        public String pathHeader;
        public String serverTypeID;
    }
}

