/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.index.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.index.core.Activator;
import com.aptana.ide.index.core.Index;
import com.aptana.ide.internal.index.core.ReadWriteMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class IndexManager {
    private static IndexManager instance;
    private Map<String, Index> indexes = new HashMap<String, Index>();

    public static synchronized IndexManager getInstance() {
        if (instance == null) {
            instance = new IndexManager();
        }
        return instance;
    }

    private IndexManager() {
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource.getType() == 1 && delta.getKind() == 2) {
                                IndexManager.this.removeDocument(resource.getProject().getFullPath(), resource.getProjectRelativePath().toPortableString());
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(listener, 1);
    }

    public Index getIndex(String path) {
        Index index = this.indexes.get(path);
        if (index == null) {
            try {
                index = new Index(path);
                this.indexes.put(path, index);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return index;
    }

    public IPath computeIndexLocation(String path) {
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(path.getBytes());
        String fileName = String.valueOf(Long.toString(crc.getValue())) + ".index";
        return Activator.getDefault().getStateLocation().append(fileName);
    }

    private void removeDocument(IPath container, String documentPath) {
        Index index = this.getIndex(container.toPortableString());
        if (index == null) {
            return;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return;
        }
        try {
            monitor.enterWrite();
            index.remove(documentPath);
        }
        finally {
            monitor.exitWrite();
        }
    }
}

