/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.search.epl.AptanaFileMatch;
import com.aptana.ide.search.epl.AptanaFileSystemMatch;
import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.Messages;
import com.aptana.ide.search.epl.TextSearchVisitor;
import com.aptana.ide.search.epl.filesystem.text.FileSystemTextSearchScope;
import com.aptana.ide.search.epl.filesystem.text.FileTextSearchEngine;
import com.aptana.ide.search.epl.filesystem.text.FileTextSearchMatchAccess;
import com.aptana.ide.search.epl.filesystem.text.FileTextSearchRequestor;
import com.aptana.ide.search.epl.internal.filesystem.text.FileNamePatternSearchScope;
import com.aptana.ide.search.epl.internal.filesystem.text.FileTextSearchVisitor;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileSearchQuery
extends org.eclipse.search.internal.ui.text.FileSearchQuery
implements ISearchQuery {
    private final FileTextSearchScope fScope;
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private final boolean isOpenEditorsOnly;
    private final String directory;
    private FileSearchResult fResult;
    private FileSystemSearchResult fDResult;
    private boolean fIsIgnoreLineEndings;
    private boolean refresh;

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, FileTextSearchScope scope, boolean isOpenEditors, String directory, boolean isIgnoreLineEndings) {
        super(searchText, isRegEx, isCaseSensitive, scope);
        this.fSearchText = searchText;
        this.directory = directory;
        this.isOpenEditorsOnly = isOpenEditors;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fScope = scope;
        this.fIsIgnoreLineEndings = isIgnoreLineEndings;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor) {
        boolean onlyFilesEditorInput;
        boolean searchInBinaries;
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        boolean bl = searchInBinaries = !this.isScopeAllFileTypes();
        if (!(this.directory == null && !this.isOpenEditorsOnly || (onlyFilesEditorInput = this.isAllOpenEditorsOnWorkspace()) && this.isOpenEditorsOnly)) {
            FileTextSearchResultCollector fcollector = new FileTextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
            String fs = this.directory == null ? "." : this.directory;
            FileSystemTextSearchScope newSearchScope = FileNamePatternSearchScope.newSearchScope(new File[]{new File(fs)}, this.fScope.getFileNamePatterns());
            newSearchScope.setOpenEditors(this.isOpenEditorsOnly);
            return FileTextSearchEngine.createDefault().search(newSearchScope, (FileTextSearchRequestor)fcollector, searchPattern, monitor);
        }
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
        AptanaTextEngine aptanaTextEngine = new AptanaTextEngine();
        aptanaTextEngine.setOpenEditorsOnly(this.isOpenEditorsOnly);
        aptanaTextEngine.needsRefresh(this.refresh);
        return aptanaTextEngine.search((TextSearchScope)this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    private boolean isAllOpenEditorsOnWorkspace() {
        boolean onlyFilesEditorInput = true;
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorInput input;
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && !((input = ep.getEditorInput()) instanceof IFileEditorInput) && (input instanceof IPathEditorInput || input instanceof IURIEditorInput)) {
                        onlyFilesEditorInput = false;
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return onlyFilesEditorInput;
    }

    private boolean isScopeAllFileTypes() {
        String[] fileNamePatterns = this.fScope.getFileNamePatterns();
        if (fileNamePatterns == null) {
            return true;
        }
        int i = 0;
        while (i < fileNamePatterns.length) {
            if ("*".equals(fileNamePatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getSearchString() {
        String searchText = this.fSearchText;
        searchText = searchText.replace("\r", "\\r");
        if ((searchText = searchText.replace("\n", "\\n")).length() > 50) {
            searchText = StringUtils.ellipsify((String)searchText.substring(0, 45));
        }
        return searchText;
    }

    public String getResultLabel(int nMatches) {
        String fdesc;
        String searchString = this.getSearchString();
        String string = fdesc = this.directory == null ? this.fScope.getDescription() : this.directory;
        if (this.isOpenEditorsOnly) {
            fdesc = Messages.OPEN_EDITORS;
        }
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchString, this.fScope.getDescription()};
                    return MessageFormat.format(SearchMessages.FileSearchQuery_singularLabel, args);
                }
                Object[] args = new Object[]{searchString, new Integer(nMatches), fdesc};
                return MessageFormat.format(SearchMessages.FileSearchQuery_pluralPattern, args);
            }
            if (nMatches == 1) {
                Object[] args = new Object[]{searchString, fdesc, this.fScope.getFilterDescription()};
                return MessageFormat.format(SearchMessages.FileSearchQuery_singularPatternWithFileExt, args);
            }
            Object[] args = new Object[]{searchString, new Integer(nMatches), fdesc, this.fScope.getFilterDescription()};
            return MessageFormat.format(SearchMessages.FileSearchQuery_pluralPatternWithFileExt, args);
        }
        if (nMatches == 1) {
            Object[] args = new Object[]{this.fScope.getFilterDescription(), fdesc};
            return MessageFormat.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        Object[] args = new Object[]{this.fScope.getFilterDescription(), new Integer(nMatches), fdesc};
        return MessageFormat.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{file}, (String[])new String[]{"*"}, (boolean)true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(result, isFileSearchOnly, true);
        return new AptanaTextEngine().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern((String)this.fSearchText, (boolean)this.fIsCaseSensitive, (boolean)this.fIsRegEx);
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean isIgnoreLineEndings() {
        return this.fIsIgnoreLineEndings;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.directory != null) {
            if (this.fDResult == null) {
                this.fDResult = new FileSystemSearchResult(this);
            }
            return this.fDResult;
        }
        if (this.isOpenEditorsOnly && !this.isAllOpenEditorsOnWorkspace()) {
            if (this.fDResult == null) {
                this.fDResult = new FileSystemSearchResult(this);
            }
            return this.fDResult;
        }
        if (this.fResult == null) {
            this.fResult = new FileSearchResult((org.eclipse.search.internal.ui.text.FileSearchQuery)this);
            new SearchResultUpdater((AbstractTextSearchResult)this.fResult);
        }
        return this.fResult;
    }

    public boolean isOpenEditorsOnly() {
        return this.isOpenEditorsOnly;
    }

    public String getDirectory() {
        return this.directory;
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, File entry) {
        FileSystemTextSearchScope scope = FileSystemTextSearchScope.newSearchScope(new File[]{entry}, new String[]{"*"}, true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        FileTextSearchResultCollector collector = new FileTextSearchResultCollector(result, isFileSearchOnly, true);
        return FileTextSearchEngine.createDefault().search(scope, (FileTextSearchRequestor)collector, searchPattern, monitor);
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    private static final class AptanaTextEngine
    extends TextSearchEngine {
        private boolean openEditorsOnly;
        private boolean refresh;

        private AptanaTextEngine() {
        }

        public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
            return new TextSearchVisitor(requestor, searchPattern, this.openEditorsOnly, this.refresh).search(scope, monitor);
        }

        public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
            return new TextSearchVisitor(requestor, searchPattern, this.openEditorsOnly, false).search(scope, monitor);
        }

        public void setOpenEditorsOnly(boolean isOpenEditorsOnly) {
            this.openEditorsOnly = isOpenEditorsOnly;
        }

        public void needsRefresh(boolean isOpenEditorsOnly) {
            this.refresh = isOpenEditorsOnly;
        }
    }

    private static final class FileTextSearchResultCollector
    extends FileTextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private ArrayList fCachedMatches;

        private FileTextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
        }

        public boolean acceptFile(File file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch((Match)new AptanaFileSystemMatch(file, 0, 0, 0, ""));
            }
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(File file) {
            return this.fSearchInBinaries;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            return true;
        }

        public boolean acceptPatternMatch(FileTextSearchMatchAccess matchRequestor) throws CoreException {
            FileTextSearchVisitor.ReusableMatchAccess real = (FileTextSearchVisitor.ReusableMatchAccess)matchRequestor;
            this.fCachedMatches.add(new AptanaFileSystemMatch(matchRequestor.getFileSystemFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), real.getLineNumber(), real.getLineContent()));
            return true;
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private synchronized void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                this.fCachedMatches.clear();
            }
        }
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private ArrayList fCachedMatches;

        private TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch((Match)new AptanaFileMatch(file, 0, 0, new LineElement((IResource)file, 0, 0, "")));
            }
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(IFile file) {
            return this.fSearchInBinaries;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            int matchOffset = matchRequestor.getMatchOffset();
            LineElement lineElement = this.getLineElement(matchOffset, matchRequestor);
            if (lineElement != null) {
                AptanaFileMatch fileMatch = new AptanaFileMatch(matchRequestor.getFile(), matchOffset, matchRequestor.getMatchLength(), lineElement);
                this.fCachedMatches.add(fileMatch);
            }
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
            int lineNumber = 1;
            int lineStart = 0;
            if (!this.fCachedMatches.isEmpty()) {
                FileMatch last = (FileMatch)this.fCachedMatches.get(this.fCachedMatches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            if (offset < lineStart) {
                return null;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private synchronized void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                this.fCachedMatches.clear();
            }
        }
    }
}

