/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.documentation.samples;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.documentation.DocumentationPlugin;
import com.aptana.ide.documentation.samples.AjaxSampleBrowserInput;
import com.aptana.ide.documentation.samples.Messages;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.browser.CoreBrowserEditor;
import com.aptana.ide.samples.handlers.IPreviewHandler;
import com.aptana.ide.samples.model.SamplesEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxSamplesPreviewHandler
implements IPreviewHandler {
    private void copyChildren(File parent, File[] children, List<File> createdFiles) {
        int i = 0;
        while (i < children.length) {
            File file = children[i];
            File target = new File(parent, file.getName());
            try {
                if (file.isDirectory()) {
                    if (!target.exists()) {
                        if (target.mkdir()) {
                            createdFiles.add(target);
                            this.copyChildren(target, file.listFiles(), createdFiles);
                        }
                    } else {
                        this.copyChildren(target, file.listFiles(), createdFiles);
                    }
                } else if (!target.exists()) {
                    FileOutputStream os = new FileOutputStream(target);
                    FileInputStream is = new FileInputStream(file);
                    FileUtils.pipe((InputStream)is, (OutputStream)os, (boolean)false);
                    createdFiles.add(target);
                    ((InputStream)is).close();
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public void previewRequested(final SamplesEntry entry) {
        if (entry.isRoot()) {
            final ArrayList migratedIncludes = new ArrayList();
            List entries = entry.getSubEntries();
            File index = null;
            int i = 0;
            while (i < entries.size()) {
                SamplesEntry sub = (SamplesEntry)entries.get(i);
                String name = sub.getFile().getName();
                if (name.equals("index.html")) {
                    index = sub.getFile();
                    break;
                }
                if (index == null && (name.endsWith(".html") || name.endsWith(".HTML") || name.endsWith(".htm") || name.endsWith(".HTM"))) {
                    index = sub.getFile();
                }
                ++i;
            }
            if (index != null) {
                try {
                    final URL url = index.toURI().toURL();
                    if (url != null) {
                        Bundle b = Platform.getBundle((String)"com.aptana.ide.documentation");
                        URL content = b.getEntry("/content");
                        if (content != null) {
                            FileLocator.toFileURL((URL)content);
                        }
                        URL loading = b.getEntry("/content/loading_sample.html");
                        loading = FileLocator.toFileURL((URL)loading);
                        AjaxSampleBrowserInput input = new AjaxSampleBrowserInput(entry, loading);
                        IWorkbenchWindow window = IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            IWorkbenchPage page = window.getActivePage();
                            final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"com.aptana.ide.intro.browserEditor");
                            final Job buildSample = new Job(Messages.AjaxSamplesPreviewHandler_JobGeneratePreview){

                                protected IStatus run(IProgressMonitor monitor) {
                                    List includes = entry.getParent().getIncludePaths();
                                    int i = 0;
                                    while (i < includes.size()) {
                                        File file = new File((String)includes.get(i));
                                        File target = new File(entry.getFile(), file.getName());
                                        try {
                                            if (file.isDirectory()) {
                                                if (!target.exists()) {
                                                    if (target.mkdir()) {
                                                        migratedIncludes.add(target);
                                                        AjaxSamplesPreviewHandler.this.copyChildren(target, file.listFiles(), migratedIncludes);
                                                    }
                                                } else {
                                                    AjaxSamplesPreviewHandler.this.copyChildren(target, file.listFiles(), migratedIncludes);
                                                }
                                            } else if (!target.exists()) {
                                                FileOutputStream os = new FileOutputStream(target);
                                                FileInputStream is = new FileInputStream(file);
                                                FileUtils.pipe((InputStream)is, (OutputStream)os, (boolean)false);
                                                migratedIncludes.add(target);
                                                ((InputStream)is).close();
                                                ((OutputStream)os).close();
                                            }
                                        }
                                        catch (IOException iOException) {}
                                        ++i;
                                    }
                                    UIJob urlUpdate = new UIJob(Messages.AjaxSamplesPreviewHandler_JobUpdatePreview){

                                        public IStatus runInUIThread(IProgressMonitor monitor) {
                                            if (editor != null && !((CoreBrowserEditor)editor).isDisposed()) {
                                                ((CoreBrowserEditor)editor).setURL(StringUtils.urlDecodeFilename((char[])url.toExternalForm().toCharArray()));
                                            }
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    urlUpdate.schedule();
                                    return Status.OK_STATUS;
                                }
                            };
                            ((CoreBrowserEditor)editor).addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent e) {
                                    Job cleanupJob = new Job(Messages.AjaxSamplesPreviewHandler_JobCleanPreview){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        protected IStatus run(IProgressMonitor monitor) {
                                            try {
                                                buildSample.join();
                                            }
                                            catch (InterruptedException interruptedException) {}
                                            List list = migratedIncludes;
                                            synchronized (list) {
                                                int i = migratedIncludes.size() - 1;
                                                while (i >= 0) {
                                                    ((File)migratedIncludes.get(i)).delete();
                                                    --i;
                                                }
                                            }
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    cleanupJob.setSystem(true);
                                    cleanupJob.setPriority(30);
                                    cleanupJob.schedule();
                                }
                            });
                            buildSample.setPriority(40);
                            buildSample.setSystem(true);
                            buildSample.schedule();
                        }
                    }
                }
                catch (Exception e) {
                    Job buildSample = new Job(Messages.AjaxSamplesPreviewHandler_JobShowError){

                        protected IStatus run(IProgressMonitor monitor) {
                            CoreUIUtils.logAndDialogError((Shell)CoreUIUtils.getActiveShell(), (Plugin)DocumentationPlugin.getDefault(), (String)Messages.AjaxSamplesPreviewHandler_ERR_Title_CreatePreview, (String)Messages.AjaxSamplesPreviewHandler_ERR_MSG_CreatePreview, (Throwable)e);
                            return Status.OK_STATUS;
                        }
                    };
                    buildSample.setPriority(10);
                    buildSample.setSystem(true);
                    buildSample.schedule();
                }
            }
        }
    }
}

