/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.wizard;

import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.InstallerCategory;
import java.util.ArrayList;
import java.util.List;

public class PluginTreeNode {
    private Object data;
    private boolean installed;
    private PluginTreeNode parent;
    private List<PluginTreeNode> children;

    public PluginTreeNode(Object data) {
        this.data = data;
        this.children = new ArrayList<PluginTreeNode>();
    }

    public void add(PluginTreeNode child) {
        this.children.add(child);
    }

    public void clear() {
        this.data = null;
        this.installed = false;
        this.parent = null;
        for (PluginTreeNode child : this.children) {
            child.clear();
        }
        this.children.clear();
    }

    public Object getData() {
        return this.data;
    }

    public String getID() {
        if (this.data == null) {
            return "";
        }
        if (this.data instanceof InstallerCategory) {
            return ((InstallerCategory)this.data).getID();
        }
        if (this.data instanceof IPlugin) {
            return ((IPlugin)this.data).getId();
        }
        return this.data.toString();
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public PluginTreeNode getChild(String id) {
        for (PluginTreeNode child : this.children) {
            if (!child.getID().equals(id)) continue;
            return child;
        }
        return null;
    }

    public PluginTreeNode[] getChildren() {
        return this.children.toArray(new PluginTreeNode[this.children.size()]);
    }

    public PluginTreeNode getParent() {
        return this.parent;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public void setParent(PluginTreeNode parent) {
        this.parent = parent;
    }
}

