/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.installer.views;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.widgets.TableViewerSorter;
import com.aptana.ide.installer.Activator;
import com.aptana.ide.installer.views.InstalledPluginsLabelProvider;
import com.aptana.ide.installer.views.InstalledPluginsViewerFilter;
import com.aptana.ide.installer.views.LatestFeatureFilter;
import com.aptana.ide.installer.views.PluginContentProvider;
import com.aptana.ide.installer.views.PluginMessages;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.manager.Plugin;
import com.aptana.ide.update.manager.PluginListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class PluginsView
extends ViewPart
implements ISelectionProvider,
ISelectionChangedListener {
    private static final String[] INSTALLED_ACTION_IDS = new String[]{"com.aptana.ide.installer.plugins_view_context", "com.aptana.ide.installer.actions.RemoveFeatureAction", "com.aptana.ide.installer.actions.InstallFeatureAction", "com.aptana.ide.installer.views.ToggleLatestFeatureAction"};
    private static final String NAME = PluginMessages.PluginsView_Name;
    private static final String VERSION = PluginMessages.PluginsView_Version;
    private static final String RELEASE_DATE = PluginMessages.PluginsView_ReleaseDate;
    private static final String DESCRIPTION = PluginMessages.PluginsView_Description;
    private TableViewer installedPluginsTableViewer;
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private ISelection selection;
    private LatestFeatureFilter latestFilter;
    private boolean latestFilterOn;
    private PluginListener pluginsListener;

    public void createPartControl(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createInstalledPluginsTable(composite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createPopupMenu(this.installedPluginsTableViewer, INSTALLED_ACTION_IDS);
        this.pluginsListener = new PluginListener(){

            public void pluginUninstalled() {
                PluginsView.this.refreshInstalledPlugins();
            }

            public void pluginInstalled() {
                PluginsView.this.refreshInstalledPlugins();
            }

            public void pluginDisabled() {
                PluginsView.this.refreshInstalledPlugins();
            }

            public void remotePluginsRefreshed() {
            }

            public void pluginEnabled() {
                PluginsView.this.refreshInstalledPlugins();
            }
        };
        this.getPluginManager().addListener(this.pluginsListener);
        PreferenceUtils.registerBackgroundColorPreference((Control)this.installedPluginsTableViewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.pluginsView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.installedPluginsTableViewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.pluginsView");
    }

    private IPluginManager getPluginManager() {
        return Activator.getDefault().getPluginManager();
    }

    public void dispose() {
        try {
            this.getPluginManager().removeListener(this.pluginsListener);
        }
        finally {
            super.dispose();
        }
    }

    private void createPopupMenu(TableViewer table, String[] ids) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new MyMenuListener(this.getViewSite(), ids));
        Menu menu = menuMgr.createContextMenu(table.getControl());
        table.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)table);
    }

    private Composite createComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    private void createInstalledPluginsTable(Composite parent) {
        this.installedPluginsTableViewer = new TableViewer(parent, 65540);
        Table pluginsTable = this.installedPluginsTableViewer.getTable();
        pluginsTable.setHeaderVisible(true);
        pluginsTable.setLinesVisible(false);
        pluginsTable.setLayoutData((Object)new GridData(1808));
        PluginsView.createColumn(pluginsTable, "", 32);
        PluginsView.createColumn(pluginsTable, NAME, 200);
        PluginsView.createColumn(pluginsTable, VERSION, 75);
        PluginsView.createColumn(pluginsTable, RELEASE_DATE, 100);
        PluginsView.createColumn(pluginsTable, DESCRIPTION, 275);
        this.installedPluginsTableViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.installedPluginsTableViewer.setLabelProvider((IBaseLabelProvider)new InstalledPluginsLabelProvider(pluginsTable.getDisplay()));
        TableViewerSorter.bind((TableViewer)this.installedPluginsTableViewer);
        this.installedPluginsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.installedPluginsTableViewer.addFilter((ViewerFilter)new InstalledPluginsViewerFilter());
        this.refreshInstalledPlugins();
        PreferenceUtils.persist((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (Table)pluginsTable, (String)"installedPlugins");
    }

    private void refreshInstalledPlugins() {
        Job fetchJob = new Job("Fetching installed plugins"){

            protected IStatus run(IProgressMonitor monitor) {
                List plugins = PluginsView.this.getPluginManager().getInstalledPlugins();
                final ArrayList<Plugin> sorted = new ArrayList<Plugin>(plugins);
                List remotePlugins = PluginsView.this.getPluginManager().getRemotePlugins();
                for (Plugin remote : remotePlugins) {
                    List<IPlugin> matchingInstalled = this.findMatch(remote.getId(), plugins);
                    if (matchingInstalled == null || matchingInstalled.isEmpty()) continue;
                    for (IPlugin match : matchingInstalled) {
                        Plugin newPlugin = new Plugin(remote.getId(), match.getName(), match.getVersion(), remote.getReleaseDate(), remote.getDescription(), remote.getURL(), remote.getMore(), remote.getCategory(), remote.getSortweight(), remote.getImagePath(), remote.getRequiredPlugins(), remote.getInstallerCategory());
                        sorted.remove(match);
                        sorted.add(newPlugin);
                    }
                }
                Collections.sort(sorted, new Comparator<IPlugin>(){

                    @Override
                    public int compare(IPlugin o1, IPlugin o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                CoreUIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PluginsView.this.installedPluginsTableViewer.setInput((Object)sorted);
                    }
                });
                return Status.OK_STATUS;
            }

            private List<IPlugin> findMatch(String id, List<IPlugin> plugins) {
                ArrayList<IPlugin> matches = new ArrayList<IPlugin>();
                for (IPlugin plugin : plugins) {
                    if (!plugin.getId().equals(id)) continue;
                    matches.add(plugin);
                }
                return matches;
            }
        };
        fetchJob.setPriority(40);
        fetchJob.setSystem(true);
        fetchJob.schedule();
    }

    private static void createColumn(Table pluginsTable, String text, int width) {
        TableColumn nameColumn = new TableColumn(pluginsTable, 16384);
        nameColumn.setText(text);
        nameColumn.setWidth(width);
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void toggleLatestFeatureFilter() {
        if (this.latestFilter == null) {
            this.latestFilter = new LatestFeatureFilter();
        }
        if (this.latestFilterOn) {
            this.installedPluginsTableViewer.removeFilter((ViewerFilter)this.latestFilter);
        } else {
            this.installedPluginsTableViewer.addFilter((ViewerFilter)this.latestFilter);
        }
        this.latestFilterOn = !this.latestFilterOn;
    }

    private static final class MyMenuListener
    implements IMenuListener {
        private String[] ids;
        private IViewSite fViewSite;

        public MyMenuListener(IViewSite viewSite, String[] strings) {
            this.fViewSite = viewSite;
            this.ids = strings;
        }

        public void menuAboutToShow(IMenuManager manager) {
            IContributionItem[] items = this.fViewSite.getActionBars().getToolBarManager().getItems();
            int i = 0;
            while (i < items.length) {
                ActionContributionItem aci;
                if (items[i] instanceof ActionContributionItem && !this.filtered((aci = (ActionContributionItem)items[i]).getId())) {
                    manager.add(aci.getAction());
                }
                ++i;
            }
            manager.add((IContributionItem)new Separator("additions"));
        }

        private boolean filtered(String id) {
            int i = 0;
            while (i < this.ids.length) {
                if (id.equals(this.ids[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

