/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.widgets;

import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.widgets.ISelectableWidget;
import com.aptana.ide.core.ui.widgets.PopupItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;

public final class ImagePopup
extends Composite
implements ISelectableWidget {
    private static final boolean gtk = "gtk".equals(SWT.getPlatform());
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Listener filter;
    Color foreground;
    Color background;
    Font font;
    private Composite serverComposite;
    private Label popupText;
    private ToolBar toolBar;
    private ToolItem toolItem;
    private Menu menu;
    private Image popupImage;
    private MenuItem selectedItem;

    public ImagePopup(Composite parent, int style) {
        style = ImagePopup.checkStyle(style);
        super(parent, style);
        this.visibleItemCount = 5;
        final Composite inner = new Composite((Composite)this, 2048);
        final ImagePopup composite = this;
        GridLayout iLayout = new GridLayout(1, true);
        if (!CoreUIUtils.onMacOSX) {
            iLayout.marginWidth = 0;
        }
        iLayout.marginHeight = 0;
        this.setLayout((Layout)iLayout);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ImagePopup.this.toolBar.isEnabled() && ImagePopup.this.popupText.isEnabled()) {
                    Rectangle rect = inner.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = composite.toDisplay(pt);
                    ImagePopup.this.menu.setLocation(pt.x, pt.y);
                    ImagePopup.this.menu.setVisible(true);
                }
            }
        };
        inner.setBackground(inner.getDisplay().getSystemColor(1));
        iLayout = new GridLayout(3, false);
        iLayout.marginHeight = 0;
        iLayout.marginWidth = 0;
        GridData iData = new GridData(4, 4, true, true);
        iData.widthHint = 300;
        inner.setLayout((Layout)iLayout);
        inner.setLayoutData((Object)iData);
        inner.addMouseListener((MouseListener)listener);
        this.serverComposite = new Composite(inner, 0);
        this.serverComposite.setBackground(inner.getDisplay().getSystemColor(1));
        this.serverComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImagePopup.this.popupImage != null) {
                    e.gc.drawImage(ImagePopup.this.popupImage, 2, 2);
                }
            }
        });
        this.serverComposite.addMouseListener((MouseListener)listener);
        GridData siData = new GridData(4, 4, false, false);
        siData.heightHint = 16;
        siData.widthHint = 20;
        this.serverComposite.setLayoutData((Object)siData);
        this.popupText = new Label(inner, 16384);
        this.popupText.setBackground(inner.getDisplay().getSystemColor(1));
        this.popupText.addMouseListener((MouseListener)listener);
        GridData stData = new GridData(4, 0x1000000, true, false);
        this.popupText.setLayoutData((Object)stData);
        this.toolBar = new ToolBar(inner, 0x800000);
        this.toolBar.setBackground(inner.getDisplay().getSystemColor(1));
        GridLayout sbLayout = new GridLayout(1, false);
        sbLayout.marginHeight = 0;
        sbLayout.marginWidth = 0;
        sbLayout.horizontalSpacing = 0;
        this.toolBar.setLayout((Layout)sbLayout);
        this.toolBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.toolItem = new ToolItem(this.toolBar, 8);
        Image arrow = EclipseUtils.getArrowImage();
        this.toolItem.setImage(arrow);
        this.menu = new Menu((Control)parent);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = inner.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = composite.toDisplay(pt);
                ImagePopup.this.menu.setLocation(pt.x, pt.y);
                ImagePopup.this.menu.setVisible(true);
            }
        });
    }

    static int checkStyle(int style) {
        int mask = gtk ? 0x6800008 : 0x6800808;
        return style & mask;
    }

    public void add(String string, Image image, Object data) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        MenuItem newItem = new MenuItem(this.menu, 8);
        newItem.setData(data);
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImagePopup.this.selectedItem = (MenuItem)e.widget;
                ImagePopup.this.updateText(ImagePopup.this.selectedItem);
                ImagePopup.this.notifyListeners(14, ImagePopup.this.createEventFromSelectionEvent(e));
            }

            public void widgetSelected(SelectionEvent e) {
                ImagePopup.this.selectedItem = (MenuItem)e.widget;
                ImagePopup.this.updateText(ImagePopup.this.selectedItem);
                ImagePopup.this.notifyListeners(13, ImagePopup.this.createEventFromSelectionEvent(e));
            }
        });
        newItem.setText(string);
        if (image != null) {
            newItem.setImage(image);
        }
    }

    public void add(String string, Image image, int index) {
        this.add(string, image, null, index);
    }

    public void add(String string, Image image, Object data, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        MenuItem newItem = new MenuItem(this.menu, 8, index);
        newItem.setData(data);
        newItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImagePopup.this.selectedItem = (MenuItem)e.widget;
                ImagePopup.this.updateText(ImagePopup.this.selectedItem);
                ImagePopup.this.notifyListeners(14, ImagePopup.this.createEventFromSelectionEvent(e));
            }

            public void widgetSelected(SelectionEvent e) {
                ImagePopup.this.selectedItem = (MenuItem)e.widget;
                ImagePopup.this.updateText(ImagePopup.this.selectedItem);
                ImagePopup.this.notifyListeners(13, ImagePopup.this.createEventFromSelectionEvent(e));
            }
        });
        if (image != null) {
            newItem.setImage(image);
        }
    }

    private Event createEventFromSelectionEvent(SelectionEvent e) {
        Event ev = new Event();
        ev.data = e.data;
        ev.widget = e.widget;
        ev.item = e.item;
        return ev;
    }

    private void updateText(MenuItem item) {
        this.popupText.setText(item.getText());
        this.popupImage = item.getImage();
        this.serverComposite.redraw();
        this.serverComposite.update();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public String getText() {
        return this.popupText.getText();
    }

    public int indexOf(String string) {
        MenuItem[] items = this.menu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItem = items[i];
            if (menuItem.getText().equals(string)) {
                return this.menu.indexOf(menuItem);
            }
            ++i;
        }
        return -1;
    }

    public void select(int selectionIndex) {
        MenuItem index = this.menu.getItem(selectionIndex);
        this.menu.setDefaultItem(index);
        this.selectedItem = index;
        this.updateText(index);
    }

    public void setVisibleItemCount(int i) {
    }

    public int getSelectionIndex() {
        if (this.selectedItem != null) {
            return this.menu.indexOf(this.selectedItem);
        }
        return -1;
    }

    public PopupItem getItem(int index) {
        MenuItem mi = this.menu.getItem(index);
        if (mi != null) {
            PopupItem item = new PopupItem(mi.getText(), mi.getImage(), mi.getData());
            return item;
        }
        return null;
    }

    public void removeAll() {
        MenuItem[] items = this.menu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItem = items[i];
            menuItem.dispose();
            ++i;
        }
    }

    public void addModifyListener(ModifyListener ml) {
    }
}

