/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.syncing;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.preferences.FileExtensionPreferencePage;
import com.aptana.ide.core.ui.syncing.Messages;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SyncGlobalCloakingPreferencePage
extends FileExtensionPreferencePage
implements ModifyListener {
    private Button useCrc;
    private Button compareInBackground;
    private Text initialPoolSize;
    private Text maxPoolSize;

    public void modifyText(ModifyEvent e) {
        if (e.widget instanceof Text) {
            try {
                Integer.parseInt(((Text)e.widget).getText());
                this.setErrorMessage(null);
                this.setValid(true);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.SyncGlobalCloakingPreferencePage_PoolSizeError);
                this.setValid(false);
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        Group smartSyncOptions = new Group(parent, 0);
        smartSyncOptions.setLayout((Layout)new GridLayout());
        smartSyncOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        smartSyncOptions.setText(Messages.SyncGlobalCloakingPreferencePage_SmartSyncOptions);
        this.useCrc = new Button((Composite)smartSyncOptions, 32);
        this.useCrc.setText(Messages.SyncGlobalCloakingPreferencePage_UseCRC);
        this.useCrc.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.syncing.USE_CRC"));
        this.compareInBackground = new Button((Composite)smartSyncOptions, 32);
        this.compareInBackground.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.syncing.COMPARE_IN_BACKGROUND"));
        this.compareInBackground.setText(Messages.SyncGlobalCloakingPreferencePage_CompareInBackground);
        Composite poolSizes = new Composite((Composite)smartSyncOptions, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        poolSizes.setLayout((Layout)layout);
        poolSizes.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(poolSizes, 0);
        label.setText(Messages.SyncGlobalCloakingPreferencePage_InitialPoolSize);
        this.initialPoolSize = new Text(poolSizes, 2052);
        this.initialPoolSize.setText(String.valueOf(this.getPreferenceStore().getInt("com.aptana.ide.syncing.INITIAL_POOL_SIZE")));
        this.initialPoolSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initialPoolSize.addModifyListener((ModifyListener)this);
        label = new Label(poolSizes, 0);
        label.setText(Messages.SyncGlobalCloakingPreferencePage_MaxPoolSize);
        this.maxPoolSize = new Text(poolSizes, 2052);
        this.maxPoolSize.setText(String.valueOf(this.getPreferenceStore().getInt("com.aptana.ide.syncing.MAX_POOL_SIZE")));
        this.maxPoolSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.maxPoolSize.addModifyListener((ModifyListener)this);
        return c;
    }

    protected void performDefaults() {
        this.useCrc.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.syncing.USE_CRC"));
        this.compareInBackground.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.syncing.COMPARE_IN_BACKGROUND"));
        this.initialPoolSize.setText(String.valueOf(this.getPreferenceStore().getDefaultInt("com.aptana.ide.syncing.INITIAL_POOL_SIZE")));
        this.maxPoolSize.setText(String.valueOf(this.getPreferenceStore().getDefaultInt("com.aptana.ide.syncing.MAX_POOL_SIZE")));
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("com.aptana.ide.syncing.USE_CRC", this.useCrc.getSelection());
        this.getPreferenceStore().setValue("com.aptana.ide.syncing.COMPARE_IN_BACKGROUND", this.compareInBackground.getSelection());
        this.getPreferenceStore().setValue("com.aptana.ide.syncing.INITIAL_POOL_SIZE", Integer.parseInt(this.initialPoolSize.getText()));
        this.getPreferenceStore().setValue("com.aptana.ide.syncing.MAX_POOL_SIZE", Integer.parseInt(this.maxPoolSize.getText()));
        return super.performOk();
    }

    protected String getTableDescription() {
        return Messages.SyncGlobalCloakingPreferencePage_AddFileExtensionsToCloak;
    }

    protected String doGetPreferenceID() {
        return "com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CoreUIPlugin.getDefault().getPreferenceStore();
    }

    protected Plugin doGetPlugin() {
        return CoreUIPlugin.getDefault();
    }

    public Object addItem() {
        CloakingInfoDialog dialog = new CloakingInfoDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            return dialog.messageText;
        }
        return null;
    }

    public Object editItem(Object item) {
        CloakingInfoDialog dialog = new CloakingInfoDialog(this.getControl().getShell());
        dialog.setItem(item);
        if (dialog.open() == 0) {
            return dialog.messageText;
        }
        return null;
    }

    public class CloakingInfoDialog
    extends TitleAreaDialog {
        private Text message;
        private String messageText;
        private Button okButton;

        public CloakingInfoDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.SyncGlobalCloakingPreferencePage_IgnoreWarningTitle);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.file_extension_dialog_context");
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            Composite contents = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.numColumns = 2;
            contents.setLayout((Layout)layout);
            contents.setLayoutData((Object)new GridData(1808));
            contents.setFont(parentComposite.getFont());
            this.setTitle(Messages.SyncGlobalCloakingPreferencePage_IgnoreFileFolder);
            this.setMessage(Messages.SyncGlobalCloakingPreferencePage_IgnoteWarningMessage);
            Label label = new Label(contents, 16384);
            label.setText(Messages.SyncGlobalCloakingPreferencePage_FileExtensionLabel);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.message = new Text(contents, 2052);
            this.message.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    if (event.widget == CloakingInfoDialog.this.message) {
                        CloakingInfoDialog.this.okButton.setEnabled(CloakingInfoDialog.this.validateErrorDescriptor());
                    }
                }
            });
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.message.setLayoutData((Object)data);
            this.message.setFocus();
            Dialog.applyDialogFont((Control)parentComposite);
            return contents;
        }

        private boolean validateErrorDescriptor() {
            if ("".equals(this.message.getText())) {
                return false;
            }
            this.messageText = this.message.getText();
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        public String getMessage() {
            return this.messageText;
        }

        public Object setItem(Object item) {
            return null;
        }
    }
}

