/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.dialogs.IAddItemListener;
import com.aptana.ide.core.ui.dialogs.TableEditor;
import com.aptana.ide.core.ui.preferences.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public abstract class FileExtensionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IAddItemListener {
    private ImageRegistry imageRegistry;
    private TableEditor _tableEditor;
    private List<Object> _items = new ArrayList<Object>();
    private static Image blank_icon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

    public String addResource(String newName, String newExtension) {
        if ((newName == null || "".equals(newName)) && (newExtension == null || "".equals(newExtension))) {
            MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.FileExtensionPreferencePage_TTL_ErrorAddingItem, (String)Messages.FileExtensionPreferencePage_MSG_MustEnterAtleastNameOfAnItemOrExtension);
            return null;
        }
        int index = newName.indexOf(42);
        if (index > -1 && newName.equals("*") && (newExtension == null || "".equals(newExtension))) {
            MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.FileExtensionPreferencePage_TTL_ErrorAddingItem, (String)Messages.FileExtensionPreferencePage_MSG_MustEnterExtensionWithAWildcard);
            return null;
        }
        String newFilename = newName;
        if (newExtension != null && newExtension.length() > 0) {
            newFilename = String.valueOf(newFilename) + "." + newExtension;
        }
        newFilename = newFilename.toUpperCase();
        int i = 0;
        while (i < this._items.size()) {
            String item = (String)this._items.get(i);
            int result = newFilename.compareToIgnoreCase(item);
            if (result == 0) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.FileExplorerPreferencePage_FileTypeExists, (String)Messages.FileExplorerPreferencePage_AnEntryAlreadyExistsTitle);
                return null;
            }
            ++i;
        }
        if ("".equals(newExtension)) {
            return newName;
        }
        return String.valueOf(newName) + "." + newExtension;
    }

    protected Control createContents(Composite parent) {
        this._tableEditor = new TableEditor(parent, 0);
        this._tableEditor.setDescription(this.getTableDescription());
        this._tableEditor.setLabelProvider(new TableLabelProvider());
        this._tableEditor.addAddItemListener(this);
        new TableColumn(this._tableEditor.getTable(), 16384);
        this.fillCurrentResourceTypeTable();
        if (this._tableEditor.getTable().getItemCount() > 0) {
            this._tableEditor.getTable().setSelection(0);
        }
        this.applyDialogFont(this._tableEditor);
        return this._tableEditor;
    }

    protected String getTableDescription() {
        return "";
    }

    protected void fillCurrentResourceTypeTable() {
        IPreferenceStore store = this.doGetPreferenceStore();
        String editors = store.getString(this.doGetPreferenceID());
        this.fillResourceTypeTable(editors);
    }

    protected void fillDefaultResourceTypeTable() {
        IPreferenceStore store = this.doGetPreferenceStore();
        String editors = store.getDefaultString(this.doGetPreferenceID());
        this.fillResourceTypeTable(editors);
    }

    protected void fillResourceTypeTable(String editors) {
        if (editors != null) {
            this._items.clear();
            String[] array = editors.split(";");
            this._items.addAll(Arrays.asList(array));
            this._tableEditor.setItems(this._items);
        }
    }

    protected FileEditorMapping getSelectedResourceType() {
        TableItem[] items = this._tableEditor.getTable().getSelection();
        if (items.length > 0) {
            return (FileEditorMapping)items[0].getData();
        }
        return null;
    }

    public void init(IWorkbench aWorkbench) {
    }

    private Image getIcon(String extension) {
        ImageData imageData;
        Image image;
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        if ((image = this.imageRegistry.get(extension)) != null) {
            return image;
        }
        Program program = Program.findProgram((String)extension);
        ImageData imageData2 = imageData = program == null ? null : program.getImageData();
        if (imageData != null) {
            image = new Image((Device)this.getControl().getDisplay(), imageData);
            this.imageRegistry.put(extension, image);
        } else {
            image = blank_icon;
        }
        return image;
    }

    protected void performDefaults() {
        this.fillDefaultResourceTypeTable();
    }

    public boolean performOk() {
        IPreferenceStore store = this.doGetPreferenceStore();
        List<Object> items = this._tableEditor.getItems();
        String resources = StringUtils.join((String)";", (String[])items.toArray(new String[items.size()]));
        store.setValue(this.doGetPreferenceID(), resources);
        return true;
    }

    public Object addItem() {
        FileExtensionDialog dialog = new FileExtensionDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String extension = dialog.getExtension();
            return this.addResource(name, extension);
        }
        return null;
    }

    protected abstract String doGetPreferenceID();

    protected abstract IPreferenceStore doGetPreferenceStore();

    protected abstract Plugin doGetPlugin();

    public Object setItem(Object item) {
        return null;
    }

    public Object editItem(Object item) {
        return null;
    }

    public class TableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            switch (columnIndex) {
                case 0: {
                    String newExtension = StringUtils.replace((String)((String)element), (String)"*.", (String)"");
                    image = FileExtensionPreferencePage.this.getIcon(newExtension);
                    break;
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String name = "";
            switch (columnIndex) {
                case 0: {
                    name = element.toString();
                    break;
                }
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

