/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.URLEncoder;
import com.aptana.ide.core.ui.preferences.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationPreferences {
    private static final String aptanaSettings = ".aptana-settings";
    private static ApplicationPreferences instance;
    private Map<String, String> _keyValuePairs = new HashMap<String, String>();
    private boolean _hasLoaded;
    private ListenerList listenerList = new ListenerList();

    private ApplicationPreferences() {
    }

    public static ApplicationPreferences getInstance() {
        if (instance == null) {
            instance = new ApplicationPreferences();
            instance.loadPreferences();
        }
        return instance;
    }

    private File getSettingsFile() {
        File config = ApplicationPreferences.getConfigurationDirectory();
        return new File(config, aptanaSettings);
    }

    public static File getConfigurationDirectory() {
        String homeDir = System.getProperty("osgi.configuration.area");
        URL fileURL = ApplicationPreferences.uriToURL(homeDir);
        File f = ApplicationPreferences.urlToFile(fileURL);
        f.mkdirs();
        return f;
    }

    public void loadPreferences() {
        File settings = this.getSettingsFile();
        if (this._hasLoaded || !settings.exists()) {
            return;
        }
        FileReader fr = null;
        StringBuilder errors = new StringBuilder();
        try {
            try {
                fr = new FileReader(settings);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                int lineNumber = 1;
                while (line != null) {
                    int colonIndex = line.indexOf(":");
                    if (colonIndex != -1) {
                        String key = line.substring(0, colonIndex);
                        String value = line.substring(colonIndex + 1, line.length());
                        this._keyValuePairs.put(key, value);
                    } else {
                        errors.append("\t[line ");
                        errors.append(lineNumber);
                        errors.append("] - Expected key-value pair, but found '");
                        errors.append(line);
                        errors.append("'\n");
                    }
                    line = br.readLine();
                    ++lineNumber;
                }
            }
            catch (Exception e) {
                ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToReadAptanaSettings, e);
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e2) {
                        ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToCloseAptanaSettings, e2);
                    }
                }
                if (errors.length() > 0) {
                    ApplicationPreferences.logError("Errors found when reading the Aptana settings file:\n" + errors.toString(), null);
                }
                this._hasLoaded = true;
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToCloseAptanaSettings, e);
                }
            }
            if (errors.length() > 0) {
                ApplicationPreferences.logError("Errors found when reading the Aptana settings file:\n" + errors.toString(), null);
            }
            this._hasLoaded = true;
        }
    }

    private File getPreviousDefaultSettingsFile() {
        File previousReleaseSettingsFile = null;
        if ("macosx".equals(Platform.getOS())) {
            previousReleaseSettingsFile = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/Aptana/Aptana Studio/configuration", aptanaSettings);
        } else if ("win32".equals(Platform.getOS())) {
            previousReleaseSettingsFile = new File(String.valueOf(System.getProperty("user.home")) + "\\Application Data\\Aptana\\Aptana Studio\\configuration", aptanaSettings);
        } else if ("linux".equals(Platform.getOS())) {
            previousReleaseSettingsFile = new File(String.valueOf(System.getProperty("user.home")) + "/.Aptana/Aptana Studio/configuration", aptanaSettings);
        }
        if (previousReleaseSettingsFile != null && previousReleaseSettingsFile.exists()) {
            return previousReleaseSettingsFile;
        }
        return null;
    }

    public Map<String, String> loadPreviousPreferences() {
        HashMap<String, String> previousPreferences;
        block14: {
            previousPreferences = new HashMap<String, String>();
            File previousDefaultSettingsFile = this.getPreviousDefaultSettingsFile();
            if (previousDefaultSettingsFile != null) {
                FileReader fr = null;
                try {
                    try {
                        fr = new FileReader(previousDefaultSettingsFile);
                        BufferedReader br = new BufferedReader(fr);
                        String line = br.readLine();
                        while (line != null) {
                            int colonIndex = line.indexOf(":");
                            if (colonIndex == -1) continue;
                            String key = line.substring(0, colonIndex);
                            String value = line.substring(colonIndex + 1, line.length());
                            previousPreferences.put(key, value);
                            line = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        ApplicationPreferences.logError("Unable to read previous Aptana settings", e);
                        if (fr == null) break block14;
                        try {
                            fr.close();
                        }
                        catch (IOException e2) {
                            ApplicationPreferences.logError("Unable to close previous Aptana settings", e2);
                        }
                    }
                }
                finally {
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException e) {
                            ApplicationPreferences.logError("Unable to close previous Aptana settings", e);
                        }
                    }
                }
            }
        }
        return previousPreferences;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public void savePreferences() {
        block13: {
            BufferedWriter bw = null;
            try {
                try {
                    File settings = this.getSettingsFile();
                    FileWriter fw = new FileWriter(settings);
                    bw = new BufferedWriter(fw);
                    Set<Map.Entry<String, String>> entries = this._keyValuePairs.entrySet();
                    for (Map.Entry<String, String> entry : entries) {
                        bw.write(entry.getKey());
                        bw.write(":");
                        bw.write(entry.getValue());
                        bw.newLine();
                    }
                }
                catch (Exception e) {
                    ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToWriteAptanaSettings, e);
                    if (bw == null) break block13;
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToCloseAptanaSettings, e2);
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_UnableToCloseAptanaSettings, e);
                    }
                }
            }
        }
    }

    public boolean getBoolean(String preferenceName) {
        return "true".equals(this.getString(preferenceName));
    }

    public String getString(String preferenceName) {
        if (preferenceName == null) {
            throw new IllegalArgumentException("preference name must be defined");
        }
        String result = null;
        if (this._keyValuePairs.containsKey(preferenceName)) {
            result = this._keyValuePairs.get(preferenceName);
        }
        return result;
    }

    public void setBoolean(String preferenceName, boolean preferenceValue) {
        this.setString(preferenceName, preferenceValue ? "true" : "false");
    }

    public void setString(String preferenceName, String preferenceValue) {
        if (preferenceName == null) {
            throw new IllegalArgumentException("preference name must be defined");
        }
        this._keyValuePairs.put(preferenceName, preferenceValue);
        this.firePropertyChangeEvent(preferenceName, "", preferenceValue);
    }

    public static URL uriToURL(String uri) {
        try {
            String encodedUri = URLEncoder.encode((String)uri, null, null);
            URI uri2 = new URI(encodedUri);
            return uri2.toURL();
        }
        catch (MalformedURLException e) {
            ApplicationPreferences.logError(StringUtils.format((String)Messages.ApplicationPreferences_ERR_UnableToConvertURIToURL, (String)uri), e);
            return null;
        }
        catch (URISyntaxException e) {
            ApplicationPreferences.logError(StringUtils.format((String)Messages.ApplicationPreferences_ERR_UnableToConvertURIToURLSyntaxIsIncorrect, (String)uri), e);
            return null;
        }
    }

    public static File urlToFile(URL url) {
        try {
            URI uri = new URI(url.toString());
            if ("file".equals(uri.getScheme())) {
                return new File(uri.getSchemeSpecificPart());
            }
        }
        catch (Exception e) {
            ApplicationPreferences.logError(Messages.ApplicationPreferences_ERR_FailedToConvertURLToFile, e);
        }
        return null;
    }

    private static void logError(String errorMessage, Throwable e) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 0, errorMessage, e);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }
}

