/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.dialogs;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.core.ui.dialogs.IAddItemListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor
extends Composite
implements Listener {
    private Button addResourceTypeButton;
    private Button editResourceTypeButton;
    private Button removeResourceTypeButton;
    private Label label;
    List<Object> _items = new ArrayList<Object>();
    private TableViewer _viewer;
    private List<IAddItemListener> _listeners = new ArrayList<IAddItemListener>();
    private boolean editEnabled = false;

    public void setDescription(String description) {
        this.label.setText(description);
    }

    public TableEditor(Composite parent, int style) {
        super(parent, style);
        this.createComposite(this);
    }

    public TableEditor(Composite parent, int style, boolean editEnabled) {
        super(parent, style);
        this.editEnabled = editEnabled;
        this.createComposite(this);
    }

    public void setItems(List<Object> items) {
        this._items = items;
        this._viewer.setInput(this._items);
        this.refreshTable();
    }

    public List<Object> getItems() {
        return this._items;
    }

    public Table getTable() {
        return this._viewer.getTable();
    }

    public Button getAddButton() {
        return this.addResourceTypeButton;
    }

    public Button getEditButton() {
        return this.editResourceTypeButton;
    }

    public Button getRemoveButton() {
        return this.removeResourceTypeButton;
    }

    private TableViewer createTable(Composite parent) {
        this._viewer = new TableViewer(parent, 67586);
        Table serverTable = this._viewer.getTable();
        serverTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this._viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this._viewer.setSorter((ViewerSorter)new TableSorter());
        this._viewer.setInput(this._items);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableEditor.this.updateEnabledState();
            }
        });
        this.updateEnabledState();
        return this._viewer;
    }

    private void createComposite(Composite pageComponent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        pageComponent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.label = new Label(pageComponent, 16448);
        this.label.setText("");
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.label.setLayoutData((Object)data);
        Composite groupComponent = new Composite(pageComponent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupLayout.numColumns = 3;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addResourceTypeButton = new Button(groupComponent, 8);
        this.addResourceTypeButton.setToolTipText(StringUtils.ellipsify((String)CoreStrings.ADD));
        this.addResourceTypeButton.addListener(13, (Listener)this);
        this.addResourceTypeButton.setImage(SWTUtils.getImage(CoreUIPlugin.getDefault(), "/icons/add.gif"));
        if (this.editEnabled) {
            this.editResourceTypeButton = new Button(groupComponent, 8);
            this.editResourceTypeButton.setToolTipText(StringUtils.ellipsify((String)CoreStrings.EDIT));
            this.editResourceTypeButton.addListener(13, (Listener)this);
            this.editResourceTypeButton.setImage(SWTUtils.getImage(CoreUIPlugin.getDefault(), "/icons/edit.png"));
        }
        this.removeResourceTypeButton = new Button(groupComponent, 8);
        this.removeResourceTypeButton.setToolTipText(CoreStrings.REMOVE);
        this.removeResourceTypeButton.addListener(13, (Listener)this);
        this.removeResourceTypeButton.setImage(SWTUtils.getImage(CoreUIPlugin.getDefault(), "/icons/delete.gif"));
        this.createTable(pageComponent);
    }

    public void setSorter(ViewerSorter sorter) {
        this._viewer.setSorter(sorter);
    }

    public void setLabelProvider(ITableLabelProvider provider) {
        this._viewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        this._viewer.setContentProvider((IContentProvider)provider);
    }

    public void removeSelectedResourceType() {
        Table foldingTable = this.getTable();
        TableItem[] items = foldingTable.getSelection();
        int[] indices = foldingTable.getSelectionIndices();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                this._items.remove(items[i].getData());
                items[i].dispose();
                ++i;
            }
            if (indices.length > 1) {
                int last = indices[indices.length - 1];
                if (foldingTable.getItemCount() - 1 >= last) {
                    foldingTable.setSelection(last);
                } else if (foldingTable.getItemCount() > 0) {
                    foldingTable.setSelection(foldingTable.getItemCount() - 1);
                }
            } else if (indices.length == 1) {
                if (foldingTable.getItemCount() - 1 >= indices[0]) {
                    foldingTable.setSelection(indices[0]);
                } else if (foldingTable.getItemCount() > 0) {
                    foldingTable.setSelection(foldingTable.getItemCount() - 1);
                }
            }
        }
        this.removeResourceTypeButton.setEnabled(foldingTable.getSelectionCount() > 0);
    }

    public void editSelectedResourceType() {
        ISelection selection = this._viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection select = (IStructuredSelection)selection;
            Object o = select.getFirstElement();
            int i = 0;
            while (i < this._listeners.size()) {
                IAddItemListener l = this._listeners.get(i);
                o = l.editItem(o);
                this.refreshTable();
                ++i;
            }
        }
    }

    public void addAddItemListener(IAddItemListener listener) {
        this._listeners.add(listener);
    }

    public void removeAddItemListener(IAddItemListener listener) {
        this._listeners.add(listener);
    }

    private void refreshTable() {
        if (this._viewer != null) {
            this._viewer.refresh();
            Table t = this._viewer.getTable();
            TableColumn[] columns = t.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                column.pack();
                ++i;
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addResourceTypeButton) {
            int i = 0;
            while (i < this._listeners.size()) {
                IAddItemListener l = this._listeners.get(i);
                Object o = l.addItem();
                if (o != null) {
                    this._items.add(o);
                    this.refreshTable();
                }
                ++i;
            }
        } else if (event.widget == this.editResourceTypeButton) {
            this.editSelectedResourceType();
        } else if (event.widget == this.removeResourceTypeButton) {
            this.removeSelectedResourceType();
        }
        this.updateEnabledState();
    }

    public void updateEnabledState() {
        if (this.removeResourceTypeButton != null) {
            this.removeResourceTypeButton.setEnabled(this._viewer.getSelection() != null && !this._viewer.getSelection().isEmpty());
        }
        if (this.editResourceTypeButton != null) {
            this.editResourceTypeButton.setEnabled(this._viewer.getSelection() != null && !this._viewer.getSelection().isEmpty());
        }
    }

    public class TableContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList elements = (ArrayList)inputElement;
            ArrayList newElements = new ArrayList();
            for (Object element : elements) {
                newElements.add(element);
            }
            return newElements.toArray();
        }
    }

    public class TableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String name = "";
            name = element.toString();
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableSorter
    extends ViewerSorter {
        TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return super.compare(viewer, e1, e2);
        }
    }
}

