/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.dialogs;

import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.ServiceError;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.model.user.UserRequestBuilder;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.dialogs.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AptanaSignInDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    private static final String IMAGE = "icons/aptana_dialog_tag.png";
    private static final String FORGOT_PASSWORD = "http://id.aptana.com/reset_password";
    private static final String WHAT_IS_APTANA_ID = "http://www.aptana.com/aptana_id";
    private static final String CREATE_ID = "https://id.aptana.com/register";
    private Text username;
    private Text password;
    private Link forgotPassword;
    private Link whatIsIt;
    private Link createId;
    private final boolean allowAnonymous;
    private KeyAdapter signInKeyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if ((e.character == '\r' || e.character == '\n') && AptanaSignInDialog.this.getButton(0).getEnabled()) {
                AptanaSignInDialog.this.signIn();
            }
        }
    };

    public AptanaSignInDialog(Shell parentShell) {
        this(parentShell, false);
    }

    public AptanaSignInDialog(Shell parentShell, boolean allowAnonymous) {
        super(parentShell);
        this.setShellStyle(AptanaSignInDialog.getDefaultOrientation() | 0x10 | 0x10000 | 0x860);
        this.setHelpAvailable(false);
        this.allowAnonymous = allowAnonymous;
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.forgotPassword) {
            CoreUIUtils.openBrowserURL(FORGOT_PASSWORD);
        } else if (source == this.whatIsIt) {
            CoreUIUtils.openBrowserURL(WHAT_IS_APTANA_ID);
        } else if (source == this.createId) {
            CoreUIUtils.openBrowserURL(CREATE_ID);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AptanaSignInWidget_Title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AptanaSignInWidget_LBL_MainTitle);
        this.setTitleImage(CoreUIPlugin.getImage(IMAGE));
        this.setMessage(Messages.AptanaSignInWidget_LBL_Subtitle);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        main.setLayoutData((Object)gridData);
        this.createMiddleColumn(main);
        this.createRightColumn(main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.allowAnonymous) {
            this.createButton(parent, 9, Messages.AptanaSignInDialog_LBL_Anonymous, false);
        }
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.AptanaSignInWidget_LBL_SignIn);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(-1, -1, true);
    }

    protected void buttonPressed(int buttonId) {
        if (9 == buttonId) {
            this.setReturnCode(9);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.signIn();
    }

    private void signIn() {
        if (!this.validate()) {
            return;
        }
        User user = new User(this.username.getText().toLowerCase(), this.password.getText(), null, null, null, null, null);
        try {
            user.setDefaultLocation(new URL(AptanaUser.LOGINS));
            user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
            user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
            AptanaUser.signOut();
            user.update();
            if (user.hasLocation()) {
                user.update();
                AptanaUser.signIn((String)this.username.getText().toLowerCase(), (String)this.password.getText(), (URL)user.getLocation(), (String)user.getId());
                super.okPressed();
                return;
            }
            if (user.getLastServiceErrors() != null && ((ServiceError[])user.getLastServiceErrors().getItems()).length > 0) {
                String message = ((ServiceError[])user.getLastServiceErrors().getItems())[0].getMessage();
                if (message.length() > 1) {
                    message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1, message.length());
                }
                this.setErrorMessage(message);
            } else if (!OnlineDetectionService.isAvailable((URL)new URL(WHAT_IS_APTANA_ID))) {
                this.setErrorMessage(Messages.AptanaSignInDialog_Label_ErrorOffline);
            } else {
                this.setErrorMessage(Messages.AptanaSignInWidget_Label_ErrorVerified);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Messages.AptanaSignInWidget_Label_ErrorVerified);
        }
        this.getButton(0).setEnabled(false);
    }

    private boolean validate() {
        if (this.username.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.AptanaSignInWidget_LBL_ErrorUsername);
            this.getButton(0).setEnabled(false);
            return false;
        }
        if (this.password.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.AptanaSignInWidget_LBL_ErrorPassword);
            this.getButton(0).setEnabled(false);
            return false;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        return true;
    }

    private Composite createMiddleColumn(Composite parent) {
        Composite middle = new Composite(parent, 0);
        middle.setLayout((Layout)new GridLayout(2, false));
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(middle, 16384);
        label.setText(Messages.AptanaSignInWidget_LBL_Username);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.username = new Text(middle, 2052);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 125;
        this.username.setLayoutData((Object)gridData);
        this.username.addModifyListener((ModifyListener)this);
        this.username.addKeyListener((KeyListener)this.signInKeyAdapter);
        this.username.forceFocus();
        label = new Label(middle, 16384);
        label.setText(Messages.AptanaSignInWidget_LBL_Password);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.password = new Text(middle, 0x400804);
        gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 125;
        this.password.setLayoutData((Object)gridData);
        this.password.addModifyListener((ModifyListener)this);
        this.password.addKeyListener((KeyListener)this.signInKeyAdapter);
        return middle;
    }

    private Composite createRightColumn(Composite parent) {
        Composite right = new Composite(parent, 0);
        right.setLayout((Layout)new GridLayout());
        right.setLayoutData((Object)new GridData(4, 4, false, true));
        this.whatIsIt = new Link(right, 0);
        this.whatIsIt.setText("<a>" + Messages.AptanaSignInWidget_IDLink + "</a>");
        this.whatIsIt.addSelectionListener((SelectionListener)this);
        this.forgotPassword = new Link(right, 0);
        this.forgotPassword.setText("<a>" + Messages.AptanaSignInWidget_PasswordLink + "</a>");
        this.forgotPassword.addSelectionListener((SelectionListener)this);
        this.createId = new Link(right, 0);
        this.createId.setText("<a>" + Messages.AptanaSignInWidget_LBL_CreateID + "</a>");
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalIndent = 5;
        this.createId.setLayoutData((Object)gridData);
        this.createId.addSelectionListener((SelectionListener)this);
        return right;
    }
}

