/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.browser;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.browser.IBrowser;
import com.aptana.ide.core.ui.browser.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class BrowserRegistry {
    public static final String EXTENSION_NAME = "browser";
    public static final String EXTENSION_POINT = String.valueOf(CoreUIPlugin.ID) + "." + "browser";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ID_ATTRIBUTE = "id";
    private static BrowserRegistry registry = null;
    private Map<String, IConfigurationElement> browsers = new HashMap<String, IConfigurationElement>();

    private BrowserRegistry() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (EXTENSION_NAME.equals(element.getName())) {
                String className = element.getAttribute(CLASS_ATTRIBUTE);
                String id = element.getAttribute(ID_ATTRIBUTE);
                if (className != null && id != null) {
                    this.browsers.put(id, element);
                }
            }
            ++n2;
        }
    }

    public IBrowser getBrowser(String id) {
        IBrowser browser = null;
        if (this.browsers.containsKey(id)) {
            IConfigurationElement element = this.browsers.get(id);
            try {
                Object obj = element.createExecutableExtension(CLASS_ATTRIBUTE);
                if (obj instanceof IBrowser) {
                    browser = (IBrowser)obj;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.BrowserRegistry_ERR_ErrorCreatingBrowser, (Throwable)e);
            }
        }
        return browser;
    }

    public static synchronized BrowserRegistry getRegistry() {
        if (registry == null) {
            registry = new BrowserRegistry();
        }
        return registry;
    }
}

