/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.RunDiagnosticActionDelegate;
import com.aptana.ide.core.ui.actions.Messages;
import com.aptana.ide.core.ui.actions.SubmitBugDialog;
import com.aptana.ide.core.ui.dialogs.AptanaSignInDialog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.ConfigurationInfo;

public class SubmitBugAction
implements IWorkbenchWindowActionDelegate {
    private static final String FORM_URL = "https://content.aptana.com/aptana/studio/issues/start_issue.php";

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (OnlineDetectionService.getInstance().getStatus() == OnlineDetectionService.StatusMode.OFFLINE) {
            this.showOfflineWarning();
            return;
        }
        User user = AptanaUser.getSignedInUser();
        boolean anonymous = false;
        if (user == null || !user.hasCredentials()) {
            AptanaSignInDialog dialog = new AptanaSignInDialog(CoreUIUtils.getActiveShell(), true);
            int ret = dialog.open();
            if (ret == 1) {
                return;
            }
            if (ret == 9) {
                anonymous = true;
            }
        }
        this.submitBug(anonymous);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void showOfflineWarning() {
        MessageDialog.openWarning((Shell)CoreUIUtils.getActiveShell(), (String)Messages.SubmitBugAction_Offline_Title, (String)Messages.SubmitBugAction_Offline_Message);
    }

    private void submitBug(boolean anonymous) {
        try {
            URLConnection connection = new URL(FORM_URL).openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            StringBuilder content = new StringBuilder();
            if (anonymous) {
                content.append("username=").append("studio");
                content.append("&password=").append("studio101");
            } else {
                User user = AptanaUser.getSignedInUser();
                content.append("username=").append(SubmitBugAction.encode(user.getUsername()));
                content.append("&password=").append(SubmitBugAction.encode(user.getPassword()));
            }
            content.append("&build_version=").append(SubmitBugAction.encode(PluginUtils.getPluginVersion((Plugin)CoreUIPlugin.getDefault())));
            content.append("&log_file=").append(SubmitBugAction.encode(SubmitBugAction.getLogContent()));
            content.append("&config_file=").append(SubmitBugAction.encode(SubmitBugAction.getConfigContent()));
            content.append("&diagnostic_file=").append(SubmitBugAction.encode(SubmitBugAction.getDiagnosisContent()));
            content.append("&user_os=").append(SubmitBugAction.encode(SubmitBugAction.getUserOS()));
            dos.writeBytes(content.toString());
            dos.flush();
            dos.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = input.readLine();
            if (line != null) {
                this.openSubmitDialog(line);
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)MessageFormat.format(Messages.SubmitBugAction_ERR_Access, FORM_URL), (Throwable)e);
        }
        catch (IOException e) {
            this.showOfflineWarning();
            IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)MessageFormat.format(Messages.SubmitBugAction_ERR_Interact, FORM_URL), (Throwable)e);
        }
    }

    private void openSubmitDialog(String url) {
        SubmitBugDialog dialog = new SubmitBugDialog(CoreUIUtils.getActiveShell(), url);
        dialog.open();
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return text;
    }

    /*
     * Loose catch block
     */
    private static String getLogContent() {
        String string;
        BufferedReader input;
        block18: {
            String line;
            String logFile = System.getProperty("osgi.logfile");
            input = null;
            input = new BufferedReader(new FileReader(logFile));
            ArrayList<String> lines = new ArrayList<String>();
            int index = 0;
            int lastSessionIndex = 0;
            while ((line = input.readLine()) != null) {
                lines.add(line);
                if (line.startsWith("!SESSION")) {
                    lastSessionIndex = index;
                }
                ++index;
            }
            StringBuilder content = new StringBuilder();
            int size = lines.size();
            int i = lastSessionIndex;
            while (i < size) {
                content.append((String)lines.get(i)).append("\n");
                ++i;
            }
            string = content.toString();
            if (input == null) break block18;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (FileNotFoundException fileNotFoundException) {
            block19: {
                if (input == null) break block19;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            return "Unable to locate the log file";
        }
        catch (IOException iOException) {
            block20: {
                if (input == null) break block20;
                {
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    input.close();
                }
                catch (IOException iOException3) {}
            }
            return "IO Exception when reading the log file";
        }
    }

    private static String getConfigContent() {
        String content;
        try {
            content = ConfigurationInfo.getSystemSummary();
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        StringBuilder shortenedContent = new StringBuilder();
        StringTokenizer tk = new StringTokenizer(content, "\n");
        while (tk.hasMoreTokens()) {
            String line = tk.nextToken();
            if (line.startsWith("osgi.bundles=") || line.startsWith("org.osgi.framework.system.packages=")) continue;
            if (line.startsWith("*** User Preferences:")) break;
            shortenedContent.append(line).append("\n");
        }
        return shortenedContent.toString();
    }

    private static String getDiagnosisContent() {
        return RunDiagnosticActionDelegate.getLogContent(true);
    }

    private static String getUserOS() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux")) {
            return "Other Linux";
        }
        if (os.startsWith("Mac OS")) {
            return "Mac OS X";
        }
        return os;
    }
}

