/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public final class PreferenceUtils {
    public static final String IGNORE_COLOR_KEY = "IGNORE_COLOR_KEY";

    private PreferenceUtils() {
    }

    public static void persistSettingsToPreferenceStore(IPreferenceStore store, String key, Table table) {
        TableColumn[] columns = table.getColumns();
        int a = 0;
        while (a < columns.length) {
            int width = columns[a].getWidth();
            store.setValue(PreferenceUtils.getColumnKey(key, a), width);
            ++a;
        }
    }

    public static void restoreSettingsFromPreferenceStore(IPreferenceStore store, String key, final Table table) {
        TableColumn[] columns = table.getColumns();
        boolean found = PreferenceUtils.actuallyRestore(store, key, columns);
        if (table.getLayout() instanceof TableLayout && found) {
            final TableLayout ll = (TableLayout)table.getLayout();
            table.setLayout(null);
            table.addControlListener(new ControlListener(){
                int inc = 0;

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    if (this.inc == 1) {
                        table.setLayout((Layout)ll);
                    }
                    ++this.inc;
                }
            });
        }
    }

    private static boolean actuallyRestore(IPreferenceStore store, String key, TableColumn[] columns) {
        boolean found = false;
        int a = 0;
        while (a < columns.length) {
            int int1 = store.getInt(PreferenceUtils.getColumnKey(key, a));
            if (int1 != 0) {
                found = true;
                columns[a].setWidth(int1);
            }
            ++a;
        }
        return found;
    }

    public static void restoreSettingsFromPreferenceStore(IPreferenceStore store, String key, final Tree tree) {
        TreeColumn[] columns = tree.getColumns();
        boolean found = false;
        int a = 0;
        while (a < columns.length) {
            int int1 = store.getInt(PreferenceUtils.getColumnKey(key, a));
            if (int1 != 0) {
                columns[a].setWidth(int1);
                found = true;
            }
            ++a;
        }
        if (tree.getLayout() instanceof TableLayout && found) {
            final TableLayout ll = (TableLayout)tree.getLayout();
            tree.setLayout(null);
            tree.addControlListener(new ControlListener(){
                int inc = 0;

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    if (this.inc == 1) {
                        tree.setLayout((Layout)ll);
                    }
                    ++this.inc;
                }
            });
        }
    }

    private static String getColumnKey(String key, int num) {
        return String.valueOf(key) + ".column." + num;
    }

    public static void persistSettingsToPreferenceStore(IPreferenceStore store, String key, Tree tree) {
        TreeColumn[] columns = tree.getColumns();
        int a = 0;
        while (a < columns.length) {
            int width = columns[a].getWidth();
            store.setValue(PreferenceUtils.getColumnKey(key, a), width);
            ++a;
        }
    }

    public static void persist(final IPreferenceStore store, final Table table, final String key) {
        PreferenceUtils.restoreSettingsFromPreferenceStore(store, key, table);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PreferenceUtils.persistSettingsToPreferenceStore(store, key, table);
            }
        });
    }

    public static void persist(final IPreferenceStore store, final Tree tree, final String key) {
        PreferenceUtils.restoreSettingsFromPreferenceStore(store, key, tree);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PreferenceUtils.persistSettingsToPreferenceStore(store, key, tree);
            }
        });
    }

    public static void registerBackgroundColorPreference(final Control control, final String id) {
        final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        PreferenceUtils.setBackround(control, id, themeManager);
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals(id)) {
                    PreferenceUtils.setBackround(control, id, themeManager);
                }
            }
        };
        themeManager.addPropertyChangeListener(propertyChangeListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                themeManager.removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    public static void registerFontPreference(final Control control, final String id) {
        final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        PreferenceUtils.setFont(control, id, themeManager);
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals(id)) {
                    PreferenceUtils.setFont(control, id, themeManager);
                }
            }
        };
        themeManager.addPropertyChangeListener(propertyChangeListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                themeManager.removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    private static void setFont(Control control, String id, IThemeManager themeManager) {
        Font color = themeManager.getCurrentTheme().getFontRegistry().get(id);
        control.setFont(color);
    }

    public static void registerForegroundColorPreference(final Control control, final String id) {
        final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        PreferenceUtils.setForeground(control, id, themeManager);
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals(id)) {
                    PreferenceUtils.setForeground(control, id, themeManager);
                }
            }
        };
        themeManager.addPropertyChangeListener(propertyChangeListener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                themeManager.removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    private static void setForeground(Control control, String id, IThemeManager themeManager) {
        Color color = themeManager.getCurrentTheme().getColorRegistry().get(id);
        PreferenceUtils.internalSet(control, color);
    }

    private static void setBackround(Control control, String id, IThemeManager themeManager) {
        Color color = themeManager.getCurrentTheme().getColorRegistry().get(id);
        control.setBackground(color);
    }

    public static void ignoreForegroundColorPreference(Control control) {
        if (control != null) {
            control.setData(IGNORE_COLOR_KEY, (Object)Boolean.TRUE);
        }
    }

    private static void internalSet(Control control, Color color) {
        if (!Boolean.TRUE.equals(control.getData(IGNORE_COLOR_KEY))) {
            control.setForeground(color);
        }
        if (control instanceof Composite) {
            Composite cm = (Composite)control;
            Control[] children = cm.getChildren();
            int a = 0;
            while (a < children.length) {
                PreferenceUtils.internalSet(children[a], color);
                ++a;
            }
        }
    }
}

