/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.EventInfo;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.navigator.CommonNavigator;

public class InitialStartup {
    private static final String EDITORAREA_CUSTOM_PAINT = "editorarea.custom_paint";
    private static IPerspectiveListener perpListener;
    private static Image editorAreaImage;
    private static Image editorAreaImage_studio;
    private static Image editorAreaImage_radrails;
    private static PaintListener paintListener;
    private static Map<IWorkbenchWindow, IPerspectiveListener> windows;

    static {
        paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                int drawHeight;
                int drawWidth;
                Rectangle rect = ((Composite)e.widget).getClientArea();
                Rectangle imageSize = editorAreaImage.getBounds();
                if (rect.width > imageSize.width && rect.height > imageSize.height) {
                    drawWidth = imageSize.width;
                    drawHeight = imageSize.height;
                } else if (rect.width * imageSize.height > rect.height * imageSize.width) {
                    drawHeight = rect.height;
                    drawWidth = drawHeight * imageSize.width / imageSize.height;
                } else {
                    drawWidth = rect.width;
                    drawHeight = drawWidth * imageSize.height / imageSize.width;
                }
                e.gc.drawImage(editorAreaImage, 0, 0, imageSize.width, imageSize.height, (rect.width - drawWidth) / 2, (rect.height - drawHeight) / 2, drawWidth, drawHeight);
            }
        };
        windows = new HashMap<IWorkbenchWindow, IPerspectiveListener>();
    }

    public static void start() {
        IPreferenceStore prefs;
        boolean hasRunFirstStartup;
        ImageDescriptor imageDescriptor_radrails;
        ImageDescriptor imageDescriptor = CoreUIPlugin.getImageDescriptor("icons/editorarea.gif");
        if (imageDescriptor != null) {
            editorAreaImage = editorAreaImage_studio = imageDescriptor.createImage();
        }
        if ((imageDescriptor_radrails = CoreUIPlugin.getImageDescriptor("icons/editorarea_radrails.gif")) != null) {
            editorAreaImage_radrails = imageDescriptor_radrails.createImage();
        }
        if (!(hasRunFirstStartup = (prefs = CoreUIPlugin.getDefault().getPreferenceStore()).getBoolean("com.aptana.ide.core.ui.PREF_KEY_FIRST_STARTUP"))) {
            InitialStartup.initForFirstTimeStartup();
            prefs.setValue("com.aptana.ide.core.ui.PREF_KEY_FIRST_STARTUP", true);
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        perpListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                InitialStartup.recordPerspectiveActivation(perspective);
                InitialStartup.checkPerspective(page, perspective);
                InitialStartup.setEditorAreaPaintListener(page);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow w = workbench.getActiveWorkbenchWindow();
                InitialStartup.addListenerToWindow(w);
            }
        });
        InitialStartup.addWindowListener(workbench);
        final IPartListener _partListener = InitialStartup.createPartActivationListener();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getPartService().addPartListener(_partListener);
                }
            }
        });
    }

    protected static void recordPerspectiveActivation(IPerspectiveDescriptor perspective) {
        String keyName = "perspective.activated";
        EventInfo[] events = EventLogger.getInstance().getEvents(keyName);
        String perspectiveId = perspective.getId();
        if (events != null && events.length > 0) {
            EventInfo[] eventInfoArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                EventInfo event = eventInfoArray[n2];
                String msg = event.getMessage();
                if (msg != null && msg.equals(perspectiveId)) {
                    return;
                }
                ++n2;
            }
        }
        EventLogger.getInstance().logEvent(keyName, perspectiveId);
    }

    private static void addWindowListener(IWorkbench workbench) {
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePerspectiveListener(perpListener);
                if (windows.containsKey(window)) {
                    windows.remove(window);
                }
            }

            public void windowOpened(IWorkbenchWindow window) {
                if (!windows.containsKey(window)) {
                    InitialStartup.addListenerToWindow(window);
                    windows.put(window, perpListener);
                }
            }
        });
    }

    private static IPartListener createPartActivationListener() {
        IPartListener _partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                try {
                    WorkbenchPage wp;
                    Perspective persp;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (part.getSite().getPart() instanceof CommonNavigator && page instanceof WorkbenchPage && WebPerspectiveFactory.isSameOrDescendantPerspective((persp = (wp = (WorkbenchPage)page).getActivePerspective()).getDesc())) {
                        String[] existing = persp.getNewWizardShortcuts();
                        List<String> fileWizards = WebPerspectiveFactory.getFileWizardShortcuts();
                        ArrayList<String> ids = new ArrayList<String>();
                        int i = 0;
                        while (i < existing.length) {
                            if (!fileWizards.contains(existing[i])) {
                                ids.add(existing[i]);
                            }
                            ++i;
                        }
                        List<String> projectWizards = WebPerspectiveFactory.getProjectWizardShortcuts();
                        for (String id : projectWizards) {
                            if (ids.contains(id)) continue;
                            ids.add(id);
                        }
                        persp.setNewWizardActionIds(ids);
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialStartup_UnableToSwitchNewFileWizardListing, (Throwable)ex);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                try {
                    WorkbenchPage wp;
                    Perspective persp;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (part.getSite().getPart() instanceof CommonNavigator && WebPerspectiveFactory.isSameOrDescendantPerspective((persp = (wp = (WorkbenchPage)page).getActivePerspective()).getDesc())) {
                        String[] existing = persp.getNewWizardShortcuts();
                        List<String> projectWizards = WebPerspectiveFactory.getProjectWizardShortcuts();
                        ArrayList<String> ids = new ArrayList<String>();
                        int i = 0;
                        while (i < existing.length) {
                            if (!projectWizards.contains(existing[i])) {
                                ids.add(existing[i]);
                            }
                            ++i;
                        }
                        List<String> fileWizards = WebPerspectiveFactory.getFileWizardShortcuts();
                        for (String id : fileWizards) {
                            if (ids.contains(id)) continue;
                            ids.add(id);
                        }
                        persp.setNewWizardActionIds(ids);
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.InitialStartup_UnableToSwitchNewFileWizardListing, (Throwable)ex);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }
        };
        return _partListener;
    }

    private static void addListenerToWindow(final IWorkbenchWindow w) {
        if (w == null) {
            return;
        }
        IWorkbenchPage page = w.getActivePage();
        if (page != null) {
            InitialStartup.checkPerspective(page, page.getPerspective());
            w.addPerspectiveListener(perpListener);
            w.getPartService().addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    IWorkbenchPage page = w.getActivePage();
                    if (part instanceof IEditorPart && page != null && page.getEditorReferences().length == 0) {
                        InitialStartup.setEditorAreaPaintListener(page);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
            InitialStartup.setEditorAreaPaintListener(page);
        }
    }

    private static boolean checkPerspective(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (WebPerspectiveFactory.isSameOrDescendantPerspective(perspective)) {
            InitialStartup.onWebPerspectiveActivated(page);
            return true;
        }
        return false;
    }

    private static void onWebPerspectiveActivated(IWorkbenchPage page) {
        IPreferenceStore prefs = CoreUIPlugin.getDefault().getPreferenceStore();
        int lastWorkspace = prefs.getInt("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION");
        if (65 > lastWorkspace) {
            prefs.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION", 65);
            prefs.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_RESET_PERSPECTIVE", false);
            WebPerspectiveFactory.resetPerspective(page);
        }
    }

    private static void initForFirstTimeStartup() {
        IPreferenceStore prefs = CoreUIPlugin.getDefault().getPreferenceStore();
        prefs.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION", 65);
    }

    private static void setEditorAreaPaintListener(IWorkbenchPage page) {
        if (editorAreaImage_studio == null && editorAreaImage_radrails == null) {
            return;
        }
        ViewForm control = null;
        EditorAreaHelper editorAreaHelper = ((WorkbenchPage)page).getEditorPresentation();
        if (editorAreaHelper == null) {
            return;
        }
        EditorStack layoutPart = editorAreaHelper.getWorkbookFromID("DefaultEditorWorkbook");
        if (layoutPart == null) {
            return;
        }
        Control[] list = ((Composite)layoutPart.getControl()).getChildren();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof ViewForm) {
                control = (ViewForm)list[i];
                break;
            }
            ++i;
        }
        if (control == null) {
            return;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (WebPerspectiveFactory.isSameOrDescendantPerspective(perspective) || perspective.getId().equals("org.radrails.rails.ui.PerspectiveRails") || perspective.getId().equals("org.rubypeople.rdt.ui.PerspectiveRuby")) {
            if (perspective.getId().equals("org.radrails.rails.ui.PerspectiveRails") || perspective.getId().equals("org.rubypeople.rdt.ui.PerspectiveRuby")) {
                editorAreaImage = editorAreaImage_radrails;
            } else if (WebPerspectiveFactory.isSameOrDescendantPerspective(perspective)) {
                editorAreaImage = editorAreaImage_studio;
            }
            if (control.getData(EDITORAREA_CUSTOM_PAINT) != null) {
                return;
            }
            control.addPaintListener(paintListener);
            control.setData(EDITORAREA_CUSTOM_PAINT, (Object)Boolean.TRUE);
            control.redraw();
        } else {
            if (control.getData(EDITORAREA_CUSTOM_PAINT) == null) {
                return;
            }
            control.removePaintListener(paintListener);
            control.setData(EDITORAREA_CUSTOM_PAINT, null);
            control.redraw();
        }
    }
}

