/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.EmptyEditorInput;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.osgi.framework.Bundle;

public final class CoreUIUtils {
    private static final String FILE_COLON = "file:";
    private static final String FILE_SLASH = "file:/";
    private static final String FILE_SLASH_SLASH = "file://";
    private static final String FILE_SLASH_SLASH_SLASH = "file:///";
    public static boolean onMacOSX;
    public static boolean onNix;
    public static boolean onWindows;
    public static boolean onLinux;
    public static boolean runningOnWindows;
    public static boolean onCocoa;
    public static boolean inEclipse34orHigher;
    public static boolean inEclipse35orHigher;
    public static String URL_SEPARATOR;

    static {
        String[] parts;
        onMacOSX = "macosx".equals(Platform.getOS());
        onNix = "linux".equals(Platform.getOS()) || "solaris".equals(Platform.getOS()) || "aix".equals(Platform.getOS()) || "hpux".equals(Platform.getOS()) || "qnx".equals(Platform.getOS());
        onWindows = "win32".equals(Platform.getOS());
        onLinux = "linux".equals(Platform.getOS());
        runningOnWindows = System.getProperty("os.name").startsWith("Win");
        onCocoa = false;
        inEclipse34orHigher = false;
        inEclipse35orHigher = false;
        URL_SEPARATOR = "/";
        String version = System.getProperty("osgi.framework.version");
        if (version != null && version.startsWith("3.") && (parts = version.split("\\.")).length > 1) {
            try {
                int minorVersion = Integer.parseInt(parts[1]);
                if (minorVersion > 3) {
                    inEclipse34orHigher = true;
                }
                if (minorVersion > 4) {
                    inEclipse35orHigher = true;
                    onCocoa = "cocoa".equals(System.getProperty("osgi.ws"));
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_UnableToParseEclipseVersion, (String)version), (Throwable)e);
            }
        }
    }

    private CoreUIUtils() {
    }

    public static ImageDescriptor getImageDescriptor(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imageFilePath);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public static IWorkbenchPage getActivePage() {
        return CoreUIPlugin.getActivePage();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow window;
        Shell shell = CoreUIUtils.getDisplay().getActiveShell();
        if (shell == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public static void placeDialogInScreenCenter(Shell parent, Shell shell) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static String getPluginLocation(Plugin plugin) {
        File f = CoreUIUtils.getPluginFile(plugin);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public static File getPluginFile(Plugin plugin) {
        try {
            Bundle bunble = plugin.getBundle();
            URL u = FileLocator.find((Bundle)bunble, (IPath)new Path(""), null);
            if (u != null) {
                u = FileLocator.toFileURL((URL)u);
                return new File(u.getFile());
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)plugin, (String)Messages.CoreUIUtils_PluginLocationError, (Throwable)ex);
        }
        return null;
    }

    public static String getWorkspaceDirectory() {
        URL url = Platform.getInstanceLocation().getURL();
        return url.getPath();
    }

    public static String getStringOfIFileLocation(IFile file) {
        String location = null;
        IPath path = CoreUIUtils.getPathOfIFileLocation(file);
        if (path != null) {
            location = path.makeAbsolute().toOSString();
        }
        return location;
    }

    public static IPath getPathOfIFileLocation(IFile file) {
        IPath location = null;
        if (file != null) {
            location = file.exists() && file.getProject() != null && file.getProject().exists() ? file.getLocation() : ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().locationFor((IResource)file);
        }
        return location;
    }

    public static String getPathFromEditorInput(IEditorInput input) {
        try {
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                return CoreUIUtils.getStringOfIFileLocation(file);
            }
            if (input instanceof NonExistingFileEditorInput) {
                NonExistingFileEditorInput nin = (NonExistingFileEditorInput)input;
                IPath path = nin.getPath((Object)nin);
                String spath = path.toOSString();
                return spath;
            }
            if (input instanceof IStorageEditorInput) {
                IStorageEditorInput sei = (IStorageEditorInput)input;
                try {
                    return sei.getStorage().getFullPath().toOSString();
                }
                catch (Exception exception) {
                    if (input instanceof IPathEditorInput) {
                        IPathEditorInput pin = (IPathEditorInput)input;
                        return pin.getPath().toOSString();
                    }
                }
            } else {
                URI uri;
                if (input instanceof IPathEditorInput) {
                    IPathEditorInput pin = (IPathEditorInput)input;
                    return pin.getPath().toOSString();
                }
                if (input instanceof IURIEditorInput && "file".equals((uri = ((IURIEditorInput)input).getURI()).getScheme())) {
                    return new File(uri).getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static String appendProtocol(String path) {
        if (path.indexOf("://") < 0) {
            return FILE_SLASH_SLASH + path;
        }
        return path;
    }

    public static String getURI(File file) {
        return CoreUIUtils.getURI(file, true);
    }

    public static String getURI(File file, boolean urlEncode) {
        String filePath = null;
        String path = file.getPath();
        if (path.startsWith("file:\\")) {
            filePath = path.replaceAll("file:\\\\", FILE_SLASH_SLASH);
        } else if (path.startsWith("http:\\")) {
            filePath = path.replaceAll("http:\\\\", "http://");
        } else {
            try {
                filePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                filePath = file.getAbsolutePath();
            }
            if (filePath.startsWith("\\\\")) {
                filePath = filePath.substring(2);
            }
            filePath = CoreUIUtils.appendProtocol(filePath);
        }
        filePath = filePath.replaceAll("\\\\", "/");
        if (urlEncode) {
            filePath = StringUtils.urlEncodeFilename((char[])filePath.toCharArray());
        }
        try {
            if (urlEncode) {
                URI uri = new URI(filePath).normalize();
                return uri.toString();
            }
            return filePath;
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)(String.valueOf(Messages.CoreUIUtils_UnableToURLEncodeFilename) + filePath), (Throwable)e);
            return filePath;
        }
    }

    public static String getURI(IPath path) {
        File f = new File(path.toOSString());
        return CoreUIUtils.getURI(f);
    }

    public static String getURI(IEditorInput input) {
        String s = CoreUIUtils.getPathFromEditorInput(input);
        if (s == null) {
            try {
                Method method = input.getClass().getMethod("getURI", new Class[0]);
                return ((URI)method.invoke((Object)input, new Object[0])).toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
        return CoreUIUtils.getURI(new File(s));
    }

    public static boolean isURI(String path) {
        return path != null && path.indexOf("://") >= 0;
    }

    public static String getURI(String path) {
        if (path != null && path.indexOf(FILE_SLASH_SLASH) < 0 && path.indexOf(FILE_SLASH) == 0) {
            path = StringUtils.replace((String)path, (String)FILE_SLASH, (String)FILE_SLASH_SLASH_SLASH);
        }
        if (path != null && !CoreUIUtils.isURI(path)) {
            return CoreUIUtils.getURI(new File(path));
        }
        return path;
    }

    public static String getURI(IEditorPart editor) {
        if (editor != null && editor.getEditorInput() != null) {
            return CoreUIUtils.getURI(editor.getEditorInput());
        }
        return "";
    }

    public static IEditorPart getActiveEditor() {
        if (EclipseUtils.getWorkbenchInstance() == null) {
            return null;
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        class Result {
            public IEditorPart value = null;

            Result() {
            }
        }
        final Result res = new Result();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){
                {
                }

                public void run() {
                    try {
                        if (display.isDisposed()) {
                            return;
                        }
                        if (EclipseUtils.getWorkbenchInstance() == null) {
                            return;
                        }
                        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (workbench == null) {
                            return;
                        }
                        IWorkbenchPage workbenchPage = workbench.getActivePage();
                        if (workbenchPage == null) {
                            return;
                        }
                        res.value = workbenchPage.getActiveEditor();
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)Messages.CoreUIUtils_UnableToRetrieveActiveEditor, (Throwable)e);
                    }
                }
            });
        }
        return res.value;
    }

    public static String getActiveEditorURI() {
        IEditorPart editor = CoreUIUtils.getActiveEditor();
        if (editor != null && editor.getEditorInput() != null) {
            return CoreUIUtils.getURI(editor.getEditorInput());
        }
        return null;
    }

    public static String[] getOpenEditorPaths() {
        if (EclipseUtils.getWorkbenchInstance() == null) {
            return new String[0];
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        class Result {
            public String[] value = new String[0];

            Result() {
            }
        }
        final Result res = new Result();
        try {
            if (!display.isDisposed()) {
                display.syncExec(new Runnable(){
                    {
                    }

                    public void run() {
                        try {
                            IWorkbench wb = PlatformUI.getWorkbench();
                            if (wb == null) {
                                return;
                            }
                            IWorkbenchWindow workbench = wb.getActiveWorkbenchWindow();
                            if (workbench == null) {
                                return;
                            }
                            IWorkbenchPage workbenchPage = workbench.getActivePage();
                            if (workbenchPage == null) {
                                return;
                            }
                            IEditorReference[] editors = workbenchPage.getEditorReferences();
                            if (editors == null) {
                                return;
                            }
                            ArrayList<String> list = new ArrayList<String>();
                            int i = 0;
                            while (i < editors.length) {
                                String uri;
                                IEditorInput input;
                                String id;
                                IEditorReference ref = editors[i];
                                IEditorPart editor = ref.getEditor(false);
                                if (editor != null && (id = editor.getEditorSite().getId()) != null && id.startsWith("com.aptana") && (input = editor.getEditorInput()) != null && (uri = CoreUIUtils.getURI(input)) != null) {
                                    list.add(uri);
                                }
                                ++i;
                            }
                            res.value = list.toArray(new String[list.size()]);
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.CoreUIUtils_ERR_InAsyncCallInGetOpenEditorPaths, (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.CoreUIUtils_UnableToGetCurrentEditorPaths, (Throwable)e);
        }
        return res.value;
    }

    public static IWorkbenchPart getViewInternal(String id, String secondaryId) {
        IWorkbenchPart[] parts = CoreUIUtils.getViewsInternal(id, secondaryId);
        if (parts.length == 0) {
            return null;
        }
        return parts[0];
    }

    public static IWorkbenchPart[] getViewsInternal(String id) {
        return CoreUIUtils.getViewsInternal(id, null);
    }

    public static IWorkbenchPart[] getViewsInternal(String id, String secondaryId) {
        class ViewGetterThread
        implements Runnable {
            public List<IWorkbenchPart> targetView = new ArrayList<IWorkbenchPart>();
            private final /* synthetic */ String val$id;
            private final /* synthetic */ String val$secondaryId;

            ViewGetterThread(String string, String string2) {
                this.val$id = string;
                this.val$secondaryId = string2;
            }

            public void run() {
                IViewReference[] views = null;
                try {
                    IWorkbenchPage wp;
                    IWorkbench w = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = w.getActiveWorkbenchWindow();
                    if (ww != null && (wp = ww.getActivePage()) != null) {
                        views = wp.getViewReferences();
                        int i = 0;
                        while (i < views.length) {
                            if (this.val$id.equals(views[i].getId())) {
                                if (this.val$secondaryId != null) {
                                    if (this.val$secondaryId.equals(views[i].getSecondaryId())) {
                                        this.targetView.add(views[i].getPart(false));
                                    }
                                } else {
                                    this.targetView.add(views[i].getPart(false));
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)e.toString());
                    return;
                }
            }
        }
        ViewGetterThread getter = new ViewGetterThread(id, secondaryId);
        Display display = Display.getDefault();
        display.syncExec((Runnable)getter);
        IWorkbenchPart[] parts = getter.targetView.toArray(new IWorkbenchPart[getter.targetView.size()]);
        return parts;
    }

    public static IViewPart showView(String viewId, String secondaryId) {
        class OpenViewThread
        implements Runnable {
            public IViewPart[] viewPart = new IViewPart[1];
            private final /* synthetic */ String val$viewId;
            private final /* synthetic */ String val$secondaryId;

            OpenViewThread(String string, String string2) {
                this.val$viewId = string;
                this.val$secondaryId = string2;
            }

            public void run() {
                try {
                    IWorkbenchPage wp;
                    IWorkbench w = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = w.getActiveWorkbenchWindow();
                    if (ww != null && (wp = ww.getActivePage()) != null) {
                        this.viewPart[0] = wp.showView(this.val$viewId, this.val$secondaryId, 1);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)e.toString());
                    return;
                }
            }
        }
        OpenViewThread getter = new OpenViewThread(viewId, secondaryId);
        Display display = Display.getDefault();
        display.syncExec((Runnable)getter);
        return getter.viewPart[0];
    }

    public static IEditorPart openEditor(String editorId, boolean activate) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                return page.openEditor((IEditorInput)new EmptyEditorInput(), editorId, activate, 2);
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    public static String getPathFromURI(String sourceURI) {
        String uri = sourceURI;
        if (sourceURI.startsWith(FILE_SLASH_SLASH)) {
            uri = sourceURI.substring(FILE_SLASH_SLASH.length());
        }
        if (sourceURI.startsWith(FILE_COLON)) {
            uri = sourceURI.substring(FILE_COLON.length());
        }
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.CoreUIUtils_EncodingNotSupported, (Throwable)e);
            return uri;
        }
    }

    public static String getUserName() {
        try {
            String testName;
            String userName = System.getProperty("user.name");
            IPreferenceStore store = CoreUIPlugin.getDefault().getPreferenceStore();
            if (store != null && !"".equals(testName = store.getString("com.aptana.ide.core.ui.PREF_USER_NAME"))) {
                userName = testName;
            }
            return userName;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.CoreUIUtils_UnableToGetCurrentUserName, (Throwable)e);
            return "";
        }
    }

    public static void logAndDialogError(Shell shell, Plugin plugin, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
        IdeLog.logError((Plugin)plugin, (String)message);
    }

    public static void logAndDialogError(Shell shell, Plugin plugin, String title, String message, Throwable th) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
        IdeLog.logError((Plugin)plugin, (String)message, (Throwable)th);
    }

    public static IEditorInput createJavaFileEditorInput(File file) {
        FileStoreEditorInput input = null;
        try {
            LocalFile localFile = new LocalFile(file);
            input = new FileStoreEditorInput((IFileStore)localFile);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)Messages.CoreUIUtils_UnableToCreateJavaFileEditorInput, (Throwable)e);
        }
        return input;
    }

    public static IEditorInput createNonExistingFileEditorInput(File file, String fileName) {
        NonExistingFileEditorInput input = null;
        try {
            LocalFile localFile = new LocalFile(file);
            input = new NonExistingFileEditorInput((IFileStore)localFile, fileName);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)AptanaCorePlugin.getDefault(), (String)Messages.CoreUIUtils_UnableToCreateNonExistingFileEditorInput, (Throwable)e);
        }
        return input;
    }

    public static String joinURI(URL url, String uriSuffix) {
        return CoreUIUtils.joinURI(url.toString(), uriSuffix);
    }

    public static String joinURI(String uriPrefix, String uriSuffix) {
        if (uriPrefix == null || "".equals(uriPrefix)) {
            return uriPrefix;
        }
        if (!uriPrefix.endsWith("/")) {
            uriPrefix = String.valueOf(uriPrefix) + "/";
        }
        return String.valueOf(uriPrefix) + uriSuffix;
    }

    public static URL trimURLSegments(URL url, int segments) {
        String urlString = url.toExternalForm();
        String[] segment = CoreUIUtils.splitUrlPath(urlString);
        if (segments >= segment.length) {
            return null;
        }
        String newUrl = "";
        int i = 0;
        while (i < segment.length - segments) {
            String string = segment[i];
            newUrl = String.valueOf(newUrl) + string + URL_SEPARATOR;
            ++i;
        }
        try {
            return new URL(newUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String[] splitUrlPath(String urlPath) {
        String[] segments = urlPath.split(URL_SEPARATOR);
        return segments;
    }

    public static String joinUrlPath(String[] segments) {
        return StringUtils.join((String)URL_SEPARATOR, (String[])segments);
    }

    public static void registerFileExtension(final String editorID, final String filename, final String extension) {
        UIJob job = new UIJob("register file extension"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                EditorRegistry registry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
                IFileEditorMapping[] mappings = registry.getFileEditorMappings();
                FileEditorMapping editorMapping = new FileEditorMapping(filename, extension);
                editorMapping.setDefaultEditor((EditorDescriptor)registry.findEditor(editorID));
                FileEditorMapping foundMapping = null;
                int i = 0;
                while (i < mappings.length) {
                    if (mappings[i].getName().equals(editorMapping.getName()) && mappings[i].getExtension().equals(editorMapping.getExtension())) {
                        foundMapping = (FileEditorMapping)mappings[i];
                        break;
                    }
                    ++i;
                }
                if (foundMapping != null) {
                    foundMapping.setDefaultEditor((EditorDescriptor)registry.findEditor(editorID));
                    registry.setFileEditorMappings((FileEditorMapping[])mappings);
                } else {
                    ArrayList<FileEditorMapping> mappingsList = new ArrayList<FileEditorMapping>();
                    Collections.addAll(mappingsList, mappings);
                    mappingsList.add(editorMapping);
                    registry.setFileEditorMappings(mappingsList.toArray(new FileEditorMapping[mappingsList.size()]));
                }
                registry.saveAssociations();
                PrefUtil.savePrefs();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static URI replaceBundleNameWithId(URI url) {
        if (!url.getScheme().startsWith("bundle")) {
            return url;
        }
        String bundleName = url.getAuthority();
        if (bundleName == null) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_ERR_UnableToFindBundleName, (String)url.toString()));
            return url;
        }
        Bundle b = Platform.getBundle((String)bundleName);
        if (b != null) {
            bundleName = String.valueOf(b.getBundleId());
            try {
                return new URI(url.getScheme(), bundleName, url.getPath(), null, null);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_ERR_UnableToSwitchOutBundleIdForURL, (String)url.toString()), (Throwable)e);
                return url;
            }
        }
        return url;
    }

    public static URL getBundlePathAsFile(URI url) {
        if (!url.getScheme().startsWith("bundle")) {
            return null;
        }
        String bundleName = url.getAuthority();
        if (bundleName == null) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_ERR_UnableToFindBundleName, (String)url.toString()));
            return null;
        }
        Bundle b = Platform.getBundle((String)bundleName);
        if (b != null) {
            URL fileUrl = FileLocator.find((Bundle)b, (IPath)new Path(url.getPath()), null);
            if (fileUrl != null) {
                try {
                    URL localUrl = FileLocator.toFileURL((URL)fileUrl);
                    return localUrl;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)e.getMessage());
            }
        }
        return null;
    }

    public static File getConfigurationDirectory() {
        return ApplicationPreferences.getConfigurationDirectory();
    }

    public static String resolveBundleUrl(String stringUrl) {
        if (stringUrl == null) {
            return null;
        }
        try {
            URL url = CoreUIUtils.replaceBundleNameWithId(new URI(stringUrl)).toURL();
            URL resolvedURL = CoreUIUtils.getResolvedURL(null, url.toExternalForm());
            return resolvedURL.toExternalForm();
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_ERR_UnableToResolveURL, (String)stringUrl), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.CoreUIUtils_ERR_UnableToResolveURL, (String)stringUrl), (Throwable)e);
            return null;
        }
    }

    public static void showError(String message, Exception e) {
        CoreUIUtils.showError(message, e, true);
    }

    public static void showError(final String message, final Exception e, final boolean log) {
        UIJob errorJob = new UIJob(Messages.CoreUIUtils_MSG_ShowingError){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CoreUIUtils_MSG_Error, (String)message);
                if (log) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)message, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        errorJob.schedule();
    }

    public static void showMessage(final String message) {
        UIJob messageJob = new UIJob(Messages.CoreUIUtils_MSG_ShowingMessage){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CoreUIUtils_MSG_Information, (String)message);
                return Status.OK_STATUS;
            }
        };
        messageJob.schedule();
    }

    public static void openBrowserURLWithInfo(String browserUrl, boolean startWithQuestionMark, String from) {
        String[] args;
        String product = StringUtils.replaceNullWithEmpty((String)System.getProperty("eclipse.product"));
        if (product.length() == 0 && (args = Platform.getCommandLineArgs()) != null) {
            int i = 0;
            while (i < args.length) {
                if ("-product".equals(args[i]) && i + 1 < args.length) {
                    product = args[i + 1];
                    break;
                }
                ++i;
            }
        }
        browserUrl = startWithQuestionMark ? String.valueOf(browserUrl) + "?" : String.valueOf(browserUrl) + "&";
        CoreUIUtils.openBrowserURL(String.valueOf(browserUrl) + "from=" + from + "&product=" + product);
    }

    public static void openBrowserURLWithAllInfo(String browserUrl, boolean startWithQuestionMark, String from) {
        String key = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_KEY");
        if (key == null) {
            key = "";
        }
        if (key.length() > 20) {
            key = key.substring(0, 20);
        }
        String idAddition = startWithQuestionMark ? "?id=" : "&id=";
        CoreUIUtils.openBrowserURLWithInfo(String.valueOf(browserUrl) + idAddition + "&lic=" + key, false, from);
    }

    public static void openBrowserURL(String browserUrl) {
        try {
            URL url = new URL(browserUrl);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static IViewPart showView(String viewID) throws PartInitException {
        IWorkbenchPage page;
        IViewPart view = null;
        IWorkbenchWindow window = CoreUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            view = page.showView(viewID);
        }
        return view;
    }

    public static IViewPart findView(String viewID) throws PartInitException {
        IWorkbenchPage page;
        IViewPart view = null;
        IWorkbenchWindow window = CoreUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            view = page.findView(viewID);
        }
        return view;
    }

    public static boolean isFeatureEnabled(String featureId) {
        boolean enabled = false;
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] sites = config.getConfiguredSites();
            int i = 0;
            while (i < sites.length && !enabled) {
                IFeatureReference[] refs = sites[i].getFeatureReferences();
                int j = 0;
                while (j < refs.length && !enabled) {
                    IFeatureReference ref = refs[j];
                    IFeature feature = ref.getFeature(null);
                    VersionedIdentifier ident = ref.getVersionedIdentifier();
                    IConfiguredSite site = ref.getSite().getCurrentConfiguredSite();
                    if (ident != null && ident.getIdentifier().equals(featureId) && site.isConfigured(feature)) {
                        enabled = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            enabled = false;
        }
        return enabled;
    }

    public static String getFileEncoding(IFile file) {
        String charset = null;
        try {
            String fileCharset;
            if (file != null && (fileCharset = file.getCharset(true)) != null) {
                charset = fileCharset;
            }
        }
        catch (Throwable throwable) {}
        if (charset == null) {
            try {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                charset = workspaceRoot.getDefaultCharset();
            }
            catch (CoreException coreException) {
                charset = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            }
        }
        if (charset == null) {
            charset = ResourcesPlugin.getEncoding();
        }
        return charset;
    }

    public static String getContainerEncoding(IContainer container) {
        String charset = null;
        try {
            String containerCharset;
            if (container != null && (containerCharset = container.getDefaultCharset()) != null) {
                charset = containerCharset;
            }
        }
        catch (Throwable throwable) {}
        if (charset == null) {
            try {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                charset = workspaceRoot.getDefaultCharset();
            }
            catch (CoreException coreException) {
                charset = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            }
        }
        if (charset == null) {
            charset = ResourcesPlugin.getEncoding();
        }
        return charset;
    }
}

