/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.Base64;
import com.aptana.ide.core.IAuthentificationULRFilter;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MultipleAuthenticationFilter;
import com.aptana.ide.core.SkipCloudFilter;
import com.aptana.ide.core.SkipPathAuthentificationFilter;
import com.aptana.ide.core.SkipSitemanagerAuthFilter;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.core.ui.UpdateManagerAuthenticator;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AptanaAuthenticator
extends UpdateManagerAuthenticator {
    private static final int THREE_SECONDS = 3000;
    private static final String HOST_DELIMETER = ",";
    private static final String ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String DEBUG_HOST_VALUE = RESTServiceProvider.DEBUG_HOST;
    private static final AptanaAuthenticator authenticator = new AptanaAuthenticator();
    private static Map<String, Long> requestMap = new HashMap<String, Long>();
    private static Map<String, PasswordAuthentication> table = new Hashtable<String, PasswordAuthentication>();
    private final IAuthentificationULRFilter filter;

    public static void correctAuthenticator() {
        Authenticator.setDefault(authenticator);
    }

    public AptanaAuthenticator() {
        this((IAuthentificationULRFilter)new MultipleAuthenticationFilter(new IAuthentificationULRFilter[]{new SkipPathAuthentificationFilter(new String[]{"/update/xul/3.2/messages.xml"}), new SkipSitemanagerAuthFilter(), new SkipCloudFilter()}));
    }

    public AptanaAuthenticator(IAuthentificationULRFilter filter) {
        this.filter = filter;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication cached;
        InetAddress address = this.getRequestingSite();
        String hostString = null;
        if (address != null) {
            hostString = address.getHostName();
        }
        if (hostString == null) {
            hostString = "";
        }
        if (hostString.indexOf("aptanacloud.com") != -1 && AptanaUser.getSignedInUser() != null && AptanaUser.getSignedInUser().hasCredentials()) {
            return new PasswordAuthentication(AptanaUser.getSignedInUser().getUsername(), AptanaUser.getSignedInUser().getPassword().toCharArray());
        }
        if (hostString.indexOf("sitemanager.aptana.com") != -1 && AptanaUser.getSignedInUser() != null && AptanaUser.getSignedInUser().hasCredentials()) {
            return new PasswordAuthentication(AptanaUser.getSignedInUser().getUsername(), AptanaUser.getSignedInUser().getPassword().toCharArray());
        }
        if (DEBUG_HOST_VALUE != null && hostString.indexOf(DEBUG_HOST_VALUE) != -1 && AptanaUser.getSignedInUser() != null && AptanaUser.getSignedInUser().hasCredentials()) {
            return new PasswordAuthentication(AptanaUser.getSignedInUser().getUsername(), AptanaUser.getSignedInUser().getPassword().toCharArray());
        }
        if (this.filter != null && !this.filter.requiresCheck(this.getRequestingURL())) {
            return null;
        }
        if (hostString.indexOf("aptana") == -1) {
            return this.doGetPasswordAuthentication();
        }
        if (AptanaAuthenticator.cachingEnabled() && !this.looksLikeCachedAreBad(hostString) && (cached = AptanaAuthenticator.getCachedAuthentication(hostString)) != null) {
            return cached;
        }
        PasswordAuthentication auth = super.getPasswordAuthentication();
        if (auth != null && AptanaAuthenticator.cachingEnabled()) {
            IdeLog.logInfo((Plugin)AptanaCorePlugin.getDefault(), (String)StringUtils.format((String)Messages.AptanaAuthenticator_INF_LoggingPasswordForHost, (String)hostString));
            this.cacheAuthentication(hostString, auth);
        }
        return auth;
    }

    private PasswordAuthentication doGetPasswordAuthentication() {
        String address = null;
        PasswordAuthentication auth = null;
        try {
            address = InetAddress.getByName(this.getRequestingHost()).getHostAddress();
            auth = table.get(address);
        }
        catch (Exception exception) {}
        if (auth == null) {
            auth = super.getPasswordAuthentication();
            if (address != null && auth != null) {
                table.put(address, auth);
            }
        }
        return auth;
    }

    private static SecretKeySpec getKeySpec() {
        String ksPref = Platform.getPreferencesService().getString("com.aptana.ide.core", "com.aptana.ide.core.CACHED_KEY", "", null);
        byte[] key = null;
        if (!"".equals(ksPref)) {
            try {
                byte[] bytes = Base64.decode((String)ksPref);
                if (bytes != null) {
                    key = bytes;
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_UnableToDecodeExistingKey, (Throwable)e);
            }
        }
        if (key == null || key.length == 0) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey skey = kgen.generateKey();
                key = skey.getEncoded();
                String b64 = Base64.encodeBytes((byte[])skey.getEncoded());
                IEclipsePreferences prefs = AptanaAuthenticator.getPreferences();
                prefs.put("com.aptana.ide.core.CACHED_KEY", b64);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            catch (NoSuchAlgorithmException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
                return null;
            }
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        return skeySpec;
    }

    private static byte[] encrypt(SecretKeySpec skeySpec, String password) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, skeySpec);
            return cipher.doFinal(password.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_NoSuchPadding, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_InvalidKey, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_IllegalBlockSize, (Throwable)e);
        }
        catch (BadPaddingException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_BadPadding, (Throwable)e);
        }
        return null;
    }

    private static byte[] decrypt(SecretKeySpec skeySpec, byte[] encryptedPassword) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, skeySpec);
            return cipher.doFinal(encryptedPassword);
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_NoSuchAlgorithm, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_NoSuchPadding, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_InvalidKey, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_IllegalBlockSize, (Throwable)e);
        }
        catch (BadPaddingException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AptanaAuthenticator_ERR_BadPadding, (Throwable)e);
        }
        return null;
    }

    public PasswordAuthentication encrypt(PasswordAuthentication auth) {
        if (auth == null) {
            return null;
        }
        char[] password = auth.getPassword();
        String username = auth.getUserName();
        return new PasswordAuthentication(username, password);
    }

    private boolean looksLikeCachedAreBad(String hostString) {
        String serialized = this.getSerializedRequest(hostString);
        return AptanaAuthenticator.looksLikeCachedAreBad(hostString, serialized);
    }

    public static boolean looksLikeCachedAreBad(String hostString, String serializedRequest) {
        try {
            if (!requestMap.containsKey(serializedRequest)) {
                return false;
            }
            Long lastRequestTimestamp = requestMap.get(serializedRequest);
            return lastRequestTimestamp > System.currentTimeMillis() - 3000L;
            {
            }
        }
        finally {
            requestMap.put(serializedRequest, new Long(System.currentTimeMillis()));
        }
    }

    private String getSerializedRequest(String hostString) {
        return AptanaAuthenticator.serializeRequest(hostString, this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingScheme(), this.getRequestingPort(), this.getRequestingURL());
    }

    public static String serializeRequest(String hostString, String prompt, String protocol, String scheme, int port, URL url) {
        StringBuffer request = new StringBuffer();
        request.append(hostString);
        request.append(";");
        request.append(prompt);
        request.append(";");
        request.append(protocol);
        request.append(";");
        request.append(scheme);
        request.append(";");
        request.append(port);
        request.append(";");
        request.append(url.toString());
        return request.toString();
    }

    public static boolean cachingEnabled() {
        return Platform.getPreferencesService().getBoolean("com.aptana.ide.core", "com.aptana.ide.core.PREF_ENABLE_PASSWORD_CACHING", true, null);
    }

    public void cacheAuthentication(String hostString, PasswordAuthentication auth) {
        SecretKeySpec key;
        byte[] encrypted;
        if (auth == null) {
            return;
        }
        char[] password = auth.getPassword();
        String username = auth.getUserName();
        IEclipsePreferences prefs = AptanaAuthenticator.getPreferences();
        String hostsString = Platform.getPreferencesService().getString("com.aptana.ide.core", "com.aptana.ide.core.SAVED_PASSWORD_HOSTS", "", null);
        int index = hostsString.indexOf(hostString);
        if (index == -1) {
            hostsString = String.valueOf(hostsString) + HOST_DELIMETER + hostString;
            prefs.put("com.aptana.ide.core.SAVED_PASSWORD_HOSTS", hostsString);
        }
        if ((encrypted = AptanaAuthenticator.encrypt(key = AptanaAuthenticator.getKeySpec(), new String(password))) != null && encrypted.length > 0) {
            String b64 = Base64.encodeBytes((byte[])encrypted);
            prefs.put(AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.username", hostString), username);
            prefs.put(AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.password", hostString), b64);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static PasswordAuthentication getCachedAuthentication(String hostString) {
        char[] password = AptanaAuthenticator.getPassword(hostString);
        if (password.length == 0) {
            return null;
        }
        String username = AptanaAuthenticator.getUserName(hostString);
        if ("".equals(username)) {
            return null;
        }
        return new PasswordAuthentication(username, password);
    }

    private static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode("com.aptana.ide.core");
    }

    public static String getUserName(String hostString) {
        String username = Platform.getPreferencesService().getString("com.aptana.ide.core", AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.username", hostString), "", null);
        if (username.length() > 30) {
            username = username.substring(0, 30);
        }
        return username;
    }

    private static String generatePrefKey(String prefix, String hostString) {
        return String.valueOf(prefix) + "." + hostString;
    }

    private static char[] getPassword(String hostString) {
        String encrypted = Platform.getPreferencesService().getString("com.aptana.ide.core", AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.password", hostString), "", null);
        byte[] bytes = Base64.decode((String)encrypted);
        if (bytes != null && bytes.length > 0) {
            SecretKeySpec key = AptanaAuthenticator.getKeySpec();
            byte[] decrypted = AptanaAuthenticator.decrypt(key, bytes);
            return new String(decrypted).toCharArray();
        }
        return new char[0];
    }

    public static final Set<String> getSavedHosts() {
        String[] hosts = Platform.getPreferencesService().getString("com.aptana.ide.core", "com.aptana.ide.core.SAVED_PASSWORD_HOSTS", "", null).split(HOST_DELIMETER);
        HashSet<String> hostSet = new HashSet<String>();
        int i = 0;
        while (i < hosts.length) {
            hostSet.add(hosts[i]);
            ++i;
        }
        return hostSet;
    }

    public static void removeCachedAuthentication(String hostname) {
        StringBuffer buffer = new StringBuffer();
        Set<String> hosts = AptanaAuthenticator.getSavedHosts();
        for (String host : hosts) {
            if (host.equals(hostname)) continue;
            buffer.append(host);
            buffer.append(HOST_DELIMETER);
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        IEclipsePreferences prefs = AptanaAuthenticator.getPreferences();
        prefs.put("com.aptana.ide.core.SAVED_PASSWORD_HOSTS", buffer.toString());
        prefs.put(AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.username", hostname), "");
        prefs.put(AptanaAuthenticator.generatePrefKey("com.aptana.ide.core.cached.password", hostname), "");
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void addProxyEntry(String hostname, String userid, String password) {
        try {
            String address = InetAddress.getByName(hostname).getHostAddress();
            PasswordAuthentication auth = new PasswordAuthentication(userid, password.toCharArray());
            if (address != null && auth != null) {
                table.put(address, auth);
            }
        }
        catch (Exception exception) {}
    }
}

