/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.syncing.ui.views.ISyncResource;
import com.aptana.ide.syncing.ui.views.SyncFolder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SmartSyncContentProvider
implements ITreeContentProvider {
    private List<ISyncResource> fCurrentResources = new ArrayList<ISyncResource>();
    private int fSyncDirection;
    private int fPresentationType;
    private boolean fDeleteRemoteFiles;
    private boolean fDeleteLocalFiles;

    public ISyncResource[] getCurrentResources() {
        return this.fCurrentResources.toArray(new ISyncResource[this.fCurrentResources.size()]);
    }

    public void setSyncDirection(int direction) {
        this.fSyncDirection = direction;
    }

    public void setPresentationType(int type) {
        this.fPresentationType = type;
    }

    public void setDeleteRemoteFiles(boolean delete) {
        this.fDeleteRemoteFiles = delete;
    }

    public void setDeleteLocalFiles(boolean delete) {
        this.fDeleteLocalFiles = delete;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof SyncFolder && this.fPresentationType == 1) {
            ISyncResource[] children = ((SyncFolder)parentElement).members();
            ArrayList<ISyncResource> resources = new ArrayList<ISyncResource>();
            ISyncResource[] iSyncResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISyncResource child = iSyncResourceArray[n2];
                if (this.fCurrentResources.contains(child)) {
                    resources.add(child);
                } else if (child instanceof SyncFolder && !resources.contains(child)) {
                    SyncFolder folder = (SyncFolder)child;
                    List<ISyncResource> subs = folder.getAllFiles();
                    for (ISyncResource resource : this.fCurrentResources) {
                        if (!subs.contains(resource)) continue;
                        resources.add(child);
                        break;
                    }
                }
                ++n2;
            }
            return resources.toArray(new ISyncResource[resources.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ISyncResource) {
            return ((ISyncResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SyncFolder && this.fPresentationType == 1) {
            return !((SyncFolder)element).isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        this.fCurrentResources.clear();
        if (inputElement instanceof SyncFolder) {
            ISyncResource[] all = ((SyncFolder)inputElement).getAllFiles().toArray(new ISyncResource[0]);
            if (this.fSyncDirection == 1 || this.fSyncDirection == 2 || this.fSyncDirection == 3 || this.fSyncDirection == 4) {
                ISyncResource[] iSyncResourceArray = all;
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    ISyncResource resource = iSyncResourceArray[n2];
                    int state = resource.getSyncState();
                    if (this.fSyncDirection == 1 || this.fSyncDirection == 3) {
                        if (state == 6 || state == 4) {
                            this.fCurrentResources.add(resource);
                        } else if (this.fDeleteRemoteFiles && state == 7) {
                            this.fCurrentResources.add(resource);
                        } else if (state == -2) {
                            this.fCurrentResources.add(resource);
                        }
                    } else if (this.fSyncDirection == 2 || this.fSyncDirection == 4) {
                        if (state == 5 || state == 7) {
                            this.fCurrentResources.add(resource);
                        } else if (this.fDeleteLocalFiles && state == 6) {
                            this.fCurrentResources.add(resource);
                        } else if (state == -2) {
                            this.fCurrentResources.add(resource);
                        }
                    }
                    ++n2;
                }
                if (this.fPresentationType == 1) {
                    return this.getChildren(inputElement);
                }
            } else {
                ISyncResource[] iSyncResourceArray = all;
                int n = all.length;
                int n3 = 0;
                while (n3 < n) {
                    ISyncResource resource = iSyncResourceArray[n3];
                    this.fCurrentResources.add(resource);
                    ++n3;
                }
                if (this.fPresentationType == 1) {
                    return this.getChildren(inputElement);
                }
            }
        }
        return this.fCurrentResources.toArray(new ISyncResource[this.fCurrentResources.size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

