/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.syncing.ui.views.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DirectionToolBar {
    public static final int BOTH = 0;
    public static final int UPLOAD = 1;
    public static final int DOWNLOAD = 2;
    public static final int FORCE_UPLOAD = 3;
    public static final int FORCE_DOWNLOAD = 4;
    private ToolBar fDirectionBar;
    private ToolItem fDirectionDown;
    private MenuItem fBoth;
    private MenuItem fUpload;
    private MenuItem fForceUpload;
    private MenuItem fDownload;
    private MenuItem fForceDownload;
    private MenuItem fPreviousSelection;
    private String fEndpoint1;
    private String fEndpoint2;
    private Client fClient;

    public DirectionToolBar(Composite parent, Client client, String endpoint1, String endpoint2) {
        this.fClient = client;
        this.fEndpoint1 = endpoint1;
        this.fEndpoint2 = endpoint2;
        this.fDirectionBar = this.createContents(parent);
    }

    public Control getControl() {
        return this.fDirectionBar;
    }

    public int getSelection() {
        if (this.fUpload.getSelection()) {
            return 1;
        }
        if (this.fDownload.getSelection()) {
            return 2;
        }
        if (this.fForceUpload.getSelection()) {
            return 3;
        }
        if (this.fForceDownload.getSelection()) {
            return 4;
        }
        return 0;
    }

    public void setSelection(int direction) {
        this.fBoth.setSelection(false);
        this.fUpload.setSelection(false);
        this.fDownload.setSelection(false);
        this.fForceUpload.setSelection(false);
        this.fForceDownload.setSelection(false);
        switch (direction) {
            case 0: {
                this.fBoth.setSelection(true);
                this.fPreviousSelection = this.fBoth;
                break;
            }
            case 1: {
                this.fUpload.setSelection(true);
                this.fPreviousSelection = this.fUpload;
                break;
            }
            case 2: {
                this.fDownload.setSelection(true);
                this.fPreviousSelection = this.fDownload;
                break;
            }
            case 3: {
                this.fForceUpload.setSelection(true);
                this.fPreviousSelection = this.fForceUpload;
                break;
            }
            case 4: {
                this.fForceDownload.setSelection(true);
                this.fPreviousSelection = this.fForceDownload;
            }
        }
        this.updateText();
        this.updateToolTip();
    }

    public void setEnabled(boolean enabled) {
        this.fDirectionBar.setEnabled(enabled);
    }

    private ToolBar createContents(final Composite parent) {
        final ToolBar directionBar = new ToolBar(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        directionBar.setLayout((Layout)layout);
        this.fDirectionDown = new ToolItem(directionBar, 4);
        final Menu directionMenu = new Menu((Control)directionBar);
        this.fDirectionDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = directionBar.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = parent.toDisplay(pt);
                directionMenu.setLocation(pt.x, pt.y);
                directionMenu.setVisible(true);
            }
        });
        this.fBoth = new MenuItem(directionMenu, 16);
        this.fBoth.setText(Messages.SmartSyncDialog_BothDirection);
        this.fBoth.setSelection(true);
        SelectionAdapter directionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                if (!item.getSelection()) {
                    return;
                }
                DirectionToolBar.this.fDirectionDown.setText(item.getText());
                DirectionToolBar.this.updateToolTip();
                parent.getParent().layout(true, true);
                boolean load = true;
                if (DirectionToolBar.this.fBoth.getSelection() || DirectionToolBar.this.fUpload.getSelection() || DirectionToolBar.this.fDownload.getSelection()) {
                    if (DirectionToolBar.this.fPreviousSelection == DirectionToolBar.this.fBoth || DirectionToolBar.this.fPreviousSelection == DirectionToolBar.this.fUpload || DirectionToolBar.this.fPreviousSelection == DirectionToolBar.this.fDownload) {
                        load = false;
                    }
                } else if ((DirectionToolBar.this.fForceUpload.getSelection() || DirectionToolBar.this.fForceDownload.getSelection()) && DirectionToolBar.this.fPreviousSelection == item) {
                    load = false;
                }
                DirectionToolBar.this.fPreviousSelection = item;
                DirectionToolBar.this.fClient.selectionChanged(DirectionToolBar.this.getSelection(), load);
            }
        };
        this.fBoth.addSelectionListener((SelectionListener)directionAdapter);
        this.fUpload = new MenuItem(directionMenu, 16);
        this.fUpload.setText(String.valueOf(Messages.SmartSyncDialog_Upload) + "  ->");
        this.fUpload.addSelectionListener((SelectionListener)directionAdapter);
        this.fForceUpload = new MenuItem(directionMenu, 16);
        this.fForceUpload.setText(String.valueOf(Messages.SmartSyncDialog_UploadAll) + "  ->");
        this.fForceUpload.addSelectionListener((SelectionListener)directionAdapter);
        this.fDownload = new MenuItem(directionMenu, 16);
        this.fDownload.setText("<-  " + Messages.SmartSyncDialog_Download);
        this.fDownload.addSelectionListener((SelectionListener)directionAdapter);
        this.fForceDownload = new MenuItem(directionMenu, 16);
        this.fForceDownload.setText("<-  " + Messages.SmartSyncDialog_DownloadAll);
        this.fForceDownload.addSelectionListener((SelectionListener)directionAdapter);
        this.fDirectionDown.setText(this.fBoth.getText());
        this.updateToolTip();
        this.fPreviousSelection = this.fBoth;
        return directionBar;
    }

    private void updateText() {
        if (this.fBoth.getSelection()) {
            this.fDirectionDown.setText(this.fBoth.getText());
        } else if (this.fUpload.getSelection()) {
            this.fDirectionDown.setText(this.fUpload.getText());
        } else if (this.fForceUpload.getSelection()) {
            this.fDirectionDown.setText(this.fForceUpload.getText());
        } else if (this.fDownload.getSelection()) {
            this.fDirectionDown.setText(this.fDownload.getText());
        } else if (this.fForceDownload.getSelection()) {
            this.fDirectionDown.setText(this.fForceDownload.getText());
        }
    }

    private void updateToolTip() {
        if (this.fBoth.getSelection()) {
            this.fDirectionDown.setToolTipText(MessageFormat.format(Messages.DirectionToolBar_SyncToolTip, this.fEndpoint1, this.fEndpoint2));
        } else if (this.fUpload.getSelection()) {
            this.fDirectionDown.setToolTipText(MessageFormat.format(Messages.DirectionToolBar_UploadToolTip, this.fEndpoint2, this.fEndpoint1));
        } else if (this.fForceUpload.getSelection()) {
            this.fDirectionDown.setToolTipText(MessageFormat.format(Messages.DirectionToolBar_ForceUploadToolTip, this.fEndpoint2, this.fEndpoint1));
        } else if (this.fDownload.getSelection()) {
            this.fDirectionDown.setToolTipText(MessageFormat.format(Messages.DirectionToolBar_DownloadToolTip, this.fEndpoint1, this.fEndpoint2));
        } else if (this.fForceDownload.getSelection()) {
            this.fDirectionDown.setToolTipText(MessageFormat.format(Messages.DirectionToolBar_ForceDownloadToolTip, this.fEndpoint1, this.fEndpoint2));
        }
    }

    public static interface Client {
        public void selectionChanged(int var1, boolean var2);
    }
}

