/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnections;
import com.aptana.ide.ui.io.IOUIPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class ProjectSitesManager {
    private static ProjectSitesManager fInstance;
    private Map<IProject, ProjectSiteConnections> fProjects;
    private IConnectionPointListener fListener = new IConnectionPointListener(){

        public void connectionPointChanged(ConnectionPointEvent event) {
            IConnectionPoint destConnection = event.getConnectionPoint();
            switch (event.getKind()) {
                case 4: {
                    Collection projectConnections = ProjectSitesManager.this.fProjects.values();
                    for (ProjectSiteConnections sites : projectConnections) {
                        ProjectSiteConnection[] connections;
                        ProjectSiteConnection[] projectSiteConnectionArray = connections = (ProjectSiteConnection[])sites.getChildren(null);
                        int n = connections.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ProjectSiteConnection projectConnection = projectSiteConnectionArray[n2];
                            IConnectionPoint connectionPoint = (IConnectionPoint)projectConnection.getAdapter(IConnectionPoint.class);
                            if (connectionPoint == destConnection) {
                                IOUIPlugin.refreshNavigatorView((Object)((Object)projectConnection));
                            }
                            ++n2;
                        }
                    }
                    break;
                }
            }
        }
    };

    public static ProjectSitesManager getInstance() {
        if (fInstance == null) {
            fInstance = new ProjectSitesManager();
        }
        return fInstance;
    }

    public ProjectSiteConnections getProjectSites(IProject project) {
        ProjectSiteConnections sites = this.fProjects.get(project);
        if (sites == null) {
            sites = new ProjectSiteConnections(project);
            this.fProjects.put(project, sites);
        }
        return sites;
    }

    private ProjectSitesManager() {
        this.fProjects = new HashMap<IProject, ProjectSiteConnections>();
        CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(this.fListener);
    }
}

