/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.internal;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.internal.Messages;
import com.aptana.ide.ui.IPropertyDialog;
import com.aptana.ide.ui.ftp.internal.FTPPropertyDialogProvider;
import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.dialogs.FileFolderSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SiteConnectionPropertiesWidget
extends Composite
implements ModifyListener {
    private Client client;
    private ISiteConnection source;
    private Text nameText;
    private TargetEditor sourceEditor;
    private TargetEditor destinationEditor;
    private boolean changed;

    public SiteConnectionPropertiesWidget(Composite parent, int style, Client client) {
        super(parent, style);
        this.client = client;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label label = new Label((Composite)this, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.SiteConnectionPropertiesWidget_LBL_Name));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.nameText = new Text((Composite)this, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        this.nameText.addModifyListener((ModifyListener)this);
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        group.setText(Messages.SiteConnectionPropertiesWidget_LBL_Source);
        this.sourceEditor = new TargetEditor(Messages.SiteConnectionPropertiesWidget_LBL_Source);
        this.sourceEditor.createTargets((Composite)group, false);
        group = new Group((Composite)this, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        group.setText(Messages.SiteConnectionPropertiesWidget_LBL_Destination);
        this.destinationEditor = new TargetEditor(Messages.SiteConnectionPropertiesWidget_LBL_Destination);
        this.destinationEditor.createTargets((Composite)group, true);
    }

    public void setSource(ISiteConnection source) {
        if (this.source == source && source != null) {
            return;
        }
        this.source = source;
        if (source == null) {
            ((GridData)this.getLayoutData()).exclude = true;
            this.setVisible(false);
            this.getParent().layout();
            this.validateAll();
            this.changed = false;
            return;
        }
        if (!this.isVisible()) {
            ((GridData)this.getLayoutData()).exclude = false;
            this.setVisible(true);
            this.getParent().layout();
        }
        this.nameText.setText(source.getName());
        this.nameText.setEnabled(source != DefaultSiteConnection.getInstance());
        this.sourceEditor.setTarget(source.getSource());
        this.destinationEditor.setTarget(source.getDestination());
        this.validateAll();
        this.changed = source.getSource() == null || source != DefaultSiteConnection.getInstance() && source.getDestination() == null;
    }

    public ISiteConnection getSource() {
        return this.source;
    }

    public boolean isChanged() {
        return this.source != null && this.changed;
    }

    public boolean applyChanges() {
        if (!this.validateAll()) {
            return false;
        }
        SiteConnection siteConnection = (SiteConnection)this.source;
        siteConnection.setName(this.nameText.getText());
        IConnectionPoint connectionPoint = this.sourceEditor.getTarget();
        if (connectionPoint != null) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint(connectionPoint);
        }
        siteConnection.setSource(connectionPoint);
        connectionPoint = this.destinationEditor.getTarget();
        if (connectionPoint != null) {
            CoreIOPlugin.getConnectionPointManager().addConnectionPoint(connectionPoint);
        }
        siteConnection.setDestination(connectionPoint);
        this.changed = false;
        return true;
    }

    public void modifyText(ModifyEvent e) {
        if (this.validateAll()) {
            this.changed = true;
        }
    }

    private boolean validateAll() {
        String message = null;
        if (this.source != null) {
            String name = this.nameText.getText().trim();
            if (name.length() == 0) {
                message = Messages.SiteConnectionPropertiesWidget_ERR_EmptyName;
            } else if (this.source != DefaultSiteConnection.getInstance() && name.equals("Default")) {
                message = StringUtils.format((String)Messages.SiteConnectionPropertiesWidget_ERR_DuplicateNames, (String)name);
            } else {
                ISiteConnection[] connections;
                ISiteConnection[] iSiteConnectionArray = connections = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                int n = connections.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteConnection connection = iSiteConnectionArray[n2];
                    if (connection != this.source && name.equals(connection.getName())) {
                        message = StringUtils.format((String)Messages.SiteConnectionPropertiesWidget_ERR_DuplicateNames, (String)name);
                        break;
                    }
                    ++n2;
                }
            }
            if (message == null) {
                message = this.sourceEditor.validate();
            }
            if (message == null) {
                message = this.destinationEditor.validate();
            }
        }
        this.client.setErrorMessage(message);
        return message == null;
    }

    private IConnectionPoint createNewRemoteConnection() {
        Dialog dlg = new FTPPropertyDialogProvider().createPropertyDialog((IShellProvider)new SameShellProvider((Control)this));
        if (dlg instanceof IPropertyDialog) {
            ((IPropertyDialog)dlg).setPropertySource((Object)CoreIOPlugin.getConnectionPointManager().getType("ftp"));
        }
        if (dlg.open() == 0) {
            Object result = null;
            if (dlg instanceof IPropertyDialog) {
                result = ((IPropertyDialog)dlg).getPropertySource();
            }
            if (result instanceof IConnectionPoint) {
                return (IConnectionPoint)result;
            }
        }
        return null;
    }

    private IContainer browseWorkspace(IContainer container, IPath path) {
        FileFolderSelectionDialog dlg = new FileFolderSelectionDialog(this.getShell(), false, 2);
        IFileStore input = EFSUtils.getFileStore((IResource)container);
        dlg.setInput((Object)input);
        dlg.setInitialSelection((Object)input.getFileStore(path));
        if (dlg.open() == 0 && dlg.getFirstResult() instanceof IAdaptable) {
            return (IContainer)((IAdaptable)dlg.getFirstResult()).getAdapter(IResource.class);
        }
        return null;
    }

    private IPath browseFilesystem(IPath path) {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell());
        dlg.setFilterPath(path.toOSString());
        String result = dlg.open();
        if (result != null) {
            return Path.fromOSString((String)result);
        }
        return null;
    }

    public static interface Client {
        public void setErrorMessage(String var1);
    }

    private class TargetEditor
    implements SelectionListener,
    ISelectionChangedListener {
        private static final int REMOTE = 1;
        private static final int PROJECT = 2;
        private static final int FILESYSTEM = 3;
        private String name;
        private Composite mainComp;
        private Button remoteRadio;
        private ComboViewer remotesViewer;
        private Button remoteNewButton;
        private Button projectRadio;
        private ComboViewer projectViewer;
        private Text projectFolderText;
        private Button projectBrowseButton;
        private Button filesystemRadio;
        private Text filesystemFolderText;
        private Button filesystemBrowseButton;
        private Label defaultDescriptionLabel;
        private boolean isDefault = false;

        public TargetEditor(String name) {
            this.name = name;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == this.remoteNewButton) {
                IConnectionPoint result = SiteConnectionPropertiesWidget.this.createNewRemoteConnection();
                if (result != null) {
                    this.updateRemotesViewer();
                    this.setType(1);
                    this.remotesViewer.setSelection((ISelection)new StructuredSelection((Object)result));
                    SiteConnectionPropertiesWidget.this.changed = true;
                }
                SiteConnectionPropertiesWidget.this.validateAll();
            } else if (source == this.projectBrowseButton) {
                IContainer result;
                IContainer container = (IContainer)((IStructuredSelection)this.projectViewer.getSelection()).getFirstElement();
                if (container == null) {
                    container = ResourcesPlugin.getWorkspace().getRoot();
                }
                if ((result = SiteConnectionPropertiesWidget.this.browseWorkspace(container, Path.fromPortableString((String)this.projectFolderText.getText()))) != null) {
                    this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)result.getProject()), true);
                    this.projectFolderText.setText(result.getProjectRelativePath().toPortableString());
                    SiteConnectionPropertiesWidget.this.changed = true;
                }
                SiteConnectionPropertiesWidget.this.validateAll();
            } else if (source == this.filesystemBrowseButton) {
                IPath path = SiteConnectionPropertiesWidget.this.browseFilesystem(Path.fromPortableString((String)this.filesystemFolderText.getText()));
                if (path != null) {
                    this.filesystemFolderText.setText(path.toPortableString());
                    SiteConnectionPropertiesWidget.this.changed = true;
                }
                SiteConnectionPropertiesWidget.this.validateAll();
            } else {
                this.setEnabled(this.getType());
                if (SiteConnectionPropertiesWidget.this.validateAll()) {
                    SiteConnectionPropertiesWidget.this.changed = true;
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object source = event.getSource();
            if (source == this.projectViewer) {
                this.projectFolderText.setText(Path.ROOT.toPortableString());
                this.setEnabled(this.getType());
            }
            if (SiteConnectionPropertiesWidget.this.validateAll()) {
                SiteConnectionPropertiesWidget.this.changed = true;
            }
        }

        private void createTargets(Composite parent, boolean showRemote) {
            parent.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            this.mainComp = new Composite(parent, 0);
            this.mainComp.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(4).create());
            this.mainComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.remoteRadio = new Button(this.mainComp, 16);
            this.remoteRadio.setText(Messages.SiteConnectionPropertiesWidget_LBL_Remote);
            this.remoteRadio.setLayoutData((Object)GridDataFactory.swtDefaults().exclude(!showRemote).create());
            this.remoteRadio.addSelectionListener((SelectionListener)this);
            this.remotesViewer = new ComboViewer(this.mainComp, 12);
            this.remotesViewer.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().exclude(!showRemote).align(4, 0x1000000).span(2, 1).grab(true, false).create());
            this.remotesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.remotesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.updateRemotesViewer();
            this.remoteNewButton = new Button(this.mainComp, 8);
            this.remoteNewButton.setText(StringUtils.ellipsify((String)CoreStrings.NEW));
            this.remoteNewButton.setLayoutData((Object)GridDataFactory.swtDefaults().exclude(!showRemote).create());
            this.remoteNewButton.addSelectionListener((SelectionListener)this);
            this.projectRadio = new Button(this.mainComp, 16);
            this.projectRadio.setText(Messages.SiteConnectionPropertiesWidget_LBL_Project);
            this.projectRadio.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            this.projectRadio.setEnabled(projects.length > 0);
            this.projectRadio.addSelectionListener((SelectionListener)this);
            this.projectViewer = new ComboViewer(this.mainComp, 12);
            this.projectViewer.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).create());
            this.projectViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            if (projects.length == 0) {
                this.projectViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                Object[] input = new Object[]{"No project exists in workspace"};
                this.projectViewer.setInput((Object)input);
                this.projectViewer.setSelection((ISelection)new StructuredSelection(input[0]), true);
            } else {
                this.projectViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                this.projectViewer.setInput((Object)projects);
                this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)projects[0]), true);
            }
            this.projectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            new Label(this.mainComp, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
            Label label = new Label(this.mainComp, 0);
            label.setText(StringUtils.makeFormLabel((String)Messages.SiteConnectionPropertiesWidget_LBL_Folder));
            label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.projectFolderText = new Text(this.mainComp, 2048);
            this.projectFolderText.setText(Path.ROOT.toPortableString());
            this.projectFolderText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            this.projectFolderText.addModifyListener((ModifyListener)SiteConnectionPropertiesWidget.this);
            this.projectBrowseButton = new Button(this.mainComp, 8);
            this.projectBrowseButton.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
            this.projectBrowseButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.projectBrowseButton.addSelectionListener((SelectionListener)this);
            this.filesystemRadio = new Button(this.mainComp, 16);
            this.filesystemRadio.setText(Messages.SiteConnectionPropertiesWidget_LBL_Filesystem);
            this.filesystemRadio.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.filesystemRadio.addSelectionListener((SelectionListener)this);
            this.filesystemFolderText = new Text(this.mainComp, 2048);
            this.filesystemFolderText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).create());
            this.filesystemFolderText.addModifyListener((ModifyListener)SiteConnectionPropertiesWidget.this);
            this.filesystemBrowseButton = new Button(this.mainComp, 8);
            this.filesystemBrowseButton.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
            this.filesystemBrowseButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.filesystemBrowseButton.addSelectionListener((SelectionListener)this);
            this.defaultDescriptionLabel = new Label(parent, 64);
            this.defaultDescriptionLabel.setText(Messages.SiteConnectionPropertiesWidget_LBL_DefaultDescription);
            this.defaultDescriptionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).exclude(true).create());
        }

        private void updateRemotesViewer() {
            IConnectionPoint[] sites = ConnectionPointUtils.getRemoteConnectionPoints();
            if (sites.length == 0) {
                this.remoteRadio.setEnabled(false);
                this.remotesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                Object[] input = new Object[]{"No remote site is defined"};
                this.remotesViewer.setInput((Object)input);
                this.remotesViewer.setSelection((ISelection)new StructuredSelection(input[0]), true);
            } else {
                this.remoteRadio.setEnabled(true);
                this.remotesViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                this.remotesViewer.setInput((Object)sites);
                this.remotesViewer.setSelection((ISelection)new StructuredSelection((Object)sites[0]), true);
                Control control = this.remotesViewer.getControl();
                control.setForeground(control.getDisplay().getSystemColor(24));
            }
        }

        private void setType(int type) {
            this.remoteRadio.setSelection(false);
            this.projectRadio.setSelection(false);
            this.filesystemRadio.setSelection(false);
            switch (type) {
                case 1: {
                    this.remoteRadio.setSelection(true);
                    break;
                }
                case 2: {
                    this.projectRadio.setSelection(true);
                    break;
                }
                case 3: {
                    this.filesystemRadio.setSelection(true);
                }
            }
            this.setEnabled(type);
        }

        private int getType() {
            if (this.remoteRadio.getSelection()) {
                return 1;
            }
            if (this.projectRadio.getSelection()) {
                return 2;
            }
            if (this.filesystemRadio.getSelection()) {
                return 3;
            }
            return -1;
        }

        private void setEnabled(int type) {
            this.setEnabled(type, true);
            switch (type) {
                case 1: {
                    this.setEnabled(2, false);
                    this.setEnabled(3, false);
                    break;
                }
                case 2: {
                    this.setEnabled(1, false);
                    this.setEnabled(3, false);
                    break;
                }
                case 3: {
                    this.setEnabled(1, false);
                    this.setEnabled(2, false);
                    break;
                }
                default: {
                    this.setEnabled(1, false);
                    this.setEnabled(2, false);
                    this.setEnabled(3, false);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void setEnabled(int type, boolean enabled) {
            switch (type) {
                case 1: {
                    if (this.remoteRadio.getEnabled()) {
                        this.remotesViewer.getControl().setEnabled(true);
                        this.remoteNewButton.setEnabled(enabled);
                        break;
                    }
                    control = this.remotesViewer.getControl();
                    control.setEnabled(false);
                    control.setForeground(control.getDisplay().getSystemColor(33));
                    break;
                }
                case 2: {
                    if (!this.projectRadio.getEnabled()) {
                        control = this.projectViewer.getControl();
                        control.setEnabled(false);
                        control.setForeground(control.getDisplay().getSystemColor(33));
                        this.projectFolderText.setEnabled(false);
                        this.projectBrowseButton.setEnabled(false);
                        return;
                    }
                    this.projectViewer.getControl().setEnabled(enabled);
                    project = (IProject)((IStructuredSelection)this.projectViewer.getSelection()).getFirstElement();
                    hasFolders = false;
                    if (project == null) ** GOTO lbl36
                    try {
                        var9_8 = resources = project.members();
                        var8_9 = resources.length;
                        var7_10 = 0;
                        while (var7_10 < var8_9) {
                            resource = var9_8[var7_10];
                            if (!(resource instanceof IContainer)) ** GOTO lbl32
                            hasFolders = true;
                            break;
lbl32:
                            // 1 sources

                            ++var7_10;
                        }
                    }
                    catch (CoreException v0) {}
lbl36:
                    // 4 sources

                    this.projectFolderText.setEnabled(enabled != false && hasFolders != false);
                    this.projectBrowseButton.setEnabled(enabled != false && hasFolders != false);
                    break;
                }
                case 3: {
                    this.filesystemFolderText.setEnabled(enabled);
                    this.filesystemBrowseButton.setEnabled(enabled);
                }
            }
        }

        private void setTarget(IConnectionPoint connectionPoint) {
            this.isDefault = SiteConnectionPropertiesWidget.this.source == DefaultSiteConnection.getInstance() && connectionPoint == SiteConnectionPropertiesWidget.this.source.getDestination();
            this.mainComp.setVisible(!this.isDefault);
            ((GridData)this.mainComp.getLayoutData()).exclude = this.isDefault;
            this.defaultDescriptionLabel.setVisible(this.isDefault);
            ((GridData)this.defaultDescriptionLabel.getLayoutData()).exclude = !this.isDefault;
            SiteConnectionPropertiesWidget.this.layout(true, true);
            if (ConnectionPointUtils.isRemote((IConnectionPoint)connectionPoint)) {
                this.setType(1);
                this.remotesViewer.setSelection((ISelection)new StructuredSelection((Object)connectionPoint), true);
            } else if (ConnectionPointUtils.isWorkspace((IConnectionPoint)connectionPoint)) {
                this.setType(2);
                IResource resource = (IResource)connectionPoint.getAdapter(IResource.class);
                this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)resource.getProject()), true);
                IPath path = resource.getProjectRelativePath();
                if (path.isEmpty()) {
                    path = Path.ROOT;
                }
                this.projectFolderText.setText(path.toPortableString());
            } else if (ConnectionPointUtils.isLocal((IConnectionPoint)connectionPoint)) {
                this.setType(3);
                File file = (File)connectionPoint.getAdapter(File.class);
                this.filesystemFolderText.setText(Path.fromOSString((String)file.getAbsolutePath()).toPortableString());
            } else {
                this.setType(-1);
            }
        }

        private IConnectionPoint getTarget() {
            if (this.isDefault) {
                return null;
            }
            if (this.remoteRadio.getSelection()) {
                return (IConnectionPoint)((IStructuredSelection)this.remotesViewer.getSelection()).getFirstElement();
            }
            if (this.projectRadio.getSelection()) {
                IProject project = (IProject)((IStructuredSelection)this.projectViewer.getSelection()).getFirstElement();
                IPath path = Path.fromPortableString((String)this.projectFolderText.getText());
                IContainer container = (IContainer)project.findMember(path);
                return ConnectionPointUtils.findOrCreateWorkspaceConnectionPoint((IContainer)container);
            }
            if (this.filesystemRadio.getSelection()) {
                IPath path = Path.fromPortableString((String)this.filesystemFolderText.getText());
                return ConnectionPointUtils.findOrCreateLocalConnectionPoint((IPath)path);
            }
            return null;
        }

        private String validate() {
            if (this.isDefault) {
                return null;
            }
            if (this.remoteRadio.getSelection()) {
                IConnectionPoint connectionPoint = (IConnectionPoint)((IStructuredSelection)this.remotesViewer.getSelection()).getFirstElement();
                if (connectionPoint == null) {
                    return Messages.SiteConnectionPropertiesWidget_ERR_NoRemote;
                }
            } else if (this.projectRadio.getSelection()) {
                IProject project = (IProject)((IStructuredSelection)this.projectViewer.getSelection()).getFirstElement();
                if (project == null) {
                    return Messages.SiteConnectionPropertiesWidget_ERR_NoProject;
                }
                IPath path = Path.fromPortableString((String)this.projectFolderText.getText());
                if (!(project.findMember(path) instanceof IContainer)) {
                    return Messages.SiteConnectionPropertiesWidget_ERR_InvalidProjectFolder;
                }
            } else if (this.filesystemRadio.getSelection()) {
                IPath path = Path.fromPortableString((String)this.filesystemFolderText.getText());
                if (!path.toFile().isDirectory()) {
                    return Messages.SiteConnectionPropertiesWidget_ERR_InvalidFilesystemFolder;
                }
            } else {
                return StringUtils.format((String)Messages.SiteConnectionPropertiesWidget_ERR_NoType, (String)this.name.toLowerCase());
            }
            return null;
        }
    }
}

