/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.editors;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.editors.ConnectionEditor;
import com.aptana.ide.syncing.ui.editors.ConnectionEditorInput;
import com.aptana.ide.syncing.ui.editors.Messages;
import java.text.MessageFormat;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    public static void openConnectionEditor(final ISiteConnection site) {
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    try {
                        IEditorPart editorPart = page.openEditor((IEditorInput)new ConnectionEditorInput(site), "com.aptana.ide.syncing.ui.editors.ConnectionEditor");
                        if (editorPart instanceof ConnectionEditor) {
                            ((ConnectionEditor)editorPart).setSelectedSite(site);
                        }
                    }
                    catch (PartInitException e) {
                        SyncingUIPlugin.log(MessageFormat.format(Messages.EditorUtils_FailedToOpenEditor, site.getName()), e);
                    }
                }
            }
        });
    }

    public static void closeConnectionEditor(final ISiteConnection site) {
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IEditorPart editor;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (editor = (page = window.getActivePage()).findEditor((IEditorInput)new ConnectionEditorInput(site))) != null) {
                    page.closeEditor(editor, false);
                }
            }
        });
    }
}

