/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.actions.BaseSyncAction;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class UploadAction
extends BaseSyncAction {
    private static String MESSAGE_TITLE = StringUtils.ellipsify((String)Messages.UploadAction_MessageTitle);

    protected void performAction(final IAdaptable[] files, final ISiteConnection site) throws CoreException {
        Job job = new Job(MESSAGE_TITLE){

            protected IStatus run(IProgressMonitor monitor) {
                IFileStore targetRoot;
                IFileStore sourceRoot;
                IConnectionPoint source = site.getSource();
                IConnectionPoint target = site.getDestination();
                try {
                    sourceRoot = source.getRoot();
                    if (!target.isConnected()) {
                        target.connect(monitor);
                    }
                    targetRoot = target.getRoot();
                }
                catch (CoreException e) {
                    return new Status(4, "com.aptana.ide.syncing.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                IFileStore[] fileStores = new IFileStore[files.length];
                int i = 0;
                while (i < fileStores.length) {
                    fileStores[i] = SyncUtils.getFileStore(files[i]);
                    ++i;
                }
                CopyFilesOperation operation = new CopyFilesOperation(UploadAction.this.getShell());
                IStatus status = operation.copyFiles(fileStores, sourceRoot, targetRoot, monitor);
                if (status != Status.CANCEL_STATUS) {
                    UploadAction.this.postAction(status);
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected String getMessageTitle() {
        return MESSAGE_TITLE;
    }

    private void postAction(final IStatus status) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DialogUtils.openIgnoreMessageDialogInformation((Shell)UploadAction.this.getShell(), (String)MESSAGE_TITLE, (String)MessageFormat.format(Messages.UploadAction_PostMessage, status.getCode()), (IPreferenceStore)SyncingUIPlugin.getDefault().getPreferenceStore(), (String)"IGNORE_DIALOG_FILE_UPLOAD");
            }
        });
    }
}

