/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.ILoggable;
import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.core.model.BaseModelObject;
import com.aptana.ide.syncing.core.Synchronizer;
import com.aptana.ide.syncing.ui.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class SyncModel
extends BaseModelObject
implements ILoggable {
    public static final int USE_STREAM = -100;
    public static final int WAITING = 0;
    public static final int RUNNING = 1;
    public static final int SUCCESS = 2;
    public static final int FAILURE = 3;
    private List<SyncPair> items = new ArrayList<SyncPair>();
    private List<Pair> toBeProcessed = new ArrayList<Pair>();
    private SyncPair lastSync = null;
    private SyncPair lastAdded = null;
    private SyncPair currentSync = null;
    private Job buildJob;
    private Job syncJob;
    private ILogger logger;

    public SyncModel() {
        this.listeners = new ListenerList();
        this.buildJob = new Job("Building sync pairs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                block35: {
                    Pair pair = null;
                    List list = SyncModel.this.toBeProcessed;
                    synchronized (list) {
                        while (SyncModel.this.toBeProcessed.isEmpty()) {
                            try {
                                SyncModel.this.toBeProcessed.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            if (monitor == null || !monitor.isCanceled()) continue;
                            return Status.CANCEL_STATUS;
                        }
                        if (SyncModel.this.toBeProcessed.size() > 0) {
                            pair = (Pair)SyncModel.this.toBeProcessed.remove(0);
                        }
                    }
                    if (pair != null) {
                        String fromEnd = null;
                        String fromFolder = null;
                        String toEnd = null;
                        String toFolder = null;
                        Object from = pair.from;
                        Object to = pair.to;
                        IConnectionPoint fromPoint = null;
                        IConnectionPoint toPoint = null;
                        IFileStore fromFile = null;
                        IFileStore toFile = null;
                        if (from instanceof IFileStore) {
                            fromFile = (IFileStore)from;
                            fromEnd = fromPoint.getName();
                            fromFolder = EFSUtils.getRelativePath(fromPoint, (IFileStore)fromFile);
                        }
                        if (to instanceof IFileStore) {
                            toFile = (IFileStore)to;
                            toEnd = toPoint.getName();
                            toFolder = EFSUtils.getRelativePath(toPoint, (IFileStore)toFile);
                        } else if (to instanceof IConnectionPoint) {
                            try {
                                toFile = ((IConnectionPoint)to).getRoot();
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            toEnd = ((IConnectionPoint)to).getName();
                            toFolder = EFSUtils.getRelativePath(toPoint, (IFileStore)toFile);
                        }
                        if (fromFile != null && toFile != null) {
                            if (fromFile.fetchInfo().isDirectory()) {
                                try {
                                    VirtualFileSyncPair[] pairs;
                                    IFileStore[] files;
                                    boolean dirExists = false;
                                    IFileStore toDir = toFile.getFileStore((IPath)new Path(fromFile.getName()));
                                    IFileStore[] iFileStoreArray = files = EFSUtils.getFiles((IFileStore)toFile, null);
                                    int n = files.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IFileStore target = iFileStoreArray[n2];
                                        if (target.fetchInfo().isDirectory() && target.getName().equals(fromFile.getName())) {
                                            dirExists = true;
                                            break;
                                        }
                                        ++n2;
                                    }
                                    if (!dirExists) {
                                        toDir.mkdir(0, null);
                                        if (to instanceof IContainer) {
                                            try {
                                                ((IContainer)to).refreshLocal(2, null);
                                            }
                                            catch (CoreException coreException) {}
                                        }
                                    }
                                    IConnectionPoint fromManager = fromPoint;
                                    IConnectionPoint toManager = toPoint;
                                    if (fromManager == null || toManager == null) break block35;
                                    Synchronizer syncer = new Synchronizer();
                                    syncer.setLogger(SyncModel.this.logger);
                                    syncer.setServerFileManager(toManager);
                                    syncer.setClientFileManager(fromManager);
                                    VirtualFileSyncPair[] virtualFileSyncPairArray = pairs = syncer.getSyncItems(fromPoint, toPoint, fromFile, toDir, monitor);
                                    int n3 = pairs.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        VirtualFileSyncPair vfsPair = virtualFileSyncPairArray[n4];
                                        if (vfsPair.getSyncState() != 6) {
                                            vfsPair.setSyncState(4);
                                        }
                                        SyncPair syncPair = new SyncPair(vfsPair);
                                        syncPair.fromEndpoint = fromEnd;
                                        syncPair.fromFolder = fromFolder;
                                        syncPair.toEndpoint = toEnd;
                                        syncPair.toFolder = toFolder;
                                        syncPair.status = 0;
                                        syncPair.destManager = toManager;
                                        syncPair.sourceManager = fromManager;
                                        List list2 = SyncModel.this.items;
                                        synchronized (list2) {
                                            SyncModel.this.items.add(syncPair);
                                            SyncModel.this.lastAdded = syncPair;
                                            SyncModel.this.fireChange();
                                            SyncModel.this.items.notify();
                                        }
                                        ++n4;
                                    }
                                }
                                catch (IOException e) {
                                    SyncModel.this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)e.getLocalizedMessage()));
                                }
                                catch (CoreException e) {
                                    SyncModel.this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)e.getLocalizedMessage()));
                                }
                            } else {
                                toFile = toFile.getFileStore((IPath)new Path(fromFile.getName()));
                                VirtualFileSyncPair vfsPair = new VirtualFileSyncPair(fromFile, toFile, "", -100);
                                SyncPair syncPair = new SyncPair(vfsPair);
                                syncPair.fromEndpoint = fromEnd;
                                syncPair.fromFolder = fromFolder;
                                syncPair.toEndpoint = toEnd;
                                syncPair.toFolder = toFolder;
                                syncPair.status = 0;
                                syncPair.destManager = toPoint;
                                syncPair.sourceManager = fromPoint;
                                List list3 = SyncModel.this.items;
                                synchronized (list3) {
                                    SyncModel.this.items.add(syncPair);
                                    SyncModel.this.lastAdded = syncPair;
                                    SyncModel.this.fireChange();
                                    SyncModel.this.items.notify();
                                }
                            }
                        }
                    }
                }
                if (monitor == null || !monitor.isCanceled()) {
                    this.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        this.buildJob.setPriority(40);
        this.buildJob.setSystem(true);
        this.buildJob.schedule();
        this.syncJob = new Job("Running Sync jobs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                List list = SyncModel.this.items;
                synchronized (list) {
                    while (SyncModel.this.items.isEmpty()) {
                        try {
                            SyncModel.this.items.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (monitor == null || !monitor.isCanceled()) continue;
                        return Status.CANCEL_STATUS;
                    }
                    if (SyncModel.this.items.size() > 0) {
                        SyncPair pair = (SyncPair)((Object)SyncModel.this.items.remove(0));
                        SyncModel.this.currentSync = pair;
                        ((SyncModel)SyncModel.this).currentSync.status = 1;
                        SyncModel.this.fireChange();
                        if (pair.getSyncState() == -100) {
                            try {
                                SyncModel.this.log(String.valueOf(FileUtils.NEW_LINE) + StringUtils.format((String)Messages.Synchronizer_Uploading, (String)EFSUtils.getAbsolutePath((IFileStore)pair.getSourceFile())));
                                if (!pair.getDestinationFile().equals(pair.getSourceFile())) {
                                    pair.getSourceFile().copy(pair.getDestinationFile(), 2, null);
                                    try {
                                        EFSUtils.setModificationTime((long)pair.getSourceFileInfo().getLastModified(), (IFileStore)pair.getDestinationFile());
                                    }
                                    catch (Exception exception) {}
                                }
                                SyncModel.this.log(Messages.Synchronizer_Success);
                                pair.status = 2;
                                SyncModel.this.lastSync = pair;
                                SyncModel.this.fireChange();
                            }
                            catch (Exception e) {
                                SyncModel.this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)e.getLocalizedMessage()));
                                pair.status = 3;
                                SyncModel.this.lastSync = pair;
                                SyncModel.this.fireChange();
                            }
                        } else {
                            Synchronizer syncer = new Synchronizer();
                            syncer.setLogger(SyncModel.this.logger);
                            try {
                                syncer.setClientFileManager(pair.sourceManager);
                                syncer.setServerFileManager(pair.destManager);
                                syncer.uploadAndDelete(new VirtualFileSyncPair[]{pair}, null);
                                pair.status = 2;
                                SyncModel.this.lastSync = pair;
                                SyncModel.this.fireChange();
                            }
                            catch (Exception e) {
                                SyncModel.this.log(StringUtils.format((String)Messages.Synchronizer_Error, (String)e.getLocalizedMessage()));
                                pair.status = 3;
                                SyncModel.this.lastSync = pair;
                                SyncModel.this.fireChange();
                            }
                        }
                    }
                }
                if (monitor == null || !monitor.isCanceled()) {
                    this.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        this.syncJob.setPriority(40);
        this.syncJob.setSystem(true);
        this.syncJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<Object> list = this.items;
        synchronized (list) {
            this.syncJob.cancel();
            this.items.notify();
        }
        list = this.toBeProcessed;
        synchronized (list) {
            this.buildJob.cancel();
            this.toBeProcessed.notify();
        }
    }

    private synchronized void log(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncing(Object from, Object to) {
        List<Pair> list = this.toBeProcessed;
        synchronized (list) {
            this.toBeProcessed.add(new Pair(from, to));
            this.toBeProcessed.notify();
        }
    }

    public SyncPair[] getItems() {
        return this.items.toArray(new SyncPair[0]);
    }

    public SyncPair getLastSync() {
        return this.lastSync;
    }

    public SyncPair getLastAdded() {
        return this.lastAdded;
    }

    public SyncPair getCurrentSync() {
        return this.currentSync;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public synchronized void setLogger(ILogger logger) {
        this.logger = logger;
    }

    private class Pair {
        Object from;
        Object to;

        Pair(Object from, Object to) {
            this.from = from;
            this.to = to;
        }
    }

    public class SyncPair
    extends VirtualFileSyncPair {
        int status;
        IConnectionPoint sourceManager;
        IConnectionPoint destManager;
        String fromEndpoint;
        String fromFolder;
        String toEndpoint;
        String toFolder;

        SyncPair(VirtualFileSyncPair vfsPair) {
            this(vfsPair.getSourceFile(), vfsPair.getDestinationFile(), vfsPair.getRelativePath(), vfsPair.getSyncState());
        }

        SyncPair(IFileStore sourceFile, IFileStore destinationFile, String relativePath, int syncState) {
            super(sourceFile, destinationFile, relativePath, syncState);
        }

        public IConnectionPoint getDestManager() {
            return this.destManager;
        }

        public IConnectionPoint getSourceManager() {
            return this.sourceManager;
        }

        public int getStatus() {
            return this.status;
        }

        public String getFromEndpoint() {
            return this.fromEndpoint;
        }

        public String getFromFolder() {
            return this.fromFolder;
        }

        public String getToEndpoint() {
            return this.toEndpoint;
        }

        public String getToFolder() {
            return this.toFolder;
        }
    }
}

