/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.ui.dialogs;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.jetty.ui.dialogs.Messages;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.views.ServerLabelProvider;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class JettyConfigurationDialog
extends TitleAreaDialog
implements IConfigurationDialog {
    private Text nameText;
    private boolean isEdit;
    private IAbstractConfiguration configuration;
    private HashSet<String> serverNames = new HashSet();
    private Text portText;
    private Text idText;
    private boolean wasError;
    private Text descText;
    private IServer server;

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_jetty");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        Label titleBarSeparator = new Label(composite, 258);
        GridData dta2 = new GridData(768);
        dta2.horizontalSpan = 2;
        titleBarSeparator.setLayoutData((Object)dta2);
        Composite composite1 = new Composite(composite, 0);
        composite1.setLayoutData((Object)new GridData(1808));
        composite1.setLayout((Layout)new GridLayout(2, false));
        this.setTitle(Messages.JettyConfigurationDialog_SERVER);
        this.getShell().setText(Messages.JettyConfigurationDialog_DIALOG_SHELLTITLE);
        this.setMessage(Messages.JettyConfigurationDialog_DESCRIPTION);
        composite.setLayout((Layout)layout);
        GridData cData = new GridData(1808);
        cData.widthHint = 500;
        composite.setLayoutData((Object)cData);
        composite.setFont(parent.getFont());
        Label name = new Label(composite1, 0);
        name.setText(Messages.JettyConfigurationDialog_SERVER_NAME);
        this.nameText = new Text(composite1, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.configuration.getStringAttribute("name"));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JettyConfigurationDialog.this.validate();
            }
        };
        Label descr = new Label(composite1, 0);
        descr.setText(Messages.JettyConfigurationDialog_Description);
        this.descText = new Text(composite1, 2048);
        this.descText.setLayoutData((Object)new GridData(768));
        this.descText.setText(this.configuration.getStringAttribute("description"));
        this.descText.addModifyListener(modifyListener);
        Label port = new Label(composite1, 0);
        port.setText(Messages.JettyConfigurationDialog_PORT);
        this.portText = new Text(composite1, 2048);
        this.portText.setLayoutData((Object)new GridData(768));
        Label id = new Label(composite1, 0);
        id.setText(Messages.JettyConfigurationDialog_APP_ID);
        this.portText.setText(this.configuration.getStringAttribute("port"));
        Composite cm2 = new Composite(composite1, 0);
        GridLayout ll2 = new GridLayout(2, false);
        ll2.marginWidth = 0;
        ll2.marginHeight = 0;
        cm2.setLayout((Layout)ll2);
        this.idText = new Text(cm2, 2056);
        this.idText.setLayoutData((Object)new GridData(768));
        String root = this.configuration.getStringAttribute("serverId");
        IContainer findMember = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(root));
        if (findMember != null) {
            this.idText.setText(findMember.getLocation().toPortableString());
        }
        final Button choose = new Button(cm2, 8);
        choose.setText(Messages.JettyConfigurationDialog_CHOOSE_BUTTON_TITLE);
        choose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dlg = new ContainerSelectionDialog(choose.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.JettyConfigurationDialog_CONTAINER_DIALOG_MESSAGE);
                int open = dlg.open();
                if (open == 0) {
                    Object[] result = dlg.getResult();
                    IPath cnt = (IPath)result[0];
                    IResource c1 = ResourcesPlugin.getWorkspace().getRoot().findMember(cnt);
                    JettyConfigurationDialog.this.idText.setText(c1.getLocation().toPortableString());
                    JettyConfigurationDialog.this.validate();
                }
            }
        });
        cm2.setLayoutData((Object)new GridData(768));
        this.initDublicateNames();
        this.nameText.addModifyListener(modifyListener);
        this.portText.addModifyListener(modifyListener);
        this.validate();
        return composite;
    }

    private void initDublicateNames() {
        IServer[] servers;
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer s = iServerArray[n2];
            if (!s.getId().equals(this.configuration.getStringAttribute("id"))) {
                this.serverNames.add(s.getName());
            }
            ++n2;
        }
    }

    public boolean validate() {
        String name = this.nameText.getText();
        if (name.length() == 0) {
            this.updateStatus(false, Messages.JettyConfigurationDialog_NAME_SHOULD_NOT_BE_EMPTY);
            return false;
        }
        if (this.serverNames.contains(name)) {
            this.updateStatus(false, Messages.JettyConfigurationDialog_DUBLICATES_ARE_NOT_ALLOWED);
            return false;
        }
        String port = this.portText.getText();
        try {
            Integer i = Integer.parseInt(port);
            if (i < 0 || i > 65535) {
                this.updateStatus(false, Messages.JettyConfigurationDialog_PORT_RANGE);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateStatus(false, Messages.JettyConfigurationDialog_PORT_SHOULD_BE_NUMBER);
            return false;
        }
        String root = this.idText.getText();
        if (root.length() == 0) {
            this.updateStatus(false, Messages.JettyConfigurationDialog_CONTEXT_ROOT_VALIDATION_MESSAGE);
            return false;
        }
        this.updateStatus(true, null);
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.validate();
        return createButtonBar;
    }

    public JettyConfigurationDialog() {
        super(Display.getCurrent().getActiveShell());
    }

    public IAbstractConfiguration getConfiguration() {
        return this.configuration;
    }

    public Dialog getDialog() {
        return this;
    }

    public void updateStatus(boolean isOk, String message) {
        Button button = this.getButton(0);
        if (!isOk) {
            this.wasError = true;
            this.setErrorMessage(message);
            if (button != null) {
                button.setEnabled(false);
            }
        } else {
            if (!this.wasError) {
                if (this.server != null && this.server.getServerState() != 4 && this.server.getServerState() != 0) {
                    this.setErrorMessage(ServerLabelProvider.SERVER_IS_RUNNING_NO_EDIT);
                    if (button != null) {
                        button.setEnabled(false);
                    }
                    return;
                }
                return;
            }
            this.wasError = false;
            this.setErrorMessage(null);
            if (button != null) {
                button.setEnabled(true);
            }
        }
    }

    protected void okPressed() {
        this.configuration.setStringAttribute("name", this.nameText.getText());
        this.configuration.setStringAttribute("port", this.portText.getText());
        this.configuration.setStringAttribute("description", this.descText.getText());
        this.configuration.setStringAttribute("serverId", this.idText.getText());
        super.okPressed();
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public void setServer(IServer server) {
        this.server = server;
    }
}

