/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.secureftp;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.core.io.vfs.ExtendedFileInfo;
import com.aptana.ide.filesystem.ftp.BaseFTPConnectionFileManager;
import com.aptana.ide.filesystem.ftp.ExpiringMap;
import com.aptana.ide.filesystem.secureftp.FTPFileDownloadInputStream;
import com.aptana.ide.filesystem.secureftp.FTPFileUploadOutputStream;
import com.aptana.ide.filesystem.secureftp.ISFTPConnectionFileManager;
import com.aptana.ide.filesystem.secureftp.Policy;
import com.aptana.ide.filesystem.secureftp.SSHHostValidator;
import com.aptana.ide.filesystem.secureftp.SecureFTPPlugin;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPAlgorithm;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.ftp.ssh.SSHFTPInputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

class SFTPConnectionFileManager
extends BaseFTPConnectionFileManager
implements ISFTPConnectionFileManager {
    protected static final int SLEEP_INTERVAL = 10;
    private SSHFTPClient ftpClient;
    private IPath keyFilePath;
    private String transferType;
    private String controlEncoding;
    private String compression;
    private IPath cwd;
    private Map<IPath, FTPFile> ftpFileCache = new ExpiringMap(60000L);
    private int connectionRetryCount;

    SFTPConnectionFileManager() {
    }

    public void init(String host, int port, IPath basePath, IPath keyFilePath, String login, char[] password, String transferType, String encoding, String compression) {
        Assert.isTrue((this.ftpClient == null ? 1 : 0) != 0, (String)"SFTP connection has been already initiated");
        try {
            this.ftpClient = new SSHFTPClient();
            this.host = host;
            this.port = port;
            this.keyFilePath = keyFilePath;
            this.login = login;
            this.password = password == null ? new char[]{} : password;
            this.basePath = basePath != null ? basePath : Path.ROOT;
            this.authId = keyFilePath != null ? Policy.generateAuthId("SFTP/PUBLICKEY", login, host, port) : Policy.generateAuthId("SFTP", login, host, port);
            this.transferType = transferType;
            this.controlEncoding = encoding;
            this.compression = compression;
            SFTPConnectionFileManager.initFTPClient(this.ftpClient, encoding, compression);
        }
        catch (Exception e) {
            IdeLog.logImportant((Plugin)SecureFTPPlugin.getDefault(), (String)"SFTP connection initialization failed", (Throwable)e);
            this.ftpClient = null;
        }
    }

    private static void initFTPClient(SSHFTPClient ftpClient, String encoding, String compression) throws IOException, FTPException {
        ftpClient.setTimeout(20000);
        ftpClient.setControlEncoding(encoding);
        ftpClient.setMonitorInterval(1024L);
        ftpClient.setSleepEnabled(true);
        ftpClient.setSleepTime(10);
        if ("NONE".equals(compression)) {
            ftpClient.disableAllAlgorithms(1);
            ftpClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_NONE, true);
        } else if ("ZLIB".equals(compression)) {
            ftpClient.disableAllAlgorithms(1);
            ftpClient.setAlgorithmEnabled(SSHFTPAlgorithm.COMPRESSION_ZLIB, true);
        }
        ftpClient.setTransportProvider(1);
        ftpClient.setConfigFlags(0);
        ftpClient.setTransferBufferSize(32768);
        ftpClient.setValidator((SSHFTPValidator)new SSHHostValidator());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(IProgressMonitor monitor) throws CoreException {
        Assert.isTrue((this.ftpClient != null ? 1 : 0) != 0, (String)"SFTP connection is not initialized");
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                this.cwd = null;
                this.cleanup();
                ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)this);
                monitor.beginTask("Establishing connection", -1);
                this.ftpClient.setRemoteHost(this.host);
                this.ftpClient.setRemotePort(this.port);
                while (true) {
                    block28: {
                        block27: {
                            SshPrivateKeyFile privateKeyFile;
                            block26: {
                                block24: {
                                    block25: {
                                        if (this.keyFilePath == null) break block24;
                                        try {
                                            privateKeyFile = SshPrivateKeyFile.parse((File)this.keyFilePath.toFile());
                                        }
                                        catch (InvalidSshKeyException e) {
                                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Private Key file {0} is invalid.", (String)this.keyFilePath.toOSString()), (Throwable)e));
                                        }
                                        catch (IOException iOException) {
                                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Private Key file {0} cannot be read.", (String)this.keyFilePath.toOSString())));
                                        }
                                        if (!privateKeyFile.isPassphraseProtected() || this.password.length != 0) break block25;
                                        if (context == null || !context.getBoolean("no_password_prompt")) break block26;
                                        this.password = new char[0];
                                        break block27;
                                    }
                                    if (this.password == null) {
                                        this.password = new char[0];
                                    }
                                    break block27;
                                }
                                if (!(this.password.length != 0 || "anonymous".equals(this.login) || context != null && context.getBoolean("no_password_prompt"))) {
                                    this.getOrPromptPassword(StringUtils.format((String)"SFTP Authentication for {0}", (String)this.host), "Please specify password.");
                                }
                                this.ftpClient.setAuthentication(this.login, String.copyValueOf(this.password));
                                break block28;
                            }
                            this.getOrPromptPassword(StringUtils.format((String)"Public Key Authentication for {0} using {1}", (Object[])new Object[]{this.host, this.keyFilePath.toOSString()}), "Please specify private key passphrase.");
                            while (true) {
                                try {
                                    privateKeyFile.toPrivateKey(String.copyValueOf(this.password));
                                }
                                catch (InvalidSshKeyException invalidSshKeyException) {
                                    this.promptPassword(StringUtils.format((String)"Public Key Authentication for {0} using {1}", (Object[])new Object[]{this.host, this.keyFilePath.toOSString()}), "Passphrase was not accepted. Please specify again.");
                                    continue;
                                }
                                break;
                            }
                        }
                        try {
                            this.ftpClient.setAuthentication(this.keyFilePath.toOSString(), this.login, String.copyValueOf(this.password));
                        }
                        catch (InvalidSshKeyException e) {
                            if (this.password.length != 0) throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Passphrase for Private Key {0} is invalid.", (String)this.keyFilePath.toOSString()), (Throwable)e));
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Private Key {0} requires passphrase.", (String)this.keyFilePath.toOSString()), (Throwable)e));
                        }
                    }
                    Policy.checkCanceled(monitor);
                    monitor.subTask("connecting and authenticating");
                    try {
                        this.ftpClient.connect();
                    }
                    catch (SSHFTPException e) {
                        Policy.checkCanceled(monitor);
                        if (this.keyFilePath != null) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Public Key Authentication failed: {0}", (String)e.getLocalizedMessage()), (Throwable)e));
                        }
                        if (context != null && context.getBoolean("no_password_prompt")) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Authentication failed: {0}", (String)"Login/password is incorrect."), (Throwable)e));
                        }
                        this.promptPassword(StringUtils.format((String)"SFTP Authentication for {0}", (String)this.host), "Password was not accepted. Please specify again.");
                        this.safeQuit();
                        continue;
                    }
                    break;
                }
                Policy.checkCanceled(monitor);
                this.changeCurrentDir(this.basePath);
                this.ftpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
                return;
            }
            catch (OperationCanceledException e) {
                this.safeQuit();
                throw e;
            }
            catch (CoreException e) {
                this.safeQuit();
                throw e;
            }
            catch (UnknownHostException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Host name not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Remote folder not found: " + e.getLocalizedMessage(), (Throwable)e));
            }
            catch (Exception e) {
                this.safeQuit();
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Establishing SFTP connection failed:" + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void safeQuit() {
        try {
            if (this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception exception) {
            try {
                this.ftpClient.quitImmediately();
            }
            catch (Exception exception2) {}
        }
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        try {
            this.checkConnected();
        }
        catch (Exception exception) {}
        if (!this.isConnected()) {
            return;
        }
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask("Closing SFTP connection", -1);
        try {
            try {
                this.ftpClient.quit();
            }
            catch (Exception e) {
                try {
                    this.ftpClient.quitImmediately();
                }
                catch (Exception exception) {}
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Disconnect SFTP connection failed", (Throwable)e));
            }
        }
        finally {
            this.cwd = null;
            this.cleanup();
            monitor.done();
        }
    }

    public boolean isConnected() {
        return this.ftpClient != null && this.ftpClient.connected();
    }

    private void changeCurrentDir(IPath path) throws FTPException, IOException {
        try {
            if (this.cwd == null) {
                this.cwd = new Path(this.ftpClient.pwd());
            }
            if (!this.cwd.equals((Object)path)) {
                this.ftpClient.chdir(path.toPortableString());
                this.cwd = path;
            }
        }
        catch (FTPException e) {
            SFTPConnectionFileManager.throwFileNotFound(e, path);
        }
        catch (IOException e) {
            this.cwd = null;
            throw e;
        }
    }

    private static void throwFileNotFound(FTPException e, IPath path) throws FileNotFoundException, FTPException {
        int reply = e.getReplyCode();
        if (reply == -1 || reply == 2 || reply == 10) {
            throw new FileNotFoundException(path.toPortableString());
        }
    }

    private static void fillFileInfo(ExtendedFileInfo fileInfo, FTPFile ftpFile) {
        fileInfo.setExists(true);
        fileInfo.setName(ftpFile.getName());
        fileInfo.setDirectory(ftpFile.isDir());
        fileInfo.setLength(ftpFile.size());
        fileInfo.setLastModified(ftpFile.lastModified() != null ? ftpFile.lastModified().getTime() : 0L);
        fileInfo.setOwner(ftpFile.getOwner());
        fileInfo.setGroup(ftpFile.getGroup());
        fileInfo.setPermissions(Policy.permissionsFromString(ftpFile.getPermissions()));
        if (ftpFile.isLink()) {
            fileInfo.setAttribute(32, true);
            fileInfo.setStringAttribute(64, ftpFile.getLinkedName().trim());
        }
    }

    private static ExtendedFileInfo createFileInfo(FTPFile ftpFile) {
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(ftpFile.getName());
        SFTPConnectionFileManager.fillFileInfo(fileInfo, ftpFile);
        return fileInfo;
    }

    protected void clearCache(IPath path) {
        super.clearCache(path);
        path = this.basePath.append(path);
        int segments = path.segmentCount();
        for (IPath p : new ArrayList<IPath>(this.ftpFileCache.keySet())) {
            if (p.segmentCount() < segments || path.matchingFirstSegments(p) != segments) continue;
            this.ftpFileCache.remove(p);
        }
    }

    protected void checkConnected() throws Exception {
        if (this.ftpClient.connected()) {
            try {
                this.ftpClient.keepAlive();
                return;
            }
            catch (FTPException fTPException) {
                return;
            }
            catch (IOException iOException) {
                this.ftpClient.quitImmediately();
            }
        }
    }

    protected URI getRootCanonicalURI() {
        try {
            return new URI("sftp", this.login, this.host, this.port != 22 ? this.port : -1, Path.ROOT.toPortableString(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected ExtendedFileInfo fetchFile(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            IPath dirPath = path.removeLastSegments(1);
            String name = path.lastSegment();
            FTPFile result = this.ftpFileCache.get(path);
            if (result == null) {
                FTPFile[] ftpFiles;
                FTPFile[] fTPFileArray = ftpFiles = this.listFiles(dirPath, monitor);
                int n = ftpFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    FTPFile ftpFile = fTPFileArray[n2];
                    if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) {
                        if (Path.ROOT.equals((Object)path) && ".".equals(ftpFile.getName())) {
                            ftpFile.setName(path.toPortableString());
                            this.ftpFileCache.put(path, ftpFile);
                            result = ftpFile;
                        }
                    } else {
                        this.ftpFileCache.put(dirPath.append(ftpFile.getName()), ftpFile);
                        if (name != null && name.equals(ftpFile.getName())) {
                            result = ftpFile;
                        }
                    }
                    ++n2;
                }
            }
            if (result != null) {
                return SFTPConnectionFileManager.createFileInfo(result);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.connectionRetryCount < 1) {
                ++this.connectionRetryCount;
                this.testOrConnect(monitor);
                return this.fetchFile(path, options, monitor);
            }
            this.connectionRetryCount = 0;
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Fetching file info failed", (Throwable)e));
        }
        ExtendedFileInfo fileInfo = new ExtendedFileInfo(path.lastSegment());
        fileInfo.setExists(false);
        return fileInfo;
    }

    protected ExtendedFileInfo[] fetchFiles(IPath path, int options, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor = Policy.subMonitorFor(monitor, 1);
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            monitor.beginTask("Gathering file details", ftpFiles.length);
            ArrayList<ExtendedFileInfo> list = new ArrayList<ExtendedFileInfo>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) {
                    monitor.worked(1);
                } else {
                    IPath filePath = path.append(ftpFile.getName());
                    this.ftpFileCache.put(filePath, ftpFile);
                    ExtendedFileInfo fileInfo = SFTPConnectionFileManager.createFileInfo(ftpFile);
                    list.add(fileInfo);
                    monitor.worked(1);
                }
                ++n2;
            }
            ExtendedFileInfo[] extendedFileInfoArray = list.toArray(new ExtendedFileInfo[list.size()]);
            return extendedFileInfoArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.connectionRetryCount < 1) {
                ++this.connectionRetryCount;
                this.testOrConnect(monitor);
                ExtendedFileInfo[] extendedFileInfoArray = this.fetchFiles(path, options, monitor);
                return extendedFileInfoArray;
            }
            this.connectionRetryCount = 0;
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Fetching directory failed", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void createDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir(path);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    this.ftpClient.mkdir(path.toPortableString());
                    this.changeFilePermissions(path, PreferenceUtils.getDirectoryPermissions(), monitor);
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwFileNotFound(e, path);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Creating directory failed", (Throwable)e));
        }
    }

    protected void deleteDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        MultiStatus status = new MultiStatus("com.aptana.ide.filesystem.secureftp", 0, null, null);
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.recursiveDeleteTree(path, monitor, status);
                this.changeCurrentDir(dirPath);
                this.ftpClient.rmdir(path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                if (status.isOK()) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Deleting directory failed", (Throwable)e));
                }
                MultiStatus multiStatus = new MultiStatus("com.aptana.ide.filesystem.secureftp", 0, "Deleting directory failed", (Throwable)e);
                multiStatus.addAll((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void deleteFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    this.ftpClient.delete(path.lastSegment());
                }
                catch (FTPException e) {
                    IdeLog.logError((Plugin)SecureFTPPlugin.getDefault(), (String)("Failed to delete " + path.toString()), (Throwable)e);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Deleting {0} failed", (Object)path), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void renameFile(IPath sourcePath, IPath destinationPath, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.changeCurrentDir((IPath)Path.ROOT);
                Policy.checkCanceled(monitor);
                if (this.ftpClient.exists(destinationPath.toPortableString())) {
                    this.ftpClient.delete(destinationPath.toPortableString());
                }
                try {
                    this.ftpClient.rename(sourcePath.toPortableString(), destinationPath.toPortableString());
                }
                catch (FTPException e) {
                    SFTPConnectionFileManager.throwFileNotFound(e, sourcePath);
                    IdeLog.logError((Plugin)SecureFTPPlugin.getDefault(), (String)StringUtils.format((String)"Failed to rename {0} to {1}", (Object[])new Object[]{sourcePath, destinationPath}), (Throwable)e);
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Renaming failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String[] listDirectory(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> list = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (!".".equals(name) && !"..".equals(name)) {
                    this.ftpFileCache.put(path.append(ftpFile.getName()), ftpFile);
                    list.add(name);
                }
                ++n2;
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Listing directory failed", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream readFile(IPath path, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask("Initiating file download", 4);
        SSHFTPClient downloadFtpClient = new SSHFTPClient();
        try {
            SFTPConnectionFileManager.initFTPClient(downloadFtpClient, this.controlEncoding, this.compression);
            downloadFtpClient.setValidator(this.ftpClient.getValidator());
            downloadFtpClient.setRemoteHost(this.host);
            downloadFtpClient.setRemotePort(this.port);
            Policy.checkCanceled(monitor);
            if (this.keyFilePath != null) {
                downloadFtpClient.setAuthentication(this.keyFilePath.toOSString(), this.login, String.copyValueOf(this.password));
            } else {
                downloadFtpClient.setAuthentication(this.login, String.copyValueOf(this.password));
            }
            downloadFtpClient.connect();
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            downloadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            try {
                downloadFtpClient.chdir(path.removeLastSegments(1).toPortableString());
            }
            catch (FTPException e) {
                SFTPConnectionFileManager.throwFileNotFound(e, path.removeLastSegments(1));
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            try {
                FTPFileDownloadInputStream fTPFileDownloadInputStream = new FTPFileDownloadInputStream((FTPClientInterface)downloadFtpClient, (FileTransferInputStream)new SSHFTPInputStream(downloadFtpClient, path.lastSegment()));
                return fTPFileDownloadInputStream;
            }
            catch (FTPException e) {
                try {
                    SFTPConnectionFileManager.throwFileNotFound(e, path);
                }
                catch (Exception e2) {
                    if (downloadFtpClient.connected()) {
                        try {
                            if (e2 instanceof OperationCanceledException || e2 instanceof FTPException || e2 instanceof FileNotFoundException) {
                                downloadFtpClient.quit();
                            } else {
                                downloadFtpClient.quitImmediately();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        catch (FTPException fTPException) {}
                    }
                    if (e2 instanceof OperationCanceledException) {
                        throw (OperationCanceledException)((Object)e2);
                    }
                    if (e2 instanceof FileNotFoundException) {
                        throw (FileNotFoundException)e2;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Opening file failed", (Throwable)e2));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream writeFile(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        monitor.beginTask("Initiating file upload", 4);
        SSHFTPClient uploadFtpClient = new SSHFTPClient();
        try {
            SFTPConnectionFileManager.initFTPClient(uploadFtpClient, this.controlEncoding, this.compression);
            uploadFtpClient.setValidator(this.ftpClient.getValidator());
            uploadFtpClient.setRemoteHost(this.host);
            uploadFtpClient.setRemotePort(this.port);
            if (this.keyFilePath != null) {
                uploadFtpClient.setAuthentication(this.keyFilePath.toOSString(), this.login, String.copyValueOf(this.password));
            } else {
                uploadFtpClient.setAuthentication(this.login, String.copyValueOf(this.password));
            }
            Policy.checkCanceled(monitor);
            uploadFtpClient.connect();
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            uploadFtpClient.setType("ASCII".equals(this.transferType) ? FTPTransferType.ASCII : FTPTransferType.BINARY);
            IPath dirPath = path.removeLastSegments(1);
            try {
                uploadFtpClient.chdir(dirPath.toPortableString());
            }
            catch (FTPException e) {
                SFTPConnectionFileManager.throwFileNotFound(e, dirPath);
            }
            monitor.worked(1);
            Policy.checkCanceled(monitor);
            FTPFileUploadOutputStream fTPFileUploadOutputStream = new FTPFileUploadOutputStream((FTPClientInterface)uploadFtpClient, (FileTransferOutputStream)new SSHFTPOutputStream(uploadFtpClient, SFTPConnectionFileManager.generateTempFileName(path.lastSegment())), path.lastSegment(), new Date(), permissions);
            return fTPFileUploadOutputStream;
        }
        catch (Exception e) {
            if (uploadFtpClient.connected()) {
                try {
                    if (e instanceof OperationCanceledException || e instanceof FTPException || e instanceof FileNotFoundException) {
                        uploadFtpClient.quit();
                    } else {
                        uploadFtpClient.quitImmediately();
                    }
                }
                catch (IOException iOException) {
                }
                catch (FTPException fTPException) {}
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Opening file failed", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    protected void setModificationTime(IPath path, long modificationTime, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.ftpClient.setModTime(path.lastSegment(), new Date(modificationTime));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Set modification time failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFileGroup(IPath path, String group, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                try {
                    int gid = Integer.parseInt(group);
                    this.ftpClient.changeGroup(gid, path.lastSegment());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Group is not numeric");
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Set permissions failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void changeFilePermissions(IPath path, long permissions, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                IPath dirPath = path.removeLastSegments(1);
                this.changeCurrentDir(dirPath);
                Policy.checkCanceled(monitor);
                this.ftpClient.changeMode((int)(permissions & 0x1FFL), path.lastSegment());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", "Set permissions failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private FTPFile[] listFiles(IPath dirPath, IProgressMonitor monitor) throws IOException, ParseException, FTPException {
        try {
            return this.ftpClient.dirDetails(dirPath.toPortableString());
        }
        catch (FTPException e) {
            SFTPConnectionFileManager.throwFileNotFound(e, dirPath);
            return null;
        }
    }

    private void recursiveDeleteTree(IPath path, IProgressMonitor monitor, MultiStatus status) throws IOException, ParseException {
        try {
            this.changeCurrentDir(path);
            FTPFile[] ftpFiles = this.listFiles(path, monitor);
            ArrayList<String> dirs = new ArrayList<String>();
            FTPFile[] fTPFileArray = ftpFiles;
            int n = ftpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String name = ftpFile.getName();
                if (!".".equals(name) && !"..".equals(name)) {
                    if (ftpFile.isDir()) {
                        dirs.add(name);
                    } else {
                        Policy.checkCanceled(monitor);
                        monitor.subTask(path.append(name).toPortableString());
                        try {
                            this.ftpClient.delete(name);
                        }
                        catch (FTPException e) {
                            status.add((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Deleting {0} failed", (String)path.append(name).toPortableString()), (Throwable)e));
                        }
                        monitor.worked(1);
                    }
                }
                ++n2;
            }
            for (String name : dirs) {
                monitor.subTask(path.append(name).toPortableString());
                this.recursiveDeleteTree(path.append(name), monitor, status);
                Policy.checkCanceled(monitor);
                this.changeCurrentDir(path);
                Policy.checkCanceled(monitor);
                this.ftpClient.rmdir(name);
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "com.aptana.ide.filesystem.secureftp", StringUtils.format((String)"Deleting {0} failed", (String)path.toPortableString()), (Throwable)e));
        }
    }

    private static String generateTempFileName(String base) {
        StringBuffer sb = new StringBuffer();
        sb.append("_tmp_upload.").append(base);
        return sb.toString();
    }
}

