/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.ui.io.preferences.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PermissionsGroup {
    private Group fGroup;
    private Button fUserRead;
    private Button fUserWrite;
    private Button fUserExecute;
    private Button fGroupRead;
    private Button fGroupWrite;
    private Button fGroupExecute;
    private Button fAllRead;
    private Button fAllWrite;
    private Button fAllExecute;

    public PermissionsGroup(Composite parent) {
        this.fGroup = this.createContents(parent);
    }

    public Control getControl() {
        return this.fGroup;
    }

    public long getPermissions() {
        long permissions = 0L;
        permissions |= this.fUserRead.getSelection() ? 256L : 0L;
        permissions |= this.fUserWrite.getSelection() ? 128L : 0L;
        permissions |= this.fUserExecute.getSelection() ? 64L : 0L;
        permissions |= this.fGroupRead.getSelection() ? 32L : 0L;
        permissions |= this.fGroupWrite.getSelection() ? 16L : 0L;
        permissions |= this.fGroupExecute.getSelection() ? 8L : 0L;
        permissions |= this.fAllRead.getSelection() ? 4L : 0L;
        permissions |= this.fAllWrite.getSelection() ? 2L : 0L;
        return permissions |= this.fAllExecute.getSelection() ? 1L : 0L;
    }

    public void setPermissions(long permissions) {
        this.fUserRead.setSelection((permissions & 0x100L) != 0L);
        this.fUserWrite.setSelection((permissions & 0x80L) != 0L);
        this.fUserExecute.setSelection((permissions & 0x40L) != 0L);
        this.fGroupRead.setSelection((permissions & 0x20L) != 0L);
        this.fGroupWrite.setSelection((permissions & 0x10L) != 0L);
        this.fGroupExecute.setSelection((permissions & 8L) != 0L);
        this.fAllRead.setSelection((permissions & 4L) != 0L);
        this.fAllWrite.setSelection((permissions & 2L) != 0L);
        this.fAllExecute.setSelection((permissions & 1L) != 0L);
    }

    public void setText(String title) {
        if (!this.isDisposed()) {
            this.fGroup.setText(title);
        }
    }

    private Group createContents(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.PermissionsGroup_Title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_User));
        this.fUserRead = new Button((Composite)group, 32);
        this.fUserRead.setText(Messages.PermissionsGroup_Read);
        this.fUserWrite = new Button((Composite)group, 32);
        this.fUserWrite.setText(Messages.PermissionsGroup_Write);
        this.fUserExecute = new Button((Composite)group, 32);
        this.fUserExecute.setText(Messages.PermissionsGroup_Execute);
        label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_Group));
        this.fGroupRead = new Button((Composite)group, 32);
        this.fGroupRead.setText(Messages.PermissionsGroup_Read);
        this.fGroupWrite = new Button((Composite)group, 32);
        this.fGroupWrite.setText(Messages.PermissionsGroup_Write);
        this.fGroupExecute = new Button((Composite)group, 32);
        this.fGroupExecute.setText(Messages.PermissionsGroup_Execute);
        label = new Label((Composite)group, 0);
        label.setText(StringUtils.makeFormLabel((String)Messages.PermissionsGroup_All));
        this.fAllRead = new Button((Composite)group, 32);
        this.fAllRead.setText(Messages.PermissionsGroup_Read);
        this.fAllWrite = new Button((Composite)group, 32);
        this.fAllWrite.setText(Messages.PermissionsGroup_Write);
        this.fAllExecute = new Button((Composite)group, 32);
        this.fAllExecute.setText(Messages.PermissionsGroup_Execute);
        return group;
    }

    private boolean isDisposed() {
        return this.fGroup == null || this.fGroup.isDisposed();
    }
}

