/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.resources;

import com.aptana.ide.core.io.LocalRoot;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import com.aptana.ide.ui.io.actions.MoveFilesOperation;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.resources.Messages;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.resources.ResourceDropAdapterAssistant;

public class FileDropAdapterAssistant
extends ResourceDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (aDropAdapter.getCurrentTarget() == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = null;
        Object[] sources = null;
        TransferData currentTransfer = aDropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            sources = FileDropAdapterAssistant.getSelectedSourceFiles();
            aDropTargetEvent.detail = 0;
        }
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performDrop(aDropAdapter, (String[])aDropTargetEvent.data);
        } else if (sources != null && sources.length > 0) {
            status = aDropAdapter.getCurrentOperation() == 1 || !FileDropAdapterAssistant.isFromSameFilesystem(aDropAdapter.getCurrentTarget(), sources) ? this.performCopy(aDropAdapter, (IAdaptable[])sources) : this.performMove(aDropAdapter, (IAdaptable[])sources);
        }
        this.openError(status);
        return status;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStatus status = super.validateDrop(target, operation, transferType);
        if (status == Status.OK_STATUS) {
            return status;
        }
        if (!(target instanceof IAdaptable)) {
            return FileDropAdapterAssistant.createStatus(Messages.FileDropAdapterAssistant_ERR_NotAdaptable);
        }
        IAdaptable destination = (IAdaptable)target;
        IFileStore fileStore = Utils.getFileStore(destination);
        if (fileStore == null) {
            return FileDropAdapterAssistant.createStatus(Messages.FileDropAdapterAssistant_ERR_NotIFileStore);
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IAdaptable[] files = FileDropAdapterAssistant.getSelectedSourceFiles();
            if (files.length == 0) {
                return FileDropAdapterAssistant.createStatus(Messages.FileDropAdapterAssistant_ERR_InvalidDropSelection);
            }
            IAdaptable[] iAdaptableArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable file = iAdaptableArray[n2];
                if (file instanceof LocalRoot) {
                    return FileDropAdapterAssistant.createStatus(Messages.FileDropAdapterAssistant_ERR_DropLocalRoot);
                }
                ++n2;
            }
            String message = CopyFilesOperation.validateDestination(destination, files);
            if (message != null) {
                return FileDropAdapterAssistant.createStatus(message);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String message;
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            if ((message = CopyFilesOperation.validateDestination(destination, sourceNames)) != null) {
                return FileDropAdapterAssistant.createStatus(message);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus performCopy(final CommonDropAdapter dropAdapter, IAdaptable[] sources) {
        MultiStatus problems = new MultiStatus("com.aptana.ide.ui.io", 1, Messages.FileDropAdapterAssistant_ERR_Copying, null);
        IStatus validate = this.validateDrop(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentOperation(), dropAdapter.getCurrentTransfer());
        if (!validate.isOK()) {
            problems.merge(validate);
        }
        IFileStore destination = FileDropAdapterAssistant.getFolderStore((IAdaptable)dropAdapter.getCurrentTarget());
        CopyFilesOperation operation = new CopyFilesOperation(this.getShell());
        operation.copyFiles(sources, destination, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FileDropAdapterAssistant.this.refresh(dropAdapter.getCurrentTarget());
            }
        });
        return problems;
    }

    private IStatus performDrop(final CommonDropAdapter dropAdapter, String[] data) {
        MultiStatus problems = new MultiStatus("com.aptana.ide.ui.io", 0, Messages.FileDropAdapterAssistant_ERR_Importing, null);
        IStatus validate = this.validateDrop(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentOperation(), dropAdapter.getCurrentTransfer());
        if (!validate.isOK()) {
            problems.merge(validate);
        }
        IFileStore destination = FileDropAdapterAssistant.getFolderStore((IAdaptable)dropAdapter.getCurrentTarget());
        CopyFilesOperation operation = new CopyFilesOperation(this.getShell());
        operation.copyFiles(data, destination, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FileDropAdapterAssistant.this.refresh(dropAdapter.getCurrentTarget());
            }
        });
        return problems;
    }

    private IStatus performMove(final CommonDropAdapter dropAdapter, IAdaptable[] sources) {
        MultiStatus problems = new MultiStatus("com.aptana.ide.ui.io", 1, Messages.FileDropAdapterAssistant_ERR_Moving, null);
        IStatus validate = this.validateDrop(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentOperation(), dropAdapter.getCurrentTransfer());
        if (!validate.isOK()) {
            problems.merge(validate);
        }
        IFileStore destination = FileDropAdapterAssistant.getFolderStore((IAdaptable)dropAdapter.getCurrentTarget());
        MoveFilesOperation operation = new MoveFilesOperation(this.getShell());
        operation.copyFiles(sources, destination, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FileDropAdapterAssistant.this.refresh(dropAdapter.getCurrentTarget());
            }
        });
        return problems;
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String title = Messages.FileDropAdapterAssistant_ERR_DragAndDrop_Title;
        int codes = 6;
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            if (children.length == 1) {
                ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status, (int)codes);
            }
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status, (int)codes);
        }
    }

    private void refresh(Object element) {
        if (element instanceof IResource) {
            try {
                ((IResource)element).refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        } else {
            IOUIPlugin.refreshNavigatorView(element);
        }
    }

    private static IAdaptable[] getSelectedSourceFiles() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return FileDropAdapterAssistant.getSelectedSourceFiles((IStructuredSelection)selection);
        }
        return new IAdaptable[0];
    }

    private static IAdaptable[] getSelectedSourceFiles(IStructuredSelection selection) {
        ArrayList<IAdaptable> selectedFiles = new ArrayList<IAdaptable>();
        for (Object object : selection) {
            IAdaptable adaptable;
            IFileStore fileStore;
            if (!(object instanceof IAdaptable) || (fileStore = Utils.getFileStore(adaptable = (IAdaptable)object)) == null) continue;
            selectedFiles.add(adaptable);
        }
        return selectedFiles.toArray(new IAdaptable[selectedFiles.size()]);
    }

    private static IFileStore getFolderStore(IAdaptable destination) {
        IFileStore store = Utils.getFileStore(destination);
        IFileInfo info = Utils.getFileInfo(destination);
        if (store != null && info != null && !info.isDirectory()) {
            store = store.getParent();
        }
        return store;
    }

    private static boolean isFromSameFilesystem(Object destination, Object[] sources) {
        IFileStore fileStore = Utils.getFileStore(destination);
        if (fileStore == null) {
            return false;
        }
        IFileSystem filesystem = fileStore.getFileSystem();
        Object[] objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            IFileStore sourceFileStore = Utils.getFileStore(source);
            if (sourceFileStore == null) {
                return false;
            }
            if (sourceFileStore.getFileSystem() != filesystem) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static Status createStatus(String message) {
        return new Status(1, "com.aptana.ide.ui.io", 0, message, null);
    }
}

