/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.NewFolderAction;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.navigator.wizards.WizardShortcutAction;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class FileSystemNewAction
extends BaseSelectionListenerAction {
    private IWorkbenchWindow fWindow;
    private MenuCreator fMenuCreator;

    public FileSystemNewAction(IWorkbenchWindow window) {
        super(Messages.FileSystemNewAction_Text);
        this.fWindow = window;
        this.fMenuCreator = new MenuCreator();
        this.setMenuCreator(this.fMenuCreator);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.fMenuCreator.selectionChanged(selection);
        return super.updateSelection(selection);
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuManager dropDownMenuMgr;
        private NewFolderAction fNewFolderAction;

        public MenuCreator() {
            this.fNewFolderAction = new NewFolderAction(FileSystemNewAction.this.fWindow);
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            IContributionItem[] items;
            this.createDropDownMenuMgr();
            Menu menu = new Menu(parent);
            IContributionItem[] iContributionItemArray = items = this.dropDownMenuMgr.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem) {
                    item = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                item.fill(menu, -1);
                ++n2;
            }
            return menu;
        }

        public void selectionChanged(IStructuredSelection selection) {
            Object element;
            this.fNewFolderAction.selectionChanged(selection);
            if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
                IFileStore fileStore = Utils.getFileStore((IAdaptable)element);
                IFileInfo fileInfo = this.getFileInfo((IAdaptable)element);
                if (fileStore != null && fileInfo != null) {
                    String path = "";
                    if (fileInfo.isDirectory()) {
                        path = fileStore.toString();
                    } else if (fileStore.getParent() != null) {
                        path = fileStore.getParent().toString();
                    }
                    CoreUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.core.ui.PREF_CURRENT_DIRECTORY", path);
                }
            }
        }

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.add((IAction)this.fNewFolderAction);
                this.dropDownMenuMgr.add((IContributionItem)new Separator());
                List wizardIds = WebPerspectiveFactory.getFileWizardShortcuts();
                for (String id : wizardIds) {
                    IWizardDescriptor descriptor = NewWizardRegistry.getInstance().findWizard(id);
                    if (descriptor == null) continue;
                    this.dropDownMenuMgr.add((IAction)new WizardShortcutAction(FileSystemNewAction.this.fWindow, descriptor));
                }
                this.dropDownMenuMgr.add((IContributionItem)new Separator());
                this.dropDownMenuMgr.add((IAction)ActionFactory.NEW.create(FileSystemNewAction.this.fWindow));
            }
        }

        private IFileInfo getFileInfo(IAdaptable adaptable) {
            IFileStore fileStore;
            IFileInfo fileInfo = (IFileInfo)adaptable.getAdapter(IFileInfo.class);
            if (fileInfo == null && !(adaptable instanceof IConnectionPoint) && (fileStore = Utils.getFileStore(adaptable)) != null) {
                fileInfo = FileSystemUtils.fetchFileInfo(fileStore);
            }
            return fileInfo;
        }
    }
}

