/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.Utils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class FileSystemDeleteAction
extends BaseSelectionListenerAction {
    private Shell fShell;
    private Tree fTree;
    private List<IFileStore> fFiles;
    private Set<Object> fParentElements;
    private List<IJobChangeListener> fListeners;

    public FileSystemDeleteAction(Shell shell, Tree tree) {
        super(Messages.FileSystemDeleteAction_Text);
        this.fShell = shell;
        this.fTree = tree;
        this.fFiles = new ArrayList<IFileStore>();
        this.fParentElements = new HashSet<Object>();
        this.fListeners = new ArrayList<IJobChangeListener>();
    }

    public void addJobListener(IJobChangeListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeJobListener(IJobChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void run() {
        if (this.fFiles.isEmpty()) {
            return;
        }
        int count = this.fFiles.size();
        String message = count == 1 ? MessageFormat.format(Messages.FileSystemDeleteAction_Confirm_SingleFile, this.fFiles.get(0)) : MessageFormat.format(Messages.FileSystemDeleteAction_Confirm_MultipleFiles, count);
        if (MessageDialog.openQuestion((Shell)this.fShell, (String)Messages.FileSystemDeleteAction_Confirm_Title, (String)message)) {
            this.delete(this.fFiles.toArray(new IFileStore[this.fFiles.size()]));
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        TreeItem[] items;
        this.fFiles.clear();
        this.fParentElements.clear();
        TreeItem[] treeItemArray = items = this.fTree.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            IFileStore fileStore = Utils.getFileStore(element);
            if (fileStore != null) {
                this.fFiles.add(fileStore);
                TreeItem parentItem = item.getParentItem();
                if (parentItem != null) {
                    this.fParentElements.add(parentItem.getData());
                }
            }
            ++n2;
        }
        return super.updateSelection(selection) && !this.fFiles.isEmpty();
    }

    private void delete(final IFileStore[] files) {
        Job deleteJob = new Job(Messages.FileSystemDeleteAction_JobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.FileSystemDeleteAction_Task, files.length);
                IFileStore[] iFileStoreArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore file = iFileStoreArray[n2];
                    monitor.subTask(MessageFormat.format(Messages.FileSystemDeleteAction_SubTask, file.toString()));
                    FileSystemDeleteAction.deleteFile(file, monitor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ++n2;
                }
                monitor.done();
                for (Object element : FileSystemDeleteAction.this.fParentElements) {
                    IOUIPlugin.refreshNavigatorView(element);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (Messages.FileSystemDeleteAction_JobTitle.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deleteJob.setUser(true);
        for (IJobChangeListener listener : this.fListeners) {
            deleteJob.addJobChangeListener(listener);
        }
        deleteJob.schedule();
    }

    private static void deleteFile(IFileStore file, IProgressMonitor monitor) {
        try {
            file.delete(0, monitor);
        }
        catch (CoreException e) {
            UIUtils.showErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

