/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.internal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.FetchFileInfoStatus;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchFileInfoJob
extends Job {
    private IFileStore fileStore;

    public FetchFileInfoJob(IFileStore fileStore) {
        super(StringUtils.format((String)"Fetch info for {0}", (String)fileStore.toString()));
        this.fileStore = fileStore;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IFileInfo fileInfo;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            fileInfo = this.fileStore.fetchInfo(1024, monitor);
        }
        catch (CoreException e) {
            IdeLog.logImportant((Plugin)IOUIPlugin.getDefault(), (String)"Fetch info failed", (Throwable)e);
            return e.getStatus();
        }
        return new FetchFileInfoStatus(fileInfo);
    }
}

