/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.core.ui.syncing.SyncingConsole;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.Messages;
import com.aptana.ide.ui.io.internal.Utils;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class CopyFilesOperation {
    private Shell fShell;
    private boolean fCancelled;
    private boolean fAlwaysOverwrite;

    public CopyFilesOperation(Shell shell) {
        this.fShell = shell == null ? CoreUIUtils.getActiveShell() : shell;
    }

    public void copyFiles(IAdaptable[] sources, IFileStore destination, IJobChangeListener listener) {
        IFileStore[] fileStores = new IFileStore[sources.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = Utils.getFileStore(sources[i]);
            ++i;
        }
        this.copyFiles(fileStores, destination, listener);
    }

    public void copyFiles(String[] filenames, IFileStore destination, IJobChangeListener listener) {
        this.copyFiles(CopyFilesOperation.getFileStores(filenames), destination, listener);
    }

    public IStatus copyFiles(IFileStore[] sources, IFileStore destination, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                int retCode = DialogUtils.openIgnoreMessageDialogConfirm((Shell)CopyFilesOperation.this.fShell, (String)Messages.CopyFilesOperation_OverwriteTitle, (String)Messages.CopyFilesOperation_OverwriteWarning, (IPreferenceStore)IOUIPlugin.getDefault().getPreferenceStore(), (String)"COPY_OVERWRITE");
                CopyFilesOperation.this.fAlwaysOverwrite = retCode == 0;
            }
        });
        if (!this.fAlwaysOverwrite) {
            return Status.CANCEL_STATUS;
        }
        int successCount = 0;
        IFileStore[] iFileStoreArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore source = iFileStoreArray[n2];
            if (this.copyFile(source, destination.getChild(source.getName()), monitor)) {
                ++successCount;
            }
            if (this.fCancelled || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ++n2;
        }
        return new Status(0, "com.aptana.ide.ui.io", successCount, Messages.CopyFilesOperation_Status_OK, null);
    }

    public IStatus copyFiles(IFileStore[] sources, IFileStore sourceRoot, IFileStore destinationRoot, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                int retCode = DialogUtils.openIgnoreMessageDialogConfirm((Shell)CopyFilesOperation.this.fShell, (String)Messages.CopyFilesOperation_OverwriteTitle, (String)Messages.CopyFilesOperation_OverwriteWarning, (IPreferenceStore)IOUIPlugin.getDefault().getPreferenceStore(), (String)"COPY_OVERWRITE");
                CopyFilesOperation.this.fAlwaysOverwrite = retCode == 0;
            }
        });
        if (!this.fAlwaysOverwrite) {
            return Status.CANCEL_STATUS;
        }
        int successCount = 0;
        IFileStore[] iFileStoreArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore source = iFileStoreArray[n2];
            if (this.copyFile(source, sourceRoot, destinationRoot, monitor)) {
                ++successCount;
            }
            if (this.fCancelled || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ++n2;
        }
        return new Status(0, "com.aptana.ide.ui.io", successCount, Messages.CopyFilesOperation_Status_OK, null);
    }

    public static String validateDestination(IAdaptable destination, IAdaptable[] sources) {
        IFileStore[] sourceStores = new IFileStore[sources.length];
        int i = 0;
        while (i < sourceStores.length) {
            sourceStores[i] = Utils.getFileStore(sources[i]);
            ++i;
        }
        return CopyFilesOperation.validateDestination(destination, sourceStores);
    }

    public static String validateDestination(IAdaptable destination, String[] sourceNames) {
        return CopyFilesOperation.validateDestination(destination, CopyFilesOperation.getFileStores(sourceNames));
    }

    protected boolean copyFile(IFileStore sourceStore, IFileStore destinationStore, IProgressMonitor monitor) {
        if (sourceStore == null || CloakingUtils.isFileCloaked((IFileStore)sourceStore)) {
            return false;
        }
        boolean success = true;
        monitor.subTask(MessageFormat.format(Messages.CopyFilesOperation_Copy_Subtask, sourceStore.getName(), destinationStore.getName()));
        SyncingConsole.println((String)(String.valueOf(FileUtils.NEW_LINE) + MessageFormat.format(Messages.CopyFilesOperation_Copy_Subtask, sourceStore.toURI().toString(), destinationStore.toURI().toString())));
        if (destinationStore.equals(sourceStore) && (destinationStore = this.getNewNameFor(destinationStore)) == null) {
            SyncingConsole.println((String)". Failed.");
            return false;
        }
        try {
            sourceStore.copy(destinationStore, 2, monitor);
            SyncingConsole.println((String)". Success.");
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format(Messages.CopyFilesOperation_ERR_FailedToCopy, sourceStore, destinationStore), (Throwable)e);
            SyncingConsole.println((String)". Failure.");
            success = false;
        }
        return success;
    }

    protected boolean copyFile(IFileStore sourceStore, IFileStore sourceRoot, IFileStore destinationRoot, IProgressMonitor monitor) {
        if (sourceStore == null || CloakingUtils.isFileCloaked((IFileStore)sourceStore)) {
            return false;
        }
        boolean success = true;
        IFileStore[] sourceStores = null;
        IFileStore[] targetStores = null;
        try {
            if (sourceStore.equals(sourceRoot)) {
                sourceStores = sourceRoot.childStores(0, monitor);
                targetStores = new IFileStore[sourceStores.length];
                int i = 0;
                while (i < targetStores.length) {
                    targetStores[i] = destinationRoot.getChild(sourceStores[i].getName());
                    ++i;
                }
            } else if (sourceRoot.isParentOf(sourceStore)) {
                sourceStores = new IFileStore[]{sourceStore};
                targetStores = new IFileStore[1];
                String sourceRootPath = sourceRoot.toString();
                String sourcePath = sourceStore.toString();
                int index = sourcePath.indexOf(sourceRootPath);
                if (index > -1) {
                    String relativePath = sourcePath.substring(index + sourceRootPath.length());
                    targetStores[0] = destinationRoot.getFileStore((IPath)new Path(relativePath));
                    IFileStore parent = CopyFilesOperation.getFolderStore((IAdaptable)targetStores[0]);
                    if (parent != targetStores[0]) {
                        parent.mkdir(0, monitor);
                    }
                }
            }
            if (sourceStores == null) {
                success = false;
                sourceStores = new IFileStore[]{};
                targetStores = new IFileStore[]{};
            }
            int i = 0;
            while (i < sourceStores.length) {
                success = this.copyFile(sourceStores[i], targetStores[i], monitor) && success;
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format(Messages.CopyFilesOperation_ERR_FailedToCopyToDest, sourceStore, destinationRoot), (Throwable)e);
            success = false;
        }
        return success;
    }

    private void copyFiles(final IFileStore[] sources, final IFileStore destination, IJobChangeListener listener) {
        Job job = new Job(Messages.CopyFilesOperation_CopyJob_Title){

            protected IStatus run(IProgressMonitor monitor) {
                return CopyFilesOperation.this.copyFiles(sources, destination, monitor);
            }

            public boolean belongsTo(Object family) {
                if (Messages.CopyFilesOperation_CopyJob_Title.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.setUser(true);
        job.schedule();
    }

    private IFileStore getNewNameFor(final IFileStore originalFile) {
        final IFileStore parent = originalFile.getParent();
        final String[] returnValue = new String[]{""};
        this.fShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String string) {
                        if (originalFile.getName().equals(string)) {
                            return Messages.CopyFilesOperation_ERR_NameConflict;
                        }
                        int type = Utils.getFileInfo((IAdaptable)originalFile).isDirectory() ? 2 : 1;
                        IStatus status = ResourcesPlugin.getWorkspace().validateName(string, type);
                        if (!status.isOK()) {
                            return status.getMessage();
                        }
                        if (Utils.getFileInfo((IAdaptable)parent.getChild(string)).exists()) {
                            return Messages.CopyFilesOperation_ERR_NameExists;
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(CopyFilesOperation.this.fShell, Messages.CopyFilesOperation_NameConflictDialog_Title, MessageFormat.format(Messages.CopyFilesOperation_NameConflictDialog_Message, originalFile.getName()), CopyFilesOperation.getAutoNewNameFor(originalFile), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            return null;
        }
        return parent.getChild(returnValue[0]);
    }

    private static String getAutoNewNameFor(IFileStore originalFile) {
        String name = originalFile.getName();
        IFileStore parent = originalFile.getParent();
        int counter = 1;
        String newName;
        while (Utils.getFileInfo((IAdaptable)parent.getChild(newName = counter > 1 ? MessageFormat.format(Messages.CopyFilesOperation_DefaultNewName_WithCount, counter, name) : MessageFormat.format(Messages.CopyFilesOperation_DefaultNewName, name))).exists()) {
            ++counter;
        }
        return newName;
    }

    private static String validateDestination(IAdaptable destination, IFileStore[] sourceStores) {
        IFileStore destinationStore = CopyFilesOperation.getFolderStore(destination);
        IFileStore[] iFileStoreArray = sourceStores;
        int n = sourceStores.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore sourceStore = iFileStoreArray[n2];
            IFileStore sourceParentStore = sourceStore.getParent();
            if (destinationStore.equals(sourceStore) || sourceParentStore != null && destinationStore.equals(sourceParentStore)) {
                return Messages.CopyFilesOperation_ERR_SourceInDestination;
            }
            if (sourceStore.isParentOf(destinationStore)) {
                return Messages.CopyFilesOperation_ERR_DestinationInSource;
            }
            ++n2;
        }
        return null;
    }

    private static IFileStore getFileStore(String filename) {
        try {
            return EFS.getStore((URI)new Path(filename).toFile().toURI());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IFileStore[] getFileStores(String[] filenames) {
        IFileStore[] fileStores = new IFileStore[filenames.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = CopyFilesOperation.getFileStore(filenames[i]);
            ++i;
        }
        return fileStores;
    }

    private static IFileStore getFolderStore(IAdaptable adaptable) {
        IFileStore store = Utils.getFileStore(adaptable);
        IFileInfo info = Utils.getFileInfo(adaptable);
        if (store != null && info != null && !info.isDirectory()) {
            store = store.getParent();
        }
        return store;
    }
}

