/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io;

import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.ui.io.navigator.internal.NavigatorDecoratorLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IOUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ide.ui.io";
    private static IOUIPlugin plugin;
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            if (event.getType() == 1 && (delta = event.getDelta()) != null) {
                ArrayList<IResource> list = new ArrayList<IResource>();
                this.getResourcesNeededToRefresh(list, delta);
                for (IResource resource : list) {
                    IOUIPlugin.refreshNavigatorView(resource);
                }
            }
        }

        private void getResourcesNeededToRefresh(List<IResource> list, IResourceDelta delta) {
            IResourceDelta[] children;
            IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                int kind = child.getKind();
                if (kind == 1 || kind == 2) {
                    list.add((IResource)child.getResource().getParent());
                } else if (kind == 4) {
                    this.getResourcesNeededToRefresh(list, child);
                }
                ++n2;
            }
        }
    };
    private IConnectionPointListener connectionListener = new IConnectionPointListener(){

        public void connectionPointChanged(ConnectionPointEvent event) {
            IConnectionPoint connection = event.getConnectionPoint();
            IConnectionPointManager manager = CoreIOPlugin.getConnectionPointManager();
            ConnectionPointType type = manager.getType(connection);
            if (type == null) {
                return;
            }
            switch (event.getKind()) {
                case 1: {
                    IOUIPlugin.refreshNavigatorViewAndSelect(manager.getConnectionPointCategory(type.getCategory().getId()), connection);
                    break;
                }
                case 2: {
                    IOUIPlugin.refreshNavigatorView(manager.getConnectionPointCategory(type.getCategory().getId()));
                    break;
                }
                case 4: {
                    IOUIPlugin.refreshNavigatorView(connection);
                }
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(this.connectionListener);
        NavigatorDecoratorLoader.init();
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        CoreIOPlugin.getConnectionPointManager().removeConnectionPointListener(this.connectionListener);
        plugin = null;
        super.stop(context);
    }

    public static IOUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return IOUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = IOUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = IOUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static void refreshNavigatorView(Object element) {
        IOUIPlugin.refreshNavigatorViewAndSelect(element, null);
    }

    public static void refreshNavigatorViewAndSelect(final Object element, final Object selection) {
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IViewPart view = CoreUIUtils.findView((String)"com.aptana.ide.ui.io.fileExplorerView");
                    if (view != null && view instanceof CommonNavigator) {
                        CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                        if (element == null) {
                            viewer.refresh();
                        } else {
                            viewer.refresh(element);
                        }
                        if (selection != null) {
                            viewer.expandToLevel(element, 1);
                            viewer.setSelection((ISelection)new StructuredSelection(selection));
                        }
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    public static void log(String msg, Throwable e) {
        IOUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, 0, msg, e));
    }

    private static void log(IStatus status) {
        IOUIPlugin.getDefault().getLog().log(status);
    }
}

