/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.preferences;

import com.aptana.ide.ui.editors.preferences.formatter.CompilationUnitPreview;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialog;
import com.aptana.ide.ui.editors.preferences.formatter.ModifyDialogTabPage;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentationTabPage
extends FormatterTabPage {
    private static final String PREVIEW = "H1 {\r\ncolor: white; background: teal; FONT-FAMILY: arial, helvetica, lucida-sans, sans-serif; FONT-SIZE: 18pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n}\r\nH2 {\r\nCOLOR: #000000; FONT-FAMILY: verdana, helvetica, lucida-sans, sans-serif; FONT-SIZE: 14pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n}\r\nH3 {\r\nCOLOR: #000000; FONT-FAMILY: lucida-sans, sans-serif; FONT-SIZE: 14pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n}\r\nH4 {\r\nCOLOR: #000000; FONT-FAMILY: lucida-sans, sans-serif; FONT-SIZE: 12pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n}\r\nH5 {\r\ncolor: white; background: darkblue; FONT-FAMILY: lucida-sans, sans-serif; FONT-SIZE: 12pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n}\r\nH6 {\r\ncolor: yellow; background: green; FONT-FAMILY: lucida-sans, sans-serif; FONT-SIZE: 10pt; FONT-STYLE: normal; FONT-VARIANT: normal\r\n} \r\n\r\nbody {\r\nCOLOR: #000000; FONT-FAMILY: lucida-sans, sans-serif; FONT-SIZE: 10pt; FONT-STYLE: normal; FONT-VARIANT: normal; background-image: url('bkgnd.gif') \r\n}\r\n";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;
    private String editor;

    public IndentationTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues, String editor) {
        super((ModifyDialogTabPage.IModificationListener)modifyDialog, workingValues);
        this.editor = editor;
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{" ", "\t"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB};
        this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "com.aptana.ide.editors.codeassist.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "com.aptana.ide.editors.codeassist.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        if (tabchar == null) {
            tabchar = " ";
        }
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
    }

    public void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected Preview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent, this.editor, null);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if (" ".equals(this.fOldTabChar) || "\t".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if (" ".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("\t".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        String tabSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        String indentSize = (String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.indentation.size");
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("com.aptana.ide.editors.codeassist.formatter.indentation.size", tabSize);
    }
}

