/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.formatting;

import com.aptana.ide.editor.css.formatting.CSSCodeFormatterOptions;
import com.aptana.ide.editor.css.parsing.CSSParseState;
import com.aptana.ide.editors.unified.BaseFormatter;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.text.ParseException;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public class CSSCodeFormatter
extends BaseFormatter {
    public String format(String notFormatted, boolean isSelection, Map options, IProject project, String lineDelimeters) {
        CSSCodeFormatterOptions codeoptions = new CSSCodeFormatterOptions(options, project);
        if (!codeoptions.doFormatting) {
            return notFormatted;
        }
        return this.doLexerBasedFormat(notFormatted, codeoptions, lineDelimeters);
    }

    private String doLexerBasedFormat(String notFormatted, CSSCodeFormatterOptions codeoptions, String lineDelimeters) {
        IParser parser = LanguageRegistry.getParser((String)"text/css");
        CSSParseState parseState = (CSSParseState)parser.createParseState(null);
        parseState.setEditState(notFormatted, notFormatted, 0, 0);
        try {
            parser.parse((IParseState)parseState);
            LexemeList ll = parseState.getLexemeList();
            String indent = codeoptions.formatterTabChar;
            if (indent.length() == 0) {
                indent = " ";
            }
            if (indent.charAt(0) == ' ') {
                StringBuffer bf = new StringBuffer();
                int a = 0;
                while (a < codeoptions.tabSize) {
                    bf.append(' ');
                    ++a;
                }
                indent = bf.toString();
            }
            SourceWriter writer = new SourceWriter(0, indent, codeoptions.tabSize);
            if (lineDelimeters != null) {
                writer.setLineDelimeter(lineDelimeters);
            }
            String formatted = this.format(notFormatted, writer, ll, codeoptions);
            String start = this.getStartLineBreaks(writer, notFormatted, formatted);
            String end = this.getEndLineBreaks(writer, notFormatted, formatted);
            formatted = String.valueOf(start) + formatted + end;
            if (!this.isFormattingCorrect(ll, parser, notFormatted, formatted, new int[]{3}, null)) {
                formatted = notFormatted;
            }
            return formatted;
        }
        catch (LexerException lexerException) {
            return null;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private boolean isOnSameLine(String source, LexemeList list, int first, int second) {
        if (first < 0) {
            return true;
        }
        if (second >= list.size()) {
            return true;
        }
        int endingOffset = list.get(first).getEndingOffset();
        int startingOffset = list.get(second).getStartingOffset();
        int a = endingOffset;
        while (a < startingOffset) {
            char c = source.charAt(a);
            if (c == '\r' || c == '\n') {
                return false;
            }
            ++a;
        }
        return true;
    }

    private boolean hasSpaceBetween(String source, LexemeList list, int first, int second) {
        int endingOffset = 0;
        int startingOffset = 0;
        if (first >= 0) {
            endingOffset = list.get(first).getEndingOffset();
        }
        if (second < list.size()) {
            startingOffset = list.get(second).getStartingOffset();
        }
        int a = endingOffset;
        while (a < startingOffset) {
            char c = source.charAt(a);
            if (Character.isWhitespace(c) && c != '\r' && c != '\n') {
                return true;
            }
            ++a;
        }
        return false;
    }

    private String format(String source, SourceWriter writer, LexemeList ll, CSSCodeFormatterOptions codeoptions) {
        Lexeme previousLexeme = null;
        boolean isInProperty = false;
        boolean newLine = false;
        boolean hasSpace = false;
        boolean sameLine = true;
        boolean lastError = true;
        int i = 0;
        while (i < ll.size()) {
            Lexeme lex = ll.get(i);
            if (lex.getCategoryIndex() == 0) {
                boolean bsLine;
                sameLine = this.isOnSameLine(source, ll, i - 1, i);
                if (!sameLine && writer.getCurrentIndentLevel() != 0) {
                    writer.println();
                    writer.printIndent();
                }
                if (sameLine && (hasSpace = this.hasSpaceBetween(source, ll, i - 1, i))) {
                    writer.print(' ');
                }
                sameLine = bsLine = this.isOnSameLine(source, ll, i, i + 1);
                hasSpace = this.hasSpaceBetween(source, ll, i, i + 1);
                if (i < ll.size() - 1) {
                    Lexeme nextLexeme = ll.get(i + 1);
                    bsLine |= this.isLexemeOfType(nextLexeme, 32);
                    bsLine |= this.isLexemeOfType(nextLexeme, 31);
                }
                if (!bsLine) {
                    writer.println(lex.getText());
                } else {
                    writer.print(lex.getText());
                }
                lastError = true;
                int start = lex.getEndingOffset();
                writer.print(source.substring(start));
                return writer.toString();
            }
            if (lastError) {
                lastError = false;
            } else {
                hasSpace = false;
                sameLine = false;
            }
            switch (lex.typeIndex) {
                case 31: {
                    if (codeoptions.formatterBracePositionForBlock == 1) {
                        writer.println();
                        writer.printIndent();
                    } else if (codeoptions.formatterBracePositionForBlock == 2) {
                        writer.println();
                        writer.increaseIndent();
                        writer.printIndent();
                    } else {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                    writer.increaseIndent();
                    newLine = true;
                    break;
                }
                case 3: {
                    boolean addedLine = false;
                    if (previousLexeme != null) {
                        boolean split;
                        if (this.isLexemeOfType(previousLexeme, 32)) {
                            writer.println();
                        }
                        if (split = this.splitByNewline(source, previousLexeme, lex)) {
                            writer.println();
                            writer.printIndent();
                            addedLine = true;
                        }
                    }
                    if (previousLexeme != null && !addedLine) {
                        writer.print(" ");
                        this.printComment(writer, lex.getText());
                        break;
                    }
                    this.printComment(writer, lex.getText());
                    break;
                }
                case 32: {
                    writer.println();
                    if (codeoptions.formatterBracePositionForBlock == 2) {
                        writer.decreaseIndent();
                    }
                    if (codeoptions.formatterBracePositionForBlock == 2) {
                        writer.printIndent();
                    }
                    writer.print(lex.getText());
                    writer.decreaseIndent();
                    newLine = true;
                    break;
                }
                case 30: {
                    writer.print(lex.getText());
                    newLine = true;
                    isInProperty = false;
                    break;
                }
                case 48: {
                    boolean isCommaBefore = this.isLexemeOfType(previousLexeme, 38);
                    boolean isCommentBefore = this.isLexemeOfType(previousLexeme, 3);
                    if (previousLexeme != null && !isCommaBefore && !isCommentBefore) {
                        if (!sameLine && this.isLexemeOfType(previousLexeme, 32)) {
                            writer.println();
                            writer.println();
                        } else if (this.isLexemeOfType(previousLexeme, 30)) {
                            lex.typeIndex = 47;
                            writer.println();
                            writer.printIndent();
                        }
                    }
                    if (isCommentBefore) {
                        writer.println();
                    } else if (isCommaBefore && !codeoptions.newlinesBetweenSelectors) {
                        writer.print(" ");
                    }
                    if (hasSpace) {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                    sameLine = false;
                    hasSpace = false;
                    break;
                }
                case 38: {
                    writer.print(lex.getText());
                    if (!codeoptions.newlinesBetweenSelectors || !this.isLexemeOfType(previousLexeme, 8) && !this.isLexemeOfType(previousLexeme, 48) && !this.isLexemeOfType(previousLexeme, 4) && !this.isLexemeOfType(previousLexeme, 9)) break;
                    writer.println();
                    break;
                }
                case 34: 
                case 35: {
                    writer.print(lex.getText());
                    break;
                }
                case 8: 
                case 9: {
                    boolean isCommaBefore = this.isLexemeOfType(previousLexeme, 38);
                    boolean isCommentBefore = this.isLexemeOfType(previousLexeme, 3);
                    if (this.lexemeIsEndOfBlock(previousLexeme)) {
                        writer.println();
                        writer.println();
                        writer.print(lex.getText());
                        break;
                    }
                    if (isCommentBefore) {
                        writer.println();
                    } else if ((isCommaBefore || previousLexeme != null && lex != null && previousLexeme.getEndingOffset() < lex.getStartingOffset()) && !codeoptions.newlinesBetweenSelectors) {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                    break;
                }
                case 39: 
                case 41: 
                case 43: 
                case 45: {
                    if (lex.typeIndex == 41 && (previousLexeme == null || this.lexemeIsEndOfBlock(previousLexeme))) {
                        if (newLine) {
                            writer.println();
                            writer.printIndent();
                            newLine = false;
                        }
                        writer.print(lex.getText());
                        break;
                    }
                    writer.print(" " + lex.getText());
                    break;
                }
                case 29: {
                    isInProperty = this.isLexemeOfType(previousLexeme, 47);
                    if (!isInProperty && this.hasSpaceBetween(source, ll, i - 1, i)) {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                    break;
                }
                case 4: {
                    if ((this.isLexemeOfType(previousLexeme, 29) || this.isLexemeOfType(previousLexeme, 34)) && !isInProperty || this.isLexemeOfType(previousLexeme, 10)) {
                        writer.print(lex.getText());
                        break;
                    }
                    if (!codeoptions.newlinesBetweenSelectors || !this.isLexemeOfType(previousLexeme, 38)) {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                    break;
                }
                case 21: {
                    if (newLine) {
                        writer.println();
                        newLine = false;
                    }
                    writer.printWithIndent(lex.getText());
                    break;
                }
                case 33: {
                    writer.print(lex.getText());
                    break;
                }
                default: {
                    if (newLine) {
                        writer.println();
                        writer.printIndent();
                        newLine = false;
                    } else if (previousLexeme != null && previousLexeme.typeIndex != 10) {
                        writer.print(" ");
                    }
                    writer.print(lex.getText());
                }
            }
            previousLexeme = lex;
            ++i;
        }
        return writer.toString();
    }

    private boolean lexemeIsEndOfBlock(Lexeme previousLexeme) {
        return this.isLexemeOfType(previousLexeme, 32) || this.isLexemeOfType(previousLexeme, 30);
    }

    private void printComment(SourceWriter writer, String text) {
        String[] split = text.split("\r\n|\r|\n");
        if (split.length == 1) {
            writer.print(split[0]);
        } else {
            writer.println(split[0].trim());
            int i = 1;
            while (i < split.length - 1) {
                String string = split[i];
                writer.printlnWithIndent(" " + string.trim());
                ++i;
            }
            writer.printWithIndent(" " + split[split.length - 1].trim());
        }
    }

    private boolean splitByNewline(String source, Lexeme previousLexeme, Lexeme lex) {
        String sourceText = source.substring(previousLexeme.getEndingOffset(), lex.getStartingOffset());
        return sourceText.indexOf("\r") >= 0 || sourceText.indexOf("\n") >= 0;
    }

    public String createNestedMark() {
        return "";
    }

    public boolean handlesNested() {
        return true;
    }
}

