/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.contentassist;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.ide.editor.css.contentassist.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class CSSContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private static final String BLACK_COLOR = "black";
    private static final String COLON = ":";
    private CSSContentAssistProcessor fProcessor;
    private IContextInformation fContextInformation;

    public CSSContextInformationValidator(CSSContentAssistProcessor processor) {
        this.fProcessor = processor;
    }

    public void install(IContextInformation contextInformation, ITextViewer viewer, int offset) {
        this.fContextInformation = contextInformation;
    }

    public boolean isContextInformationValid(int offset) {
        if (this.fProcessor.initalPopup) {
            this.fProcessor.initalPopup = false;
            return true;
        }
        return this.fProcessor.getCSSOffsetMapper().getMode(offset).equalsIgnoreCase("MODE_INVOKING");
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        String s;
        block3: {
            try {
                s = this.fContextInformation.getInformationDisplayString();
                if (s.indexOf(COLON) != -1) break block3;
                return false;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.CSSContextInformationValidator_ErrorUpdatingContextInformation, (Throwable)e);
                return true;
            }
        }
        int colonPos = s.indexOf(COLON);
        RGB blackColor = new RGB(0, 0, 0);
        ColorRegistry cm = JFaceResources.getColorRegistry();
        cm.put(BLACK_COLOR, blackColor);
        Color norm = cm.get(BLACK_COLOR);
        StyleRange st = new StyleRange(0, colonPos, norm, null, 1);
        presentation.clear();
        presentation.addStyleRange(st);
        return true;
    }
}

