/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.InstanceCreator;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.FilterActionInfo;
import com.aptana.ide.views.outline.IOutlineContentProviderExtension;
import com.aptana.ide.views.outline.IPathResolver;
import com.aptana.ide.views.outline.IUnifiedOutlinePage;
import com.aptana.ide.views.outline.OutlineItem;
import com.aptana.ide.views.outline.OutlineRefreshHandler;
import com.aptana.ide.views.outline.PathResolverProvider;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.osgi.framework.Bundle;

public final class UnifiedOutlineProvider
implements ITreeContentProvider,
ILabelProvider,
IColorProvider,
IFontProvider,
ILabelDecorator {
    private static final FilterActionInfo[] NO_FILTERS = new FilterActionInfo[0];
    private static UnifiedOutlineProvider instance;
    private static final Object[] NO_OBJECTS;
    private static final String EMPTY_STRING = "";
    private static final String OUTLINE_ID = "outline";
    private static final String TAG_CONTRIBUTOR = "contributor";
    private static final String TAG_CONTRIBUTOR_EXTENSION = "contributor-extension";
    private static final String TAG_FILTER = "filter";
    private static final String ATTR_BEFORE_REFRESH_HANDLER = "before-refresh-handler";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_COLOR_PROVIDER = "color-provider";
    private static final String ATTR_CONTENT_PROVIDER = "content-provider";
    private static final String ATTR_FONT_PROVIDER = "font-provider";
    private static final String ATTR_LABEL_PROVIDER = "label-provider";
    private static final String ATTR_LABEL_DECORATOR = "label-decorator";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_LANGUAGES = "languages";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_IS_SORTABLE = "is-sortable";
    private static final String ATTR_TOOL_TIP = "tool-tip";
    private IUnifiedOutlinePage _outlinePage;
    private Map<String, String> _privateMemberPrefixes;
    private Map<String, Providers> _providersByLanguage;
    private Providers _currentProviders;
    private String _currentLanguage;
    private IPathResolver _resolver;
    private WeakReference<Object> _oldEditorInput = new WeakReference<Object>(null);

    static {
        NO_OBJECTS = new Object[0];
    }

    public static UnifiedOutlineProvider getInstance() {
        if (instance == null) {
            instance = new UnifiedOutlineProvider();
            instance.loadExtensions();
        }
        return instance;
    }

    public UnifiedOutlineProvider() {
        this._providersByLanguage = new HashMap<String, Providers>();
    }

    public void addBeforeRefreshHandler(String language, OutlineRefreshHandler handler) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.addBeforeRefreshHandler(handler);
        }
    }

    public void addFilter(String language, String name, String toolTip, InstanceCreator filterCreator, ImageDescriptor imageDescriptor) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.addFilter(name, toolTip, filterCreator, imageDescriptor);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        ILabelProvider labelProvider;
        if (this._currentProviders != null && (labelProvider = this._currentProviders.labelProvider) != null) {
            labelProvider.addListener(listener);
        }
    }

    public Image decorateImage(Image image, Object element) {
        ILabelDecorator labelDecorator;
        Image result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (labelDecorator = this._currentProviders.labelDecorator) != null) {
            result = labelDecorator.decorateImage(image, element);
        }
        return result;
    }

    public String decorateText(String text, Object element) {
        ILabelDecorator labelDecorator;
        String result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (labelDecorator = this._currentProviders.labelDecorator) != null) {
            result = labelDecorator.decorateText(text, element);
        }
        return result;
    }

    public void dispose() {
        Set<Map.Entry<String, Providers>> entries = this._providersByLanguage.entrySet();
        for (Map.Entry<String, Providers> entry : entries) {
            Providers providers = entry.getValue();
            ILabelProvider labelProvider = providers.labelProvider;
            if (labelProvider == null) continue;
            labelProvider.dispose();
        }
    }

    public void fireBeforeRefreshEvent(EditorFileContext fileContext) {
        if (this._currentProviders != null) {
            this._currentProviders.fireBeforeRefreshEvent(fileContext);
        }
    }

    public Color getBackground(Object element) {
        IColorProvider colorProvider;
        Color result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (colorProvider = this._currentProviders.colorProvider) != null) {
            result = colorProvider.getBackground(element);
        }
        return result;
    }

    public Object[] getChildren(IParseNode parentNode, String language) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < parentNode.getChildCount()) {
            IParseNode child = parentNode.getChild(i);
            String childLanguage = child.getLanguage();
            if (childLanguage.equals(language)) {
                result.add(child);
            } else {
                UnifiedOutlineProvider outlineProvider = UnifiedOutlineProvider.getInstance();
                outlineProvider.setCurrentLanguage(childLanguage);
                Object[] elements = outlineProvider.getElements(child);
                if (elements != null) {
                    int j = 0;
                    while (j < elements.length) {
                        result.add(elements[j]);
                        ++j;
                    }
                }
                outlineProvider.setCurrentLanguage(language);
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        ITreeContentProvider contentProvider;
        Object[] result = NO_OBJECTS;
        this.switchLanguage(parentElement);
        if (this._currentProviders != null && (contentProvider = this._currentProviders.contentProvider) != null) {
            result = contentProvider.getChildren(parentElement);
        }
        return result;
    }

    public String getCurrentLanguage() {
        return this._currentLanguage;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = NO_OBJECTS;
        if (inputElement instanceof UnifiedEditor) {
            ITreeContentProvider contentProvider;
            UnifiedEditor editor = (UnifiedEditor)inputElement;
            EditorFileContext fileContext = editor.getFileContext();
            IParseState parseState = fileContext.getParseState();
            if (parseState == null) {
                return NO_OBJECTS;
            }
            IParseNode node = parseState.getParseResults();
            String defaultLanguage = fileContext.getDefaultLanguage();
            this.setCurrentLanguage(defaultLanguage);
            if (this._currentProviders != null && (contentProvider = this._currentProviders.contentProvider) != null) {
                if (contentProvider instanceof IOutlineContentProviderExtension) {
                    IOutlineContentProviderExtension resolver = (IOutlineContentProviderExtension)contentProvider;
                    resolver.setPathResolver(this._resolver);
                }
                result = this._currentProviders.contentProvider.getElements((Object)node);
            }
        } else if (this._currentProviders != null) {
            this.switchLanguage(inputElement);
            ITreeContentProvider contentProvider = this._currentProviders.contentProvider;
            if (contentProvider != null) {
                if (contentProvider instanceof IOutlineContentProviderExtension) {
                    IOutlineContentProviderExtension resolver = (IOutlineContentProviderExtension)contentProvider;
                    resolver.setPathResolver(this._resolver);
                }
                result = contentProvider.getElements(inputElement);
            }
        }
        return result;
    }

    public FilterActionInfo[] getFilterActionInfos(String language) {
        FilterActionInfo[] result = NO_FILTERS;
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            result = providers.getFilters();
        }
        return result;
    }

    public Font getFont(Object element) {
        IFontProvider fontProvider;
        Font result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (fontProvider = this._currentProviders.fontProvider) != null) {
            result = fontProvider.getFont(element);
        }
        return result;
    }

    public Color getForeground(Object element) {
        IColorProvider colorProvider;
        Color result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (colorProvider = this._currentProviders.colorProvider) != null) {
            result = colorProvider.getForeground(element);
        }
        return result;
    }

    public Image getImage(Object element) {
        Image result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null) {
            Image decorated;
            ILabelProvider labelProvider = this._currentProviders.labelProvider;
            if (labelProvider != null) {
                result = labelProvider.getImage(element);
            }
            if ((decorated = this.decorateImage(result, element)) != null) {
                result = decorated;
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        ITreeContentProvider contentProvider;
        Object result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (contentProvider = this._currentProviders.contentProvider) != null) {
            result = contentProvider.getParent(element);
        }
        return result;
    }

    public String getPrivateMemberPrefix(String language) {
        String result = null;
        if (this._privateMemberPrefixes != null && this._privateMemberPrefixes.containsKey(language)) {
            result = this._privateMemberPrefixes.get(language);
        }
        return result;
    }

    public String getText(Object element) {
        ILabelProvider labelProvider;
        String result = null;
        this.switchLanguage(element);
        if (this._currentProviders != null && (labelProvider = this._currentProviders.labelProvider) != null) {
            result = labelProvider.getText(element);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider;
        boolean result = false;
        this.switchLanguage(element);
        if (this._currentProviders != null && (contentProvider = this._currentProviders.contentProvider) != null) {
            result = contentProvider.hasChildren(element);
        }
        return result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ITreeContentProvider contentProvider;
        if (this._currentProviders != null && (contentProvider = this._currentProviders.contentProvider) != null) {
            contentProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        ILabelProvider labelProvider;
        boolean result = false;
        this.switchLanguage(element);
        if (this._currentProviders != null && (labelProvider = this._currentProviders.labelProvider) != null) {
            result = labelProvider.isLabelProperty(element, property);
        }
        return result;
    }

    public boolean isSortable(String language) {
        boolean result = false;
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            result = providers.isSortable;
        }
        return result;
    }

    private void loadContributorExtensions(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_CONTRIBUTOR_EXTENSION)) {
                try {
                    String language = element.getAttribute(ATTR_LANGUAGE);
                    String colorProviderName = element.getAttribute(ATTR_COLOR_PROVIDER);
                    String fontProviderName = element.getAttribute(ATTR_FONT_PROVIDER);
                    String labelDecoratorName = element.getAttribute(ATTR_LABEL_DECORATOR);
                    String beforeRefreshHandler = element.getAttribute(ATTR_BEFORE_REFRESH_HANDLER);
                    if (colorProviderName != null) {
                        this.setColorProvider(language, (IColorProvider)element.createExecutableExtension(ATTR_COLOR_PROVIDER));
                    }
                    if (fontProviderName != null) {
                        this.setFontProvider(language, (IFontProvider)element.createExecutableExtension(ATTR_FONT_PROVIDER));
                    }
                    if (labelDecoratorName != null) {
                        this.setLabelDecorator(language, (ILabelDecorator)element.createExecutableExtension(ATTR_LABEL_DECORATOR));
                    }
                    if (beforeRefreshHandler != null) {
                        this.addBeforeRefreshHandler(language, (OutlineRefreshHandler)element.createExecutableExtension(ATTR_BEFORE_REFRESH_HANDLER));
                    }
                }
                catch (CoreException coreException) {
                    IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Unable to create outline extensions");
                }
            }
            ++i;
        }
    }

    private void loadContributors(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_CONTRIBUTOR)) {
                try {
                    String language = element.getAttribute(ATTR_LANGUAGE);
                    ILabelProvider labelProvider = (ILabelProvider)element.createExecutableExtension(ATTR_LABEL_PROVIDER);
                    ITreeContentProvider contentProvider = (ITreeContentProvider)element.createExecutableExtension(ATTR_CONTENT_PROVIDER);
                    String sortableValue = element.getAttribute(ATTR_IS_SORTABLE);
                    boolean sortable = sortableValue == null ? false : sortableValue.equals("true");
                    this.setProviders(language, labelProvider, contentProvider, sortable);
                }
                catch (CoreException coreException) {
                    IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Unable to create outline providers");
                }
            }
            ++i;
        }
    }

    public void loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IExtensionPoint extensionPoint = registry.getExtensionPoint("com.aptana.ide.editors", OUTLINE_ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                this.loadContributors(elements);
                this.loadContributorExtensions(elements);
                this.loadFilters(elements);
                ++i;
            }
        }
    }

    private void loadFilters(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_FILTER)) {
                String resourceName;
                String languages = element.getAttribute(ATTR_LANGUAGES);
                String name = element.getAttribute(ATTR_NAME);
                String toolTip = element.getAttribute(ATTR_TOOL_TIP);
                InstanceCreator filterCreator = new InstanceCreator(element, ATTR_CLASS);
                IExtension ext = element.getDeclaringExtension();
                String pluginId = ext.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                URL resource = bundle.getResource(resourceName = element.getAttribute(ATTR_ICON));
                if (resource == null) {
                    resource = bundle.getEntry(ATTR_ICON);
                }
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)resource);
                String[] stringArray = languages.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String language = stringArray[n2];
                    this.addFilter(language, name, toolTip, filterCreator, imageDescriptor);
                    ++n2;
                }
            }
            ++i;
        }
    }

    void pageActivated(IUnifiedOutlinePage unifiedOutlinePage) {
        this.setOutlinePage(unifiedOutlinePage);
        for (Providers name : this._providersByLanguage.values()) {
            ITreeContentProvider contentProvider = name.contentProvider;
            if (!(contentProvider instanceof IOutlineContentProviderExtension)) continue;
            IOutlineContentProviderExtension resolver = (IOutlineContentProviderExtension)contentProvider;
            resolver.pageActivated(this._resolver);
            TreeViewer treeViewer = unifiedOutlinePage.getTreeViewer();
            if (treeViewer == null || treeViewer.getTree() == null || treeViewer.getTree().isDisposed()) continue;
            treeViewer.refresh();
        }
    }

    void pageClosed(IUnifiedOutlinePage unifiedOutlinePage) {
        for (Providers name : this._providersByLanguage.values()) {
            ITreeContentProvider contentProvider = name.contentProvider;
            if (!(contentProvider instanceof IOutlineContentProviderExtension)) continue;
            IOutlineContentProviderExtension resolver = (IOutlineContentProviderExtension)contentProvider;
            resolver.pageClosed(this._resolver);
            TreeViewer treeViewer = unifiedOutlinePage.getTreeViewer();
            if (treeViewer == null || treeViewer.getTree().isDisposed()) continue;
            treeViewer.refresh();
        }
    }

    public void refresh() {
        if (this._outlinePage != null) {
            this._outlinePage.refresh();
        }
    }

    public void removeBeforeRefreshHandler(String language, OutlineRefreshHandler handler) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.removeBeforeRefreshHandler(handler);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        ILabelProvider labelProvider;
        if (this._currentProviders != null && (labelProvider = this._currentProviders.labelProvider) != null) {
            labelProvider.removeListener(listener);
        }
    }

    public void removeProviders(String language) {
        if (this._providersByLanguage.containsKey(language)) {
            this._providersByLanguage.remove(language);
        }
    }

    public void setColorProvider(String language, IColorProvider colorProvider) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.colorProvider = colorProvider;
        }
    }

    public void setCurrentLanguage(String language) {
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException("language must be defined");
        }
        if (!language.equals(this._currentLanguage) && this._providersByLanguage.containsKey(language)) {
            this._currentProviders = this._providersByLanguage.get(language);
            this._currentLanguage = language;
        }
    }

    public void setFontProvider(String language, IFontProvider fontProvider) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.fontProvider = fontProvider;
        }
    }

    public void setLabelDecorator(String language, ILabelDecorator labelDecorator) {
        if (this._providersByLanguage.containsKey(language)) {
            Providers providers = this._providersByLanguage.get(language);
            providers.labelDecorator = labelDecorator;
        }
    }

    public void setOutlinePage(IUnifiedOutlinePage page) {
        Object object;
        this._outlinePage = page;
        UnifiedEditor editor = page.getUnifiedEditor();
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput.equals(object = this._oldEditorInput.get())) {
            return;
        }
        this._oldEditorInput = new WeakReference<IEditorInput>(editorInput);
        this._resolver = PathResolverProvider.getResolver(editorInput);
    }

    public void setPrivateMemberPrefix(String language, String prefix) {
        if (this._privateMemberPrefixes == null) {
            this._privateMemberPrefixes = new HashMap<String, String>();
        }
        this._privateMemberPrefixes.put(language, prefix);
    }

    public void setProviders(String language, ILabelProvider labelProvider, ITreeContentProvider contentProvider, boolean isSortable) {
        if (language != null && language.length() > 0) {
            this._providersByLanguage.put(language, new Providers(contentProvider, labelProvider, isSortable));
        }
    }

    private boolean switchLanguage(Object parentElement) {
        String oldLanguage = this.getCurrentLanguage();
        if (oldLanguage == null) {
            oldLanguage = EMPTY_STRING;
        }
        if (parentElement instanceof IParseNode) {
            IParseNode parseNode = (IParseNode)parentElement;
            this.setCurrentLanguage(parseNode.getLanguage());
        } else if (parentElement instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)parentElement;
            this.setCurrentLanguage(item.getLanguage());
        }
        return !oldLanguage.equals(this.getCurrentLanguage());
    }

    private class Providers {
        public ITreeContentProvider contentProvider;
        public ILabelProvider labelProvider;
        public IColorProvider colorProvider;
        public IFontProvider fontProvider;
        public ILabelDecorator labelDecorator;
        private List<FilterActionInfo> _filters;
        private List<OutlineRefreshHandler> _beforeRefreshHandlers;
        public boolean isSortable;

        public Providers(ITreeContentProvider contentProvider, ILabelProvider labelProvider, boolean isSortable) {
            this.contentProvider = contentProvider;
            this.labelProvider = labelProvider;
            this.isSortable = isSortable;
            if (labelProvider instanceof IColorProvider) {
                this.colorProvider = (IColorProvider)labelProvider;
            }
            if (labelProvider instanceof IFontProvider) {
                this.fontProvider = (IFontProvider)labelProvider;
            }
            if (labelProvider instanceof ILabelDecorator) {
                this.labelDecorator = (ILabelDecorator)labelProvider;
            }
        }

        public void addBeforeRefreshHandler(OutlineRefreshHandler handler) {
            if (this._beforeRefreshHandlers == null) {
                this._beforeRefreshHandlers = new ArrayList<OutlineRefreshHandler>();
            }
            this._beforeRefreshHandlers.add(handler);
        }

        public void addFilter(String name, String toolTip, InstanceCreator filterCreator, ImageDescriptor imageDescriptor) {
            if (this._filters == null) {
                this._filters = new ArrayList<FilterActionInfo>();
            }
            this._filters.add(new FilterActionInfo(name, toolTip, filterCreator, imageDescriptor));
        }

        public void fireBeforeRefreshEvent(EditorFileContext fileContext) {
            if (this._beforeRefreshHandlers != null) {
                for (OutlineRefreshHandler handler : this._beforeRefreshHandlers) {
                    handler.run(fileContext);
                }
            }
        }

        public FilterActionInfo[] getFilters() {
            FilterActionInfo[] result = NO_FILTERS;
            if (this._filters != null) {
                result = this._filters.toArray(new FilterActionInfo[this._filters.size()]);
            }
            return result;
        }

        public void removeBeforeRefreshHandler(OutlineRefreshHandler handler) {
            if (this._beforeRefreshHandlers != null) {
                this._beforeRefreshHandlers.remove(handler);
            }
        }
    }
}

