/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedInformationControl;
import com.aptana.ide.editors.unified.utils.HTMLTextPresenter;
import com.aptana.ide.editors.views.actions.Action;
import com.aptana.ide.editors.views.actions.ActionSet;
import com.aptana.ide.editors.views.actions.ActionsManager;
import com.aptana.ide.editors.views.actions.ActionsViewEvent;
import com.aptana.ide.editors.views.actions.IAction;
import com.aptana.ide.editors.views.actions.IActionChangeListener;
import com.aptana.ide.editors.views.actions.IActionsViewEventListener;
import com.aptana.ide.editors.views.actions.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class ActionsView
extends ViewPart {
    static final String INFO_MESSAGE = Messages.ActionsView_ActionsView;
    static final String[] FILTER_EXTENSIONS = new String[]{"*.js", "*.*"};
    static final String[] FILTER_NAMES = new String[]{StringUtils.format((String)Messages.ActionsView_JavaScriptFiles, (String)FILTER_EXTENSIONS[0]), StringUtils.format((String)Messages.ActionsView_AllFiles, (String)FILTER_EXTENSIONS[1])};
    private static ImageDescriptor fAddFileIconDescriptor = ActionsView.getImageDescriptor("icons/js_file_new.gif");
    private static Image fErrIcon = ActionsView.getImageDescriptor("icons/error.gif").createImage();
    private static Image fProfileIcon = ActionsView.getImageDescriptor("icons/profile.gif").createImage();
    private static Image fProfileDynamicIcon = ActionsView.getImageDescriptor("icons/profile-dynamic.gif").createImage();
    private static Image fProfileFileIcon = ActionsView.getImageDescriptor("icons/js_file.gif").createImage();
    private TreeViewer viewer;
    private StackLayout layout;
    private Composite viewParent;
    private Label infoLabel;
    private Font infoLabelFont;
    private org.eclipse.jface.action.Action actionNewActionSet;
    private org.eclipse.jface.action.Action actionAdd;
    private org.eclipse.jface.action.Action actionEdit;
    private org.eclipse.jface.action.Action actionReload;
    private org.eclipse.jface.action.Action actionDelete;
    private org.eclipse.jface.action.Action actionDoubleClick;
    private org.eclipse.jface.action.Action actionAddCurrentFile;
    private org.eclipse.jface.action.Action actionExecute;
    private org.eclipse.jface.action.Action actionMakeExecutable;
    private ArrayList listeners = new ArrayList();
    public ActionsManager actionsManager = UnifiedEditorsPlugin.getDefault().getActionsManager();

    public void fireActionsViewEvent(ActionsViewEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            IActionsViewEventListener listener = (IActionsViewEventListener)this.listeners.get(i);
            listener.onActionsViewEvent(e);
            ++i;
        }
    }

    public void addActionsViewEventListener(IActionsViewEventListener l) {
        this.listeners.add(l);
    }

    public void removeActionsViewEventListener(IActionsViewEventListener l) {
        this.listeners.remove(l);
    }

    public ActionsView() {
        this.actionsManager.addActionsChangeListener(new IActionChangeListener(){

            public void onActionChanged(IAction a) {
                if (!ActionsView.this.viewer.getControl().isDisposed()) {
                    Object[] expanded = ActionsView.this.viewer.getExpandedElements();
                    ActionsView.this.viewer.refresh();
                    ActionsView.this.viewer.setExpandedElements(expanded);
                }
            }
        });
    }

    public void dispose() {
        if (this.infoLabelFont != null) {
            this.infoLabelFont.dispose();
        }
        if (fErrIcon != null) {
            fErrIcon.dispose();
        }
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.aptana.ide.js.ui.ProfilesView");
        this.layout = new StackLayout();
        parent.setLayout((Layout)this.layout);
        this.viewer = this.createTreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ViewerSorterProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.expandAll();
        this.infoLabel = new Label(parent, 0x1000000);
        this.infoLabel.setBackground(parent.getDisplay().getSystemColor(1));
        this.infoLabelFont = new Font((Device)parent.getDisplay(), Messages.ActionsView_Arial, 14, 0);
        this.infoLabel.setFont(this.infoLabelFont);
        this.infoLabel.setForeground(parent.getDisplay().getSystemColor(15));
        this.infoLabel.setText(INFO_MESSAGE);
        this.layout.topControl = this.infoLabel;
        this.viewParent = parent;
        this.viewParent.layout();
        DropTarget labeldt = new DropTarget((Control)this.infoLabel, 2);
        labeldt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        labeldt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ActionsView.this.handleDrop(event);
            }
        });
        DropTarget dt = new DropTarget(this.viewer.getControl(), 2);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ActionsView.this.handleDrop(event);
            }
        });
        this.makeActions();
        this.hookKeyActions(this.viewer.getControl());
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.refresh();
    }

    protected void handleDrop(DropTargetEvent event) {
        String[] files = (String[])event.data;
        ArrayList<Path> paths = new ArrayList<Path>();
        int i = 0;
        while (i < files.length) {
            paths.add(new Path(files[i]));
            ++i;
        }
        if (paths.size() > 0) {
            IPath[] ipaths = paths.toArray(new IPath[0]);
            ActionsViewEvent e = new ActionsViewEvent(1);
            e.setPaths(ipaths);
            Widget w = event.item;
            if (w != null) {
                TreeItem item = (TreeItem)w;
                Object element = item.getData();
                ActionSet action = null;
                if (element instanceof ActionSet) {
                    action = (ActionSet)element;
                } else if (element instanceof Action) {
                    action = ((Action)element).getParent();
                }
                if (action != null) {
                    e.setName(action.getName());
                }
            }
            this.fireActionsViewEvent(e);
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final TreeViewer treeViewer = new TreeViewer(new Tree(parent, 772));
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                StyledText label = (StyledText)event.widget;
                Shell shell = (Shell)label.getData("_SHELL");
                switch (event.type) {
                    case 8: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TREEITEM");
                        treeViewer.getTree().setSelection(new TreeItem[]{(TreeItem)e.item});
                        ActionsView.this.actionDoubleClick.run();
                        shell.dispose();
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
        final Shell shell = this.getSite().getShell();
        Listener tableListener = new Listener(){
            UnifiedInformationControl info = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.info == null || this.info.getShell() == null) break;
                        this.info.getShell().dispose();
                        this.info = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = treeViewer.getTree().getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.info != null && this.info.getShell() != null && !this.info.getShell().isDisposed()) {
                            this.info.getShell().dispose();
                        }
                        this.info = new UnifiedInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                        this.info.getStyledTextWidget().setData("_TREEITEM", (Object)item);
                        this.info.getStyledTextWidget().setData("_SHELL", (Object)this.info.getShell());
                        this.info.getStyledTextWidget().addListener(7, labelListener);
                        this.info.getStyledTextWidget().addListener(8, labelListener);
                        Object data = item.getData();
                        String txt = null;
                        if (data instanceof IAction) {
                            IAction action = (IAction)data;
                            txt = action.getToolTipText();
                        } else if (data instanceof IPath) {
                            IPath path = (IPath)data;
                            txt = path.toOSString();
                        }
                        if (txt == null) break;
                        if (txt.indexOf("<") != -1) {
                            txt = txt.replaceAll("<", "&lt;");
                        }
                        this.info.setSizeConstraints(300, 500);
                        this.info.setInformation(txt);
                        StyledText styledText = this.info.getStyledTextWidget();
                        GC gc = new GC((Drawable)styledText);
                        int width = gc.getFontMetrics().getAverageCharWidth();
                        width = (txt.length() + 2) * width;
                        Rectangle rect = item.getBounds(0);
                        Point pt = treeViewer.getTree().toDisplay(20 + rect.x, rect.y);
                        this.info.setSize(width, 0);
                        this.info.setLocation(pt);
                        this.info.setVisible(true);
                    }
                }
            }
        };
        treeViewer.getTree().addListener(12, tableListener);
        treeViewer.getTree().addListener(1, tableListener);
        treeViewer.getTree().addListener(5, tableListener);
        treeViewer.getTree().addListener(32, tableListener);
        return treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = ActionsView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                ActionsView.this.fillContextMenu(manager, firstElement);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((org.eclipse.jface.action.IAction)this.actionEdit);
        manager.add((org.eclipse.jface.action.IAction)this.actionReload);
    }

    private void fillContextMenu(IMenuManager manager, Object element) {
        if (element instanceof ActionSet) {
            ActionSet set = (ActionSet)element;
            if (set.isExecutable()) {
                manager.add((org.eclipse.jface.action.IAction)this.actionExecute);
            }
            manager.add((org.eclipse.jface.action.IAction)this.actionMakeExecutable);
        } else {
            manager.add((org.eclipse.jface.action.IAction)this.actionExecute);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((org.eclipse.jface.action.IAction)this.actionEdit);
        manager.add((org.eclipse.jface.action.IAction)this.actionReload);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void makeActions() {
        this.actionMakeExecutable = new org.eclipse.jface.action.Action(){

            public void run() {
                IStructuredSelection structuredSelection;
                Object element;
                ISelection selection = ActionsView.this.viewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ActionSet) {
                    if (((ActionSet)element).isExecutable()) {
                        ((ActionSet)element).setExecutable(false);
                    } else {
                        ((ActionSet)element).setExecutable(true);
                    }
                    ActionsView.this.viewer.refresh();
                }
            }
        };
        this.actionMakeExecutable.setText(Messages.ActionsView_ToggleExecutable);
        this.actionMakeExecutable.setToolTipText(Messages.ActionsView_ToggleToolTip);
        this.actionExecute = new org.eclipse.jface.action.Action(){

            public void run() {
                ActionsViewEvent e = new ActionsViewEvent(0);
                ISelection selection = ActionsView.this.viewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    IAction[] actions = element instanceof IAction ? new IAction[]{(IAction)element} : new IAction[]{};
                    e.setActions(actions);
                }
                ActionsView.this.fireActionsViewEvent(e);
            }
        };
        this.actionExecute.setText(Messages.ActionsView_Execute);
        this.actionExecute.setToolTipText(Messages.ActionsView_ExecuteToolTip);
        this.actionAddCurrentFile = new org.eclipse.jface.action.Action(){

            public void run() {
                Object firstElement;
                ActionsViewEvent e = new ActionsViewEvent(3);
                ISelection selection = ActionsView.this.viewer.getSelection();
                if (selection != null && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ActionSet) {
                    e.setName(((ActionSet)firstElement).getName());
                }
                ActionsView.this.fireActionsViewEvent(e);
            }
        };
        this.actionAddCurrentFile.setText(Messages.ActionsView_AddCurrentFile);
        this.actionAddCurrentFile.setToolTipText(Messages.ActionsView_AddCurrentFileToolTip);
        this.actionNewActionSet = new org.eclipse.jface.action.Action(){

            public void run() {
                InputDialog input = new InputDialog(ActionsView.this.getSite().getShell(), Messages.ActionsView_NewActionSetName, Messages.ActionsView_PleaseEnterActionSetName, "", null);
                if (input.open() == 0 && input.getValue().length() > 0) {
                    ActionsViewEvent e = new ActionsViewEvent(4);
                    e.setName(input.getValue());
                    ActionsView.this.fireActionsViewEvent(e);
                }
            }
        };
        this.actionNewActionSet.setText(Messages.ActionsView_NewActionSet);
        this.actionNewActionSet.setToolTipText(Messages.ActionsView_NewActionSet);
        this.actionNewActionSet.setImageDescriptor(fAddFileIconDescriptor);
        this.actionEdit = new org.eclipse.jface.action.Action(){

            public void run() {
                Object firstElement;
                ISelection selection = ActionsView.this.viewer.getSelection();
                if (selection != null && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Action) {
                    Action a = (Action)firstElement;
                    ActionsView.this.editAction(a);
                }
            }
        };
        this.actionEdit.setText(Messages.ActionsView_EditAction);
        this.actionEdit.setToolTipText(Messages.ActionsView_EditAction);
        this.actionReload = new org.eclipse.jface.action.Action(){

            public void run() {
                Object firstElement;
                ISelection selection = ActionsView.this.viewer.getSelection();
                if (selection != null && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Action) {
                    Action a = (Action)firstElement;
                    ActionsView.this.reloadAction(a);
                }
            }
        };
        this.actionReload.setText(Messages.ActionsView_ReloadAction);
        this.actionReload.setToolTipText(Messages.ActionsView_ReloadAction);
        this.actionAdd = new org.eclipse.jface.action.Action(){

            public void run() {
                FileDialog fileDialog = new FileDialog(ActionsView.this.viewer.getControl().getShell(), 2);
                fileDialog.setFilterExtensions(FILTER_EXTENSIONS);
                fileDialog.setFilterNames(FILTER_NAMES);
                String text = fileDialog.open();
                if (text != null) {
                    Path basePath = new Path(fileDialog.getFilterPath());
                    String[] fileNames = fileDialog.getFileNames();
                    IPath[] paths = new IPath[fileNames.length];
                    int i = 0;
                    while (i < paths.length) {
                        paths[i] = basePath.append(fileNames[i]);
                        ++i;
                    }
                    ActionsViewEvent e = new ActionsViewEvent(2);
                    e.setPaths(paths);
                    ActionsView.this.fireActionsViewEvent(e);
                }
            }
        };
        this.actionAdd.setText(Messages.ActionsView_AddFile);
        this.actionAdd.setToolTipText(Messages.ActionsView_AddFile);
        this.actionAdd.setImageDescriptor(fAddFileIconDescriptor);
        this.actionDelete = new org.eclipse.jface.action.Action(){

            public void run() {
                ActionsView.this.removeFiles(ActionsView.this.viewer.getSelection());
            }
        };
        this.actionDelete.setText(Messages.ActionsView_RemoveFile);
        this.actionDelete.setToolTipText(Messages.ActionsView_RemoveFile);
        this.actionDelete.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionDoubleClick = new org.eclipse.jface.action.Action(){

            public void run() {
                ISelection selection = ActionsView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof ActionSet) {
                    ActionsView.this.toggleElementState(firstElement);
                } else if (firstElement instanceof IAction) {
                    ActionsViewEvent e = new ActionsViewEvent(0);
                    IAction[] actions = new IAction[]{(IAction)firstElement};
                    e.setActions(actions);
                    ActionsView.this.fireActionsViewEvent(e);
                }
            }
        };
    }

    private void toggleElementState(Object element) {
        boolean state = this.viewer.getExpandedState(element);
        if (state) {
            this.viewer.setExpandedState(element, false);
        } else {
            this.viewer.setExpandedState(element, true);
        }
    }

    private void removeFiles(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object o = ((StructuredSelection)selection).getFirstElement();
        if (o == null) {
            return;
        }
        if (o instanceof ActionSet) {
            ActionsViewEvent e = new ActionsViewEvent(6);
            e.setName(((ActionSet)o).getName());
            this.fireActionsViewEvent(e);
        } else {
            ArrayList actionsList = new ArrayList();
            Iterator iter = ((StructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                actionsList.add(iter.next());
            }
            IAction[] actions = actionsList.toArray(new Action[0]);
            if (actions.length > 0) {
                ActionsViewEvent e = new ActionsViewEvent(5);
                e.setActions(actions);
                this.fireActionsViewEvent(e);
            }
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionsView.this.actionDoubleClick.run();
            }
        });
    }

    private void hookKeyActions(Control control) {
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    ActionsView.this.removeFiles(ActionsView.this.viewer.getSelection());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private static ImageDescriptor getImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = UnifiedEditorsPlugin.getImageDescriptor(imageFilePath);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public void expandAll() {
        this.viewer.expandAll();
    }

    public void expandActionSet(String setName) {
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            ActionSet p;
            String name;
            Object o = treeItems[i].getData();
            if (o instanceof ActionSet && (name = (p = (ActionSet)o).getName()).equals(setName)) {
                this.viewer.setExpandedState(o, true);
                this.viewer.getTree().showItem(treeItems[i]);
                return;
            }
            ++i;
        }
    }

    public void selectAndReveal(String actionPath) {
        Action a = this.findAction(actionPath);
        if (a != null && a instanceof Action) {
            this.selectAndReveal(a);
        }
    }

    public void selectAndReveal(Action action) {
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        this.forcePopulateTree();
        int i = 0;
        while (i < treeItems.length) {
            Action a;
            Object o = treeItems[i].getData();
            if (o instanceof ActionSet) {
                TreeItem[] children = treeItems[i].getItems();
                int j = 0;
                while (j < children.length) {
                    IAction a2 = (IAction)children[j].getData();
                    if (a2 == action) {
                        this.viewer.getTree().showItem(children[j]);
                        this.viewer.getTree().setSelection(new TreeItem[]{children[j]});
                        return;
                    }
                    ++j;
                }
            } else if (o instanceof Action && (a = (Action)o) == action) {
                this.viewer.getTree().showItem(treeItems[i]);
                this.viewer.getTree().setSelection(new TreeItem[]{treeItems[i]});
                return;
            }
            ++i;
        }
    }

    public void forcePopulateTree() {
        this.viewer.getTree().setVisible(false);
        Object[] expandedElement = this.viewer.getExpandedElements();
        this.viewer.expandAll();
        this.viewer.setExpandedElements(expandedElement);
        this.viewer.getTree().setVisible(true);
    }

    public ActionSet findActionSet(String name) {
        ActionSet result = null;
        TreeItem[] treeItems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            ActionSet actionSet;
            Object itemData = treeItems[i].getData();
            if (itemData instanceof ActionSet && (actionSet = (ActionSet)itemData).getName().equals(name)) {
                result = actionSet;
                break;
            }
            ++i;
        }
        return result;
    }

    public Action findAction(String path) {
        int slashIndex;
        Action result = null;
        if (path != null && path.length() > 0 && path.charAt(0) == '/' && (slashIndex = path.indexOf(47, 1)) != -1) {
            String actionSetName = path.substring(1, slashIndex);
            String actionName = path.substring(slashIndex + 1);
            ActionSet actionSet = this.findActionSet(actionSetName);
            if (actionSet != null) {
                Action[] actions = actionSet.getActions();
                int i = 0;
                while (i < actions.length) {
                    Action action = actions[i];
                    if (action.getName().equals(actionName)) {
                        result = action;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public void fireAction(String actionName) {
        Action action = this.findAction(actionName);
        if (action != null) {
            ActionsViewEvent actionEvent = new ActionsViewEvent(0);
            IAction[] actions = new IAction[]{action};
            actionEvent.setActions(actions);
            this.fireActionsViewEvent(actionEvent);
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void editAction(String path) {
        this.editAction(this.findAction(path));
    }

    private void editAction(final IAction a) {
        if (a == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor editorDesc = null;
        File f = new File(a.getFilePath());
        try {
            editorDesc = IDE.getEditorDescriptor((String)f.getName());
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ActionsView_ErrorOpeningFile, (Throwable)e);
        }
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)CoreUIUtils.createJavaFileEditorInput((File)f), (String)editorDesc.getId());
            if (editorPart instanceof IUnifiedEditor) {
                IUnifiedEditor editor = (IUnifiedEditor)editorPart;
                editor.addSaveListener(new ISaveEvent(){

                    public void onSave(IEditorPart part) {
                        ActionsView.this.reloadAction(a);
                    }
                });
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ActionsView_ErrorOpeningEditor, (Throwable)e);
        }
    }

    private void reloadAction(IAction a) {
        ActionsViewEvent e = new ActionsViewEvent(7);
        e.setActions(new IAction[]{a});
        this.fireActionsViewEvent(e);
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] actions = ActionsView.this.actionsManager.getAll();
            if (actions != null && actions.length > 0) {
                if (ActionsView.this.layout != null && ActionsView.this.infoLabel != null && ActionsView.this.viewParent != null && ((ActionsView)ActionsView.this).layout.topControl == ActionsView.this.infoLabel) {
                    ((ActionsView)ActionsView.this).layout.topControl = ActionsView.this.viewer.getControl();
                    ActionsView.this.viewParent.layout();
                }
                return actions;
            }
            if (ActionsView.this.layout != null && ActionsView.this.infoLabel != null && ActionsView.this.viewParent != null) {
                ((ActionsView)ActionsView.this).layout.topControl = ActionsView.this.infoLabel;
                ActionsView.this.viewParent.layout();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ActionSet) {
                ActionSet actionSet = (ActionSet)parentElement;
                Object[] actions = actionSet.getActions();
                return actions;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Action) {
                return ((Action)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ActionSet) {
                ActionSet actionSet = (ActionSet)element;
                return actionSet.getActions().length > 0;
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IAction) {
                IAction profile = (IAction)element;
                return profile.getName();
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof ActionSet) {
                ActionSet set = (ActionSet)obj;
                if (set.isExecutable()) {
                    return fProfileDynamicIcon;
                }
                return fProfileIcon;
            }
            if (obj instanceof Action) {
                return fProfileFileIcon;
            }
            return null;
        }
    }

    class ViewerSorterProvider
    extends ViewerSorter {
        ViewerSorterProvider() {
        }

        public int category(Object element) {
            if (element instanceof Action) {
                return 0;
            }
            return 1;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 == (cat2 = this.category(e2))) {
                IAction action1 = (IAction)e1;
                IAction action2 = (IAction)e2;
                return action1.getName().compareTo(action2.getName());
            }
            return cat1 - cat2;
        }
    }
}

