/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.hyperlinks;

import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.hyperlinks.UnifiedSourceHyperlink;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.ICodeLocation;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class UnifiedHyperlinkDetector
implements IHyperlinkDetector {
    private static final IHyperlink[] EMPTY = null;
    private IFileLanguageService service;

    public UnifiedHyperlinkDetector(IFileLanguageService service) {
        this.service = service;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (this.service == null) {
            return EMPTY;
        }
        IOffsetMapper mapper = this.service.getOffsetMapper();
        if (mapper == null) {
            return EMPTY;
        }
        LexemeList lxList = mapper.getLexemeList();
        if (lxList == null) {
            return EMPTY;
        }
        Lexeme lx = lxList.getLexemeFromOffset(region.getOffset());
        if (lx == null) {
            return EMPTY;
        }
        String mimetype = lx.getLanguage();
        IRuntimeEnvironment env = EnvironmentManager.getEnvironment(mimetype);
        IFileLanguageService langService = this.service.getFileContext().getLanguageService(mimetype);
        if (langService == null || env == null) {
            return EMPTY;
        }
        IOffsetMapper langMapper = langService.getOffsetMapper();
        if (langMapper == null) {
            return EMPTY;
        }
        ICodeLocation loc = langMapper.findTarget(lx);
        if (loc == null) {
            return EMPTY;
        }
        Region linkRegion = new Region(lx.offset, lx.length);
        UnifiedSourceHyperlink link = new UnifiedSourceHyperlink(this.service, lx, (IRegion)linkRegion, lx.getText());
        return new IHyperlink[]{link};
    }
}

