/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class UnifiedCursorLinePainter
implements IPainter,
LineBackgroundListener {
    private final ITextViewer fViewer;
    private Color fHighlightColor;
    private IPaintPositionManager fPositionManager;
    private Position fCurrentLine = new Position(0, 0);
    private Position fLastLine = new Position(0, 0);
    private int fLastLineNumber = -1;
    private boolean fIsActive;
    private IUnifiedEditor editor;
    private IPreferenceStore store;
    private Map<String, Set<String>> lanaguageParents;

    public UnifiedCursorLinePainter(IUnifiedEditor editor, ITextViewer textViewer) {
        this.fViewer = textViewer;
        this.editor = editor;
        this.store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
    }

    public void setHighlightColor(Color highlightColor) {
        this.fHighlightColor = highlightColor;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        StyledText textWidget = this.fViewer.getTextWidget();
        if (textWidget != null) {
            int caret = textWidget.getCaretOffset();
            int length = event.lineText.length();
            event.lineBackground = event.lineOffset <= caret && caret <= event.lineOffset + length ? this.fHighlightColor : textWidget.getBackground();
            try {
                Lexeme finalLexeme;
                LexemeList lexemeList;
                IParseState parseState;
                EditorFileContext fileContext;
                int lineOffset = event.lineOffset;
                if (this.fViewer instanceof ITextViewerExtension5) {
                    lineOffset = ((ITextViewerExtension5)this.fViewer).widgetOffset2ModelOffset(lineOffset);
                }
                if ((fileContext = this.editor.getFileContext()) != null && fileContext.getFileContext() != null && (parseState = fileContext.getParseState()) != null && (lexemeList = parseState.getLexemeList()) != null && (finalLexeme = this.countBackgroundReferenceLexemeByOffset(lineOffset, length, lexemeList, parseState)) != null && finalLexeme != null) {
                    if (event.lineOffset <= caret && caret <= event.lineOffset + length) {
                        event.lineBackground = this.getLineHighlightBackgroundByLexeme(finalLexeme);
                    } else {
                        this.handleBackground(finalLexeme, event, textWidget, lineOffset, parseState, lexemeList);
                    }
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
        }
    }

    private Color getBackgroundColor(IParseState state, Lexeme lexeme, int offset) {
        Color bg = null;
        if (lexeme != null) {
            String language = lexeme.getToken().getLanguage();
            if ("text/jscomment".equals(language)) {
                language = "text/javascript";
            }
            LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer(language);
            bg = this.isEmptyLine(state.getLexemeList(), offset) ? colorizer.getEmptyLineBackground(state, offset) : colorizer.getBackground(state, lexeme);
        }
        return bg;
    }

    private boolean isEmptyLine(LexemeList list, int offset) {
        int index = -1;
        index = list.getLexemeCeilingIndex(offset);
        if (index == -1) {
            return false;
        }
        Lexeme candidate = list.get(index);
        if (this.fViewer instanceof ITextViewerExtension5) {
            int currentWidgetOffset = ((ITextViewerExtension5)this.fViewer).modelOffset2WidgetOffset(offset);
            int currentLineOffset = this.fViewer.getTextWidget().getLineAtOffset(currentWidgetOffset);
            int newWidgetOffset = ((ITextViewerExtension5)this.fViewer).modelOffset2WidgetOffset(candidate.offset + candidate.length);
            int newLineOffset = this.fViewer.getTextWidget().getLineAtOffset(newWidgetOffset);
            if (newLineOffset > currentLineOffset) {
                return true;
            }
        }
        return false;
    }

    public void paintLines(int start, int lineCount) {
        StyledText textWidget = this.fViewer.getTextWidget();
        if (textWidget != null) {
            try {
                LexemeList lexemeList;
                IParseState parseState;
                EditorFileContext fileContext = this.editor.getFileContext();
                if (fileContext != null && fileContext.getFileContext() != null && (parseState = fileContext.getParseState()) != null && (lexemeList = parseState.getLexemeList()) != null) {
                    int i = 0;
                    while (i < lineCount) {
                        Color pianoed;
                        Color bg;
                        int index;
                        int offset = textWidget.getOffsetAtLine(start + i);
                        if (this.fViewer instanceof ITextViewerExtension5) {
                            offset = ((ITextViewerExtension5)this.fViewer).widgetOffset2ModelOffset(offset);
                        }
                        if ((index = lexemeList.getLexemeCeilingIndex(offset)) > -1) {
                            bg = this.getBackgroundColor(parseState, lexemeList.get(index), offset);
                            pianoed = this.createPianoedColor(bg);
                            if (start + i % 2 != 0 && pianoed != null && this.store.getBoolean("com.aptana.ide.editors.SHOW_PIANO_KEYS")) {
                                textWidget.setLineBackground(start + i, 1, pianoed);
                            } else {
                                textWidget.setLineBackground(start + i, 1, bg);
                            }
                        } else {
                            index = lexemeList.getLexemeFloorIndex(offset);
                            if (index > -1) {
                                bg = this.getBackgroundColor(parseState, lexemeList.get(index), offset);
                                pianoed = this.createPianoedColor(bg);
                                if (start + i % 2 != 0 && pianoed != null && this.store.getBoolean("com.aptana.ide.editors.SHOW_PIANO_KEYS")) {
                                    textWidget.setLineBackground(start + i, 1, pianoed);
                                } else {
                                    textWidget.setLineBackground(start + i, 1, bg);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
        }
    }

    private Color createPianoedColor(Color bg) {
        if (bg == null) {
            return null;
        }
        int factor = this.store.getInt("com.aptana.ide.editors.PIANO_KEY_DIFFERENCE");
        boolean canGoDarker = bg.getRed() - factor > 0 || bg.getGreen() - factor > 0 || bg.getBlue() - factor > 0;
        boolean canGoLighter = bg.getRed() + factor > 0 || bg.getGreen() + factor > 0 || bg.getBlue() + factor > 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        if (canGoDarker) {
            red = bg.getRed() - factor > 0 ? bg.getRed() - factor : bg.getRed();
            green = bg.getGreen() - factor > 0 ? bg.getGreen() - factor : bg.getGreen();
            blue = bg.getBlue() - factor > 0 ? bg.getBlue() - factor : bg.getBlue();
        } else if (canGoLighter) {
            red = bg.getRed() + factor > 0 ? bg.getRed() + factor : bg.getRed();
            green = bg.getGreen() + factor > 0 ? bg.getGreen() + factor : bg.getGreen();
            int n = blue = bg.getBlue() + factor > 0 ? bg.getBlue() + factor : bg.getBlue();
        }
        if (canGoDarker || canGoLighter) {
            Color deadSpace = UnifiedColorManager.getInstance().getColor(new RGB(red, green, blue));
            return deadSpace;
        }
        return null;
    }

    private boolean updateHighlightLine() {
        try {
            IDocument document = this.fViewer.getDocument();
            int modelCaret = this.getModelCaret();
            int lineNumber = document.getLineOfOffset(modelCaret);
            if (lineNumber != this.fLastLineNumber || !this.fCurrentLine.overlapsWith(modelCaret, 0)) {
                this.fLastLine.offset = this.fCurrentLine.offset;
                this.fLastLine.length = this.fCurrentLine.length;
                this.fLastLine.isDeleted = this.fCurrentLine.isDeleted;
                if (this.fCurrentLine.isDeleted) {
                    this.fCurrentLine.isDeleted = false;
                    this.fPositionManager.managePosition(this.fCurrentLine);
                }
                this.fCurrentLine.offset = document.getLineOffset(lineNumber);
                this.fCurrentLine.length = lineNumber == document.getNumberOfLines() - 1 ? document.getLength() - this.fCurrentLine.offset : document.getLineOffset(lineNumber + 1) - this.fCurrentLine.offset;
                this.fLastLineNumber = lineNumber;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int getModelCaret() {
        int widgetCaret = this.fViewer.getTextWidget().getCaretOffset();
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            return extension.widgetOffset2ModelOffset(widgetCaret);
        }
        IRegion visible = this.fViewer.getVisibleRegion();
        return widgetCaret + visible.getOffset();
    }

    private void drawHighlightLine(Position position) {
        if (position.isDeleted()) {
            return;
        }
        int widgetOffset = 0;
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            widgetOffset = extension.modelOffset2WidgetOffset(position.getOffset());
            if (widgetOffset == -1) {
                return;
            }
        } else {
            IRegion visible = this.fViewer.getVisibleRegion();
            widgetOffset = position.getOffset() - visible.getOffset();
            if (widgetOffset < 0 || visible.getLength() < widgetOffset) {
                return;
            }
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        if (widgetOffset >= 0 && widgetOffset <= textWidget.getCharCount()) {
            Point upperLeft = textWidget.getLocationAtOffset(widgetOffset);
            int width = textWidget.getClientArea().width + textWidget.getHorizontalPixel();
            int height = textWidget.getLineHeight(widgetOffset);
            textWidget.redraw(0, upperLeft.y, width, height, false);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            if (redraw) {
                this.drawHighlightLine(this.fCurrentLine);
            }
            this.fViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this);
            if (this.fPositionManager != null) {
                this.fPositionManager.unmanagePosition(this.fCurrentLine);
            }
            this.fLastLineNumber = -1;
            this.fCurrentLine.offset = 0;
            this.fCurrentLine.length = 0;
        }
    }

    public void dispose() {
    }

    public void paint(int reason) {
        int endLine;
        if (this.fViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        StyledText textWidget = this.fViewer.getTextWidget();
        Point selection = textWidget.getSelection();
        int startLine = textWidget.getLineAtOffset(selection.x);
        if (startLine != (endLine = textWidget.getLineAtOffset(selection.y))) {
            this.deactivate(true);
            return;
        }
        if (!this.fIsActive) {
            textWidget.addLineBackgroundListener((LineBackgroundListener)this);
            this.fPositionManager.managePosition(this.fCurrentLine);
            this.fIsActive = true;
        }
        if (this.updateHighlightLine()) {
            this.drawHighlightLine(this.fLastLine);
            this.drawHighlightLine(this.fCurrentLine);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.fPositionManager = manager;
    }

    private Color getLineHighlightBackgroundByLexeme(Lexeme lexeme) {
        String language = lexeme.getToken().getLanguage();
        if (language == null) {
            return null;
        }
        LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer(language);
        if (colorizer == null) {
            return null;
        }
        return colorizer.getLineHighlightColor();
    }

    private void handleBackground(Lexeme lexeme, LineBackgroundEvent event, StyledText textWidget, int lineOffset, IParseState parseState, LexemeList lexemeList) {
        int lineNumber = textWidget.getLineAtOffset(event.lineOffset);
        Color bg = this.getBackgroundColor(parseState, lexeme, lineOffset);
        Color pianoed = this.createPianoedColor(bg);
        event.lineBackground = lineNumber % 2 != 0 && pianoed != null && this.store.getBoolean("com.aptana.ide.editors.SHOW_PIANO_KEYS") ? pianoed : bg;
    }

    private Lexeme countBackgroundReferenceLexemeByOffset(int lineOffset, int lineLength, LexemeList lexemeList, IParseState state) {
        Lexeme ceilingLexeme = null;
        Lexeme floorLexeme = null;
        int ceilingIndex = lexemeList.getLexemeCeilingIndex(lineOffset);
        int floorIndex = lexemeList.getLexemeFloorIndex(lineOffset);
        if (ceilingIndex > -1) {
            ceilingLexeme = lexemeList.get(ceilingIndex);
        }
        if (floorIndex > -1) {
            floorLexeme = lexemeList.get(floorIndex);
        }
        Lexeme finalLexeme = null;
        finalLexeme = ceilingIndex != -1 && floorIndex != -1 && ceilingIndex != floorIndex ? this.chooseBetterBackgroundLexeme(ceilingLexeme, floorLexeme, state, lineOffset, lineLength) : (ceilingLexeme != null ? ceilingLexeme : floorLexeme);
        return finalLexeme;
    }

    private Lexeme chooseBetterBackgroundLexeme(Lexeme ceilingLexeme, Lexeme floorLexeme, IParseState parseState, int lineOffset, int lineLength) {
        String floorLanguage;
        String ceilingLanguage = ceilingLexeme.getToken().getLanguage();
        if (ceilingLanguage == (floorLanguage = floorLexeme.getToken().getLanguage())) {
            return ceilingLexeme;
        }
        if (this.lanaguageParents == null) {
            this.makeLaguageRelationsCache(parseState);
        }
        Set<String> parents = this.lanaguageParents.get(ceilingLanguage);
        boolean ceilingLanguageIsChild = false;
        if (parents == null) {
            this.makeLaguageRelationsCache(parseState);
            parents = this.lanaguageParents.get(ceilingLanguage);
            if (parents == null) {
                ceilingLanguageIsChild = false;
            }
        }
        if (parents != null) {
            ceilingLanguageIsChild = parents.contains(floorLanguage);
        }
        if (ceilingLanguageIsChild) {
            return ceilingLexeme;
        }
        if (ceilingLexeme.getStartingOffset() >= lineOffset && ceilingLexeme.getStartingOffset() < lineOffset + lineLength) {
            return ceilingLexeme;
        }
        return floorLexeme;
    }

    private void makeLaguageRelationsCache(IParseState parseState) {
        this.lanaguageParents = new HashMap<String, Set<String>>();
        IParseState rootState = parseState;
        while (rootState.getParent() != null) {
            rootState = rootState.getParent();
        }
        this.cacheLanguageChildrenLerations(parseState);
    }

    private void cacheLanguageChildrenLerations(IParseState parseState) {
        String language = parseState.getLanguage();
        if (language == null) {
            return;
        }
        IParseState[] children = parseState.getChildren();
        if (children == null) {
            return;
        }
        IParseState[] iParseStateArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParseState childState = iParseStateArray[n2];
            String childLanguage = childState.getLanguage();
            if (childLanguage != null) {
                Set<String> currentParents = this.lanaguageParents.get(childLanguage);
                if (currentParents == null) {
                    currentParents = new HashSet<String>();
                    this.lanaguageParents.put(childLanguage, currentParents);
                }
                currentParents.add(language);
                this.cacheLanguageChildrenLerations(childState);
            }
            ++n2;
        }
    }
}

