/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.contentassist.IUnifiedContentAssistProcessor;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import com.aptana.ide.editors.unified.contentassist.UnifiedTemplateCompletionProcessor;
import com.aptana.ide.parsing.IOffsetMapper;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class MergingContentProcessor
implements IContentAssistProcessor,
IUnifiedContentAssistProcessor {
    private IContentAssistProcessor processor;
    private UnifiedTemplateCompletionProcessor templateProcessor;

    public MergingContentProcessor(IContentAssistProcessor processor, UnifiedTemplateCompletionProcessor unifiedTemplateCompletionProcessor) {
        this.processor = processor;
        this.templateProcessor = unifiedTemplateCompletionProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer, offset, UnifiedContentAssistProcessor.DEFAULT_CHARACTER);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar) {
        return this.computeCompletionProposals(viewer, offset, activationChar, false);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        ICompletionProposal[] proposals = this.processor instanceof IUnifiedContentAssistProcessor ? ((IUnifiedContentAssistProcessor)this.processor).computeCompletionProposals(viewer, offset, activationChar, autoActivated) : this.processor.computeCompletionProposals(viewer, offset);
        ICompletionProposal[] templates = this.templateProcessor.computeCompletionProposals(viewer, offset);
        if (proposals == null || proposals.length == 0) {
            return templates;
        }
        if (templates == null || templates.length == 0) {
            return proposals;
        }
        ICompletionProposal[] combined = new ICompletionProposal[proposals.length + templates.length];
        System.arraycopy(proposals, 0, combined, 0, proposals.length);
        System.arraycopy(templates, 0, combined, proposals.length, templates.length);
        Arrays.sort(combined, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
        return combined;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.processor.computeContextInformation(viewer, offset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.processor.getCompletionProposalAutoActivationCharacters();
    }

    public int[] getCompletionProposalIdleActivationTokens() {
        if (this.processor instanceof IUnifiedContentAssistProcessor) {
            return ((IUnifiedContentAssistProcessor)this.processor).getCompletionProposalIdleActivationTokens();
        }
        return null;
    }

    public IContentAssistProcessor getContentAssistProcessor() {
        return this.processor;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.processor.getContextInformationAutoActivationCharacters();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.processor.getContextInformationValidator();
    }

    public String getErrorMessage() {
        return this.processor.getErrorMessage();
    }

    public IOffsetMapper getOffsetMapper() {
        if (this.processor instanceof IUnifiedContentAssistProcessor) {
            return ((IUnifiedContentAssistProcessor)this.processor).getOffsetMapper();
        }
        return null;
    }

    public boolean isValidIdleActivationLocation(ITextViewer viewer, int offset) {
        if (this.processor instanceof IUnifiedContentAssistProcessor) {
            return ((IUnifiedContentAssistProcessor)this.processor).isValidIdleActivationLocation(viewer, offset);
        }
        return false;
    }
}

