/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ICodeFormatter;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseFormatter
implements ICodeFormatter {
    protected boolean displayErrors = true;

    public void setDisplayErrors(boolean display) {
        this.displayErrors = display;
    }

    public boolean shouldDisplayErrors() {
        return this.displayErrors;
    }

    public boolean isFormattingCorrect(LexemeList originalList, IParser parser, String original, String formatted, int[] ignorableSizeNodes, int[] ignorableCountNodes) {
        int originalSize;
        int modifiedSize;
        boolean isCorrect = true;
        IParseState createParseState = parser.createParseState(null);
        createParseState.setEditState(formatted, formatted, 0, 0);
        try {
            parser.parse(createParseState);
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseFormatter_INF_ErrorParsingFormattedContent, (Throwable)e);
            isCorrect = false;
            return isCorrect;
        }
        LexemeList modifiedList = createParseState.getLexemeList();
        if (ignorableCountNodes != null && ignorableCountNodes.length > 0) {
            int i;
            int j = 0;
            while (j < modifiedList.size()) {
                i = 0;
                while (i < ignorableCountNodes.length) {
                    if (modifiedList.get((int)j).typeIndex == ignorableCountNodes[i]) {
                        modifiedList.remove(j);
                        break;
                    }
                    ++i;
                }
                ++j;
            }
            j = 0;
            while (j < originalList.size()) {
                i = 0;
                while (i < ignorableCountNodes.length) {
                    if (originalList.get((int)j).typeIndex == ignorableCountNodes[i]) {
                        originalList.remove(j);
                        break;
                    }
                    ++i;
                }
                ++j;
            }
        }
        if ((modifiedSize = modifiedList.size()) != (originalSize = originalList.size())) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.BaseFormatter_INF_NewLexemeListSizeMismatch, (Object[])new Object[]{"" + modifiedSize, "" + originalSize}));
            isCorrect = false;
        }
        int i = 0;
        while (i < modifiedList.size()) {
            Lexeme oLexeme = originalList.get(i);
            String oText = oLexeme.getText();
            Lexeme mLexeme = modifiedList.get(i);
            String mText = mLexeme.getText();
            boolean ignore = false;
            if (ignorableSizeNodes != null && ignorableSizeNodes.length > 0) {
                int j = 0;
                while (j < ignorableSizeNodes.length) {
                    if (mLexeme.typeIndex == ignorableSizeNodes[j] && oLexeme.typeIndex == ignorableSizeNodes[j]) {
                        ignore = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!ignore && !this.textIsEqual(mText, oText)) {
                IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.BaseFormatter_INF_NewLexemeMismatch, (Object[])new Object[]{this.printReturns(this.stripSpace(mText)), this.printReturns(this.stripSpace(oText))}));
                isCorrect = false;
                break;
            }
            ++i;
        }
        if (!isCorrect) {
            this.logError(original, formatted);
        }
        return isCorrect;
    }

    private boolean textIsEqual(String text, String text2) {
        String newMText = StringUtils.replace((String)text, (String)"\r\n", (String)"");
        newMText = StringUtils.replace((String)newMText, (String)"\r", (String)"");
        newMText = StringUtils.replace((String)newMText, (String)"\n", (String)"");
        newMText = StringUtils.replace((String)newMText, (String)" ", (String)"");
        newMText = StringUtils.replace((String)newMText, (String)"\t", (String)"");
        String newOText = StringUtils.replace((String)text2, (String)"\r\n", (String)"");
        newOText = StringUtils.replace((String)newOText, (String)"\r", (String)"");
        newOText = StringUtils.replace((String)newOText, (String)"\n", (String)"");
        newOText = StringUtils.replace((String)newOText, (String)" ", (String)"");
        newOText = StringUtils.replace((String)newOText, (String)"\t", (String)"");
        return newMText.equals(newOText);
    }

    public String normalizeCarriageReturns(String text) {
        String newMText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        return StringUtils.replace((String)newMText, (String)"\r", (String)"\n");
    }

    private String stripSpace(String text) {
        String newText = StringUtils.replace((String)text, (String)" ", (String)"\\_");
        return StringUtils.replace((String)newText, (String)"\t", (String)"\\t");
    }

    private String printReturns(String text) {
        String newText = StringUtils.replace((String)text, (String)"\r", (String)"\\r");
        return StringUtils.replace((String)newText, (String)"\n", (String)"\\n");
    }

    protected void logError(String original, String formatted) {
        original = this.printReturns(original);
        formatted = this.printReturns(formatted);
        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.BaseFormatter_ERR_FormattingFailure, (Object[])new String[]{this.stripSpace(original), this.stripSpace(formatted)}));
        if (this.displayErrors) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.BaseFormatter_TTL_ErrorFormatting, (String)Messages.BaseFormatter_INF_FormattingErrorDetails);
        }
    }

    public boolean isLexemeOfType(Lexeme lexeme, int type) {
        return lexeme != null && lexeme.typeIndex == type;
    }

    protected String getStartLineBreaks(SourceWriter writer, String source2, String formatted) {
        String oldWhitespace = StringUtils.findStartWhitespace((String)source2);
        String newWhitespace = StringUtils.findStartWhitespace((String)formatted);
        int oldNewLines = StringUtils.getNumberOfNewlines((String)oldWhitespace);
        int newNewLines = StringUtils.getNumberOfNewlines((String)newWhitespace);
        String toAppend = "";
        if (oldNewLines > newNewLines) {
            int diff = oldNewLines - newNewLines;
            int i = 0;
            while (i < diff) {
                toAppend = String.valueOf(toAppend) + writer.getCurrentIndentationString() + writer.getLineDelimeter();
                ++i;
            }
        }
        return toAppend;
    }

    protected String getEndLineBreaks(SourceWriter writer, String source2, String formatted) {
        String oldWhitespace = StringUtils.findEndWhitespace((String)source2);
        String newWhitespace = StringUtils.findEndWhitespace((String)formatted);
        int oldNewLines = StringUtils.getNumberOfNewlines((String)oldWhitespace);
        int newNewLines = StringUtils.getNumberOfNewlines((String)newWhitespace);
        String toAppend = "";
        if (oldNewLines > newNewLines) {
            int diff = oldNewLines - newNewLines;
            int i = 0;
            while (i < diff) {
                toAppend = String.valueOf(toAppend) + writer.getCurrentIndentationString() + writer.getLineDelimeter();
                ++i;
            }
        }
        return toAppend;
    }
}

