/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.StreamUtils;
import java.io.InputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;

public class BaseDocumentProvider
extends TextFileDocumentProvider {
    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (info != null) {
            return info;
        }
        if (element instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)element).getPath();
            try {
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                manager.connect(path, LocationKind.NORMALIZE, this.getProgressMonitor());
                ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                fileBuffer.requestSynchronizationContext();
                info = this.createEmptyFileInfo();
                info.fTextFileBuffer = fileBuffer;
                info.fCachedReadOnlyState = true;
                path.toFile().setReadOnly();
                IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
                if (file != null) {
                    info.fModel = this.createAnnotationModel(file);
                }
            }
            catch (Exception exception) {
                return null;
            }
            return info;
        }
        if (element instanceof IStorageEditorInput) {
            IPath path = ((IStorageEditorInput)element).getStorage().getFullPath();
            String segment = path.lastSegment();
            path = path.removeLastSegments(1).append(String.valueOf(segment) + ".tmp." + System.currentTimeMillis());
            try {
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                manager.connect(path, LocationKind.NORMALIZE, this.getProgressMonitor());
                ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                fileBuffer.getDocument().set(StreamUtils.readContent((InputStream)((IStorageEditorInput)element).getStorage().getContents(), (String)this.getEncoding(element)));
                fileBuffer.setDirty(false);
                info = this.createEmptyFileInfo();
                info.fTextFileBuffer = fileBuffer;
                info.fCachedReadOnlyState = true;
                path.toFile().setReadOnly();
                IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
                if (file != null) {
                    info.fModel = this.createAnnotationModel(file);
                }
                return info;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected String getEncoding(IStorageEditorInput element) {
        try {
            IStorage storage = element.getStorage();
            if (storage instanceof IEncodedStorage) {
                return ((IEncodedStorage)storage).getCharset();
            }
        }
        catch (CoreException coreException) {}
        return this.getDefaultEncoding();
    }

    public boolean canSaveDocument(Object element) {
        if (element instanceof NonExistingFileEditorInput) {
            return true;
        }
        return super.canSaveDocument(element);
    }
}

