/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools.preferences;

import com.aptana.ide.pathtools.Activator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PathtoolsPreferences
extends AbstractPreferenceInitializer {
    public static final String FOLDER_EXPLORE_COMMAND_KEY = "folderExploreCommand";
    public static final String FILE_EXPLORE_COMMAND_KEY = "fileExploreCommand";
    static String defaultFolderExploreCommand = "";
    static String defaultFileExploreCommand = "";
    public static final String SHELL_ON_FOLDER_COMMAND_KEY = "shellOnfolderCommand";
    public static final String SHELL_ON_FILE_COMMAND_KEY = "shellOnFileCommand";
    static String defaultShellOnFolderCommand = "";
    static String defaultShellOnFileCommand = "";
    static String defaultFolderCommands = "";
    static String defaultFileCommands = "";
    public static final String FILE_PATH = "{path}";
    public static final String FILE_PARENT_PATH = "{parent-path}";
    public static final String FILE_NAME = "{name}";
    public static final String FILE_PARENT_NAME = "{parent-name}";
    public static final String FILE_PATH_SLASHES = "{path-slashes}";
    public static final String FILE_PARENT_PATH_SLASHES = "{parent-path-slashes}";
    public static final String FILE_PATH_BACKSLASHES = "{path-backslashes}";
    public static final String FILE_PARENT_PATH_BACKSLASHES = "{parent-path-backslashes}";
    public static final String LAST_COPY_PATH_FORMAT = "lastCopyPathFormat";
    static final String defaultLLastCopyPathFormat = "{path}";

    static {
        if ("macosx".equals(Platform.getOS())) {
            defaultFolderExploreCommand = "/usr/bin/open -a /System/Library/CoreServices/Finder.app \"{path}\"";
            defaultFileExploreCommand = "/usr/bin/open -a /System/Library/CoreServices/Finder.app \"{parent-path}\"";
            defaultShellOnFolderCommand = "/usr/bin/open -a /Applications/Utilities/Terminal.app";
            defaultShellOnFileCommand = "/usr/bin/open -a /Applications/Utilities/Terminal.app";
        } else if ("win32".equals(Platform.getOS())) {
            defaultFolderExploreCommand = "cmd /C start explorer /select,/e, \"{path}\"";
            defaultFileExploreCommand = "cmd /C start explorer /select,/e, \"{path}\"";
            defaultShellOnFolderCommand = "cmd /K start cd /D \"{path}\"";
            defaultShellOnFileCommand = "cmd /K start cd /D \"{parent-path}\"";
        } else if ("linux".equals(Platform.getOS())) {
            if (new File("/usr/bin/nautilus").exists()) {
                defaultFolderExploreCommand = "/usr/bin/nautilus \"{path}\"";
                defaultFileExploreCommand = "/usr/bin/nautilus \"{parent-path}\"";
            } else if (new File("/usr/bin/konqueror").exists()) {
                defaultFolderExploreCommand = "/usr/bin/konqueror \"{path}\"";
                defaultFileExploreCommand = "/usr/bin/konqueror \"{parent-path}\"";
            }
            defaultShellOnFolderCommand = "gnome-terminal --working-directory=\"{path}\"";
            defaultShellOnFileCommand = "gnome-terminal --working-directory=\"{parent-path}\"";
        }
    }

    public void initializeDefaultPreferences() {
        Activator activator = Activator.getDefault();
        if ("macosx".equals(Platform.getOS())) {
            try {
                String cdterminalDotScpt;
                URL entry = activator.getBundle().getEntry("/scripts/cdterminal.scpt");
                if (entry != null && (cdterminalDotScpt = FileLocator.toFileURL((URL)entry).getFile()) != null) {
                    defaultShellOnFolderCommand = "/usr/bin/osascript \"" + cdterminalDotScpt + "\" \"" + "{path}" + "\"";
                    defaultShellOnFileCommand = "/usr/bin/osascript \"" + cdterminalDotScpt + "\" \"" + FILE_PARENT_PATH + "\"";
                }
            }
            catch (IOException iOException) {}
        }
        IEclipsePreferences node = new DefaultScope().getNode(Activator.getDefault().getBundle().getSymbolicName());
        node.put(FOLDER_EXPLORE_COMMAND_KEY, defaultFolderExploreCommand);
        node.put(FILE_EXPLORE_COMMAND_KEY, defaultFileExploreCommand);
        node.put(SHELL_ON_FOLDER_COMMAND_KEY, defaultShellOnFolderCommand);
        node.put(SHELL_ON_FILE_COMMAND_KEY, defaultShellOnFileCommand);
        node.put(LAST_COPY_PATH_FORMAT, "{path}");
    }
}

