/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.CodeAssistMessages;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class UserAgentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected IWorkbench workbench;
    private CheckboxTableViewer categoryViewer;
    private TableViewer dependantViewer;
    private Text descriptionText;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(CodeAssistMessages.UserAgentPreferencePage_SelectBrowsers);
        label.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = new Label(composite, 0);
        data = new GridData(32);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createCategoryArea(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        Button enableAll = new Button(composite, 8);
        enableAll.setFont(parent.getFont());
        enableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserAgentPreferencePage.this.categoryViewer.setCheckedElements((Object[])UnifiedContentAssistProcessor.getDefaultUserAgents());
            }
        });
        enableAll.setText(CodeAssistMessages.UserAgentPreferencePage_SelectAll);
        this.setButtonLayoutData(enableAll);
        Button disableAll = new Button(composite, 8);
        disableAll.setFont(parent.getFont());
        disableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserAgentPreferencePage.this.categoryViewer.setCheckedElements((Object[])new String[0]);
            }
        });
        disableAll.setText(CodeAssistMessages.UserAgentPreferencePage_SelectNone);
        this.setButtonLayoutData(disableAll);
    }

    private void createCategoryArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setFont(parent.getFont());
        label.setText(StringUtils.makeFormLabel((String)"User Agents"));
        Table table = new Table(composite, 2084);
        table.setFont(parent.getFont());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setFont(parent.getFont());
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        CategoryLabelProvider categoryLabelProvider = new CategoryLabelProvider(true);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)categoryLabelProvider);
        this.categoryViewer.setSorter(new ViewerSorter());
        this.categoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.categoryViewer.setInput((Object)UnifiedContentAssistProcessor.getDefaultUserAgents());
        this.categoryViewer.setCheckedElements((Object[])this.getEnabledCategories());
    }

    private String[] getEnabledCategories() {
        return UnifiedContentAssistProcessor.getUserAgents();
    }

    protected void clearDetails() {
        this.dependantViewer.setInput((Object)Collections.EMPTY_SET);
        this.descriptionText.setText("");
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.setPreferenceStore(UnifiedEditorsPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        ArrayList<String> al = new ArrayList<String>();
        Object[] elements = this.categoryViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            al.add(elements[i].toString());
            ++i;
        }
        this.getPreferenceStore().setValue("com.aptana.ide.editor.USER_AGENT_PREFERENCE", StringUtils.join((String)",", (String[])al.toArray(new String[0])));
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        String prefs = this.getPreferenceStore().getDefaultString("com.aptana.ide.editor.USER_AGENT_PREFERENCE");
        this.categoryViewer.setCheckedElements((Object[])prefs.split(","));
    }

    private class CategoryContentProvider
    implements IStructuredContentProvider {
        private CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());

        public CategoryLabelProvider(boolean decorate) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            HashMap images = UnifiedContentAssistProcessor.getUserAgentImages();
            if (images.containsKey(element)) {
                return (Image)images.get(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }

        public void dispose() {
            super.dispose();
            this.manager.dispose();
        }
    }
}

