/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.dialogs.IAddItemListener;
import com.aptana.ide.core.ui.dialogs.TableEditor;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.CodeAssistMessages;
import com.aptana.ide.editors.preferences.ErrorDescriptorInfoDialog;
import com.aptana.ide.editors.unified.errors.ErrorDescriptor;
import com.aptana.ide.editors.validator.ValidatorManager;
import com.aptana.ide.editors.validator.ValidatorRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class ProblemsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IAddItemListener {
    private static Image fWarningImage = UnifiedEditorsPlugin.getImageDescriptor((String)"icons/warning.png").createImage();
    protected IWorkbench workbench;
    private TableEditor _tableEditor;
    private CheckboxTableViewer _validatorViewer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createValidatorPreferenceControls(composite);
        Group errorFilter = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        errorFilter.setLayout((Layout)gridLayout);
        errorFilter.setLayoutData((Object)new GridData(4, 4, true, true));
        errorFilter.setText(CodeAssistMessages.ProblemsPreferencePage_ProblemViewFilters);
        this._tableEditor = new TableEditor((Composite)errorFilter, 0, true);
        this._tableEditor.setDescription(CodeAssistMessages.ProblemsPreferencePage_ProblemsDescription);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this._tableEditor.setLayoutData((Object)data);
        IPreferenceStore store = this.doGetPreferenceStore();
        String editors = store.getString(this.doGetPreferenceString());
        ErrorDescriptor[] descriptors = ErrorDescriptor.deserializeErrorDescriptors((String)editors);
        ArrayList<ErrorDescriptor> items = new ArrayList<ErrorDescriptor>(Arrays.asList(descriptors));
        this._tableEditor.setLabelProvider((ITableLabelProvider)new TableLabelProvider());
        this._tableEditor.addAddItemListener((IAddItemListener)this);
        new TableColumn(this._tableEditor.getTable(), 16384);
        this._tableEditor.setItems(items);
        this.workbench.getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.file_editors_preference_page_context");
        this.applyDialogFont((Composite)this._tableEditor);
        return composite;
    }

    private void createValidatorPreferenceControls(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        displayArea.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        displayArea.setLayoutData((Object)data);
        Group validators = new Group(displayArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        validators.setLayout((Layout)gridLayout);
        validators.setLayoutData((Object)new GridData(4, 4, true, true));
        validators.setText(CodeAssistMessages.ProblemsPreferencePage_Validators);
        Table table = new Table((Composite)validators, 2080);
        table.setFont(parent.getFont());
        table.setLayoutData((Object)new GridData(1808));
        this._validatorViewer = new CheckboxTableViewer(table);
        this._validatorViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._validatorViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        data.widthHint = 140;
        table.setLayoutData((Object)data);
        this.addvalidators();
        String stored_validators = this.getPreferenceStore().getString("com.aptana.ide.editors.VALIDATORS_LIST");
        this.restoreCheckedValidators(stored_validators);
    }

    private void restoreCheckedValidators(String stored_validators) {
        if (!stored_validators.equals("com.aptana.ide.editors.VALIDATORS_NONE")) {
            if (stored_validators.length() == 0) {
                List validatorNames = (List)this._validatorViewer.getInput();
                this._validatorViewer.setCheckedElements((Object[])validatorNames.toArray(new String[validatorNames.size()]));
            } else {
                String[] validators = stored_validators.split(",");
                List validatorNames = (List)this._validatorViewer.getInput();
                int size = validatorNames.size();
                int i = 0;
                while (i < size) {
                    String name = (String)validatorNames.get(i);
                    int j = 0;
                    while (j < validators.length) {
                        if (name.equals(validators[j])) {
                            this._validatorViewer.setChecked((Object)name, true);
                            break;
                        }
                        ++j;
                    }
                    if (j == validators.length) {
                        this._validatorViewer.setChecked((Object)name, false);
                    }
                    ++i;
                }
            }
        }
    }

    private void addvalidators() {
        String mimeType = this.getMimeType();
        ValidatorManager validatiorManager = ValidatorManager.getInstance();
        ValidatorRef[] validators = validatiorManager.getValidators(mimeType);
        if (validators != null && validators.length > 0) {
            ArrayList<String> validatorNames = new ArrayList<String>();
            int i = 0;
            while (i < validators.length) {
                validatorNames.add(validators[i].getName());
                ++i;
            }
            this._validatorViewer.setInput(validatorNames);
        }
    }

    protected abstract String getMimeType();

    public void dispose() {
        this._tableEditor.removeAddItemListener((IAddItemListener)this);
        super.dispose();
    }

    protected abstract IPreferenceStore doGetPreferenceStore();

    protected abstract Plugin doGetPlugin();

    protected String doGetPreferenceString() {
        return "com.aptana.ide.editors.HTMLEDITOR_IGNORE_PROBLEMS";
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.doGetPreferenceStore();
        String editors = store.getDefaultString(this.doGetPreferenceString());
        ErrorDescriptor[] descriptors = ErrorDescriptor.deserializeErrorDescriptors((String)editors);
        ArrayList<ErrorDescriptor> items = new ArrayList<ErrorDescriptor>(Arrays.asList(descriptors));
        this._tableEditor.setItems(items);
        String stored_validators = this.getPreferenceStore().getDefaultString("com.aptana.ide.editors.VALIDATORS_LIST");
        this.restoreCheckedValidators(stored_validators);
    }

    public Object addItem() {
        ErrorDescriptorInfoDialog dialog = new ErrorDescriptorInfoDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            String message = dialog.getMessage();
            ErrorDescriptor ed = new ErrorDescriptor();
            ed.setMessage(message);
            return ed;
        }
        return null;
    }

    public boolean performOk() {
        IPreferenceStore store = this.doGetPreferenceStore();
        List items = this._tableEditor.getItems();
        store.setValue(this.doGetPreferenceString(), ErrorDescriptor.serializeErrorDescriptors((ErrorDescriptor[])items.toArray(new ErrorDescriptor[0])));
        ArrayList<String> validatorItems = new ArrayList<String>();
        Object[] checkedItems = this._validatorViewer.getCheckedElements();
        if (checkedItems.length > 0) {
            int i = 0;
            while (i < checkedItems.length) {
                validatorItems.add(checkedItems[i].toString());
                ++i;
            }
            store.setValue("com.aptana.ide.editors.VALIDATORS_LIST", StringUtils.join((String)",", (String[])validatorItems.toArray(new String[0])));
        } else {
            store.setValue("com.aptana.ide.editors.VALIDATORS_LIST", "com.aptana.ide.editors.VALIDATORS_NONE");
        }
        this.doGetPlugin().savePluginPreferences();
        return true;
    }

    public Object editItem(Object item) {
        if (item instanceof ErrorDescriptor) {
            ErrorDescriptorInfoDialog dialog = new ErrorDescriptorInfoDialog(this.getControl().getShell());
            ErrorDescriptor ed = (ErrorDescriptor)item;
            dialog.setItem(ed);
            if (dialog.open() == 0) {
                ed.setMessage(dialog.getMessage());
                return ed;
            }
            return null;
        }
        return null;
    }

    public class TableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            switch (columnIndex) {
                case 0: {
                    image = fWarningImage;
                    break;
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String name = "";
            ErrorDescriptor ed = (ErrorDescriptor)element;
            switch (columnIndex) {
                case 0: {
                    name = ed.getMessage();
                    break;
                }
                case 1: {
                    name = ed.getFolderPath();
                    break;
                }
                case 2: {
                    name = ed.getFileName();
                    break;
                }
            }
            return name;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

