/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.debug.core.JSLaunchConfigurationHelper;
import com.aptana.ide.debug.core.util.FirebugUtils;
import com.aptana.ide.debug.internal.ui.Messages;
import com.aptana.ide.debug.internal.ui.WorkbenchCloseListener;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class Startup
implements IStartup {
    public void earlyStartup() {
        this.registerAsFirebugEditor();
        UIJob job = new UIJob("Checking default launch configuration"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Startup.this.checkDefaultLaunchConfiguration();
                WorkbenchCloseListener.init();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)MutexJobRule.getInstance());
        job.setSystem(true);
        job.schedule();
    }

    private void registerAsFirebugEditor() {
        IPath launcher = FileUtils.getApplicationLauncher();
        if (launcher != null) {
            FirebugUtils.registerEditor((String)"Aptana", (String)"Aptana Studio", (IPath)launcher, (String)"");
        }
    }

    private void checkDefaultLaunchConfiguration() {
        Stack<ILaunchConfiguration> defaultConfigurations = new Stack<ILaunchConfiguration>();
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration[] history = manager.getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug").getHistory();
        ILaunchConfiguration configuration = this.getOrCreateDefaultLaunchConfiguration("Firefox");
        if (configuration != null) {
            defaultConfigurations.push(configuration);
        }
        if ("win32".equals(Platform.getOS()) && (configuration = this.getOrCreateDefaultLaunchConfiguration("Internet Explorer")) != null) {
            defaultConfigurations.push(configuration);
        }
        int i = 0;
        while (i < history.length) {
            Iterator j = defaultConfigurations.iterator();
            while (j.hasNext()) {
                if (!history[i].equals(j.next())) continue;
                j.remove();
                break;
            }
            ++i;
        }
        while (!defaultConfigurations.empty()) {
            configuration = (ILaunchConfiguration)defaultConfigurations.pop();
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.run", configuration);
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.debug", configuration);
        }
    }

    private void setRecentLaunchHistory(String groupId, final ILaunchConfiguration configuration) {
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchHistory history = manager.getLaunchHistory(groupId);
        history.launchAdded(new ILaunch(){

            public ILaunchConfiguration getLaunchConfiguration() {
                return configuration;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public void addDebugTarget(IDebugTarget target) {
            }

            public void removeDebugTarget(IDebugTarget target) {
            }

            public void addProcess(IProcess process) {
            }

            public void removeProcess(IProcess process) {
            }

            public ISourceLocator getSourceLocator() {
                return null;
            }

            public void setSourceLocator(ISourceLocator sourceLocator) {
            }

            public String getLaunchMode() {
                return null;
            }

            public void setAttribute(String key, String value) {
            }

            public String getAttribute(String key) {
                return null;
            }

            public boolean hasChildren() {
                return false;
            }

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ILaunchConfiguration getOrCreateDefaultLaunchConfiguration(String nature) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (nature.equals(config.getAttribute("browserNature", ""))) {
                    return config;
                }
                ++i;
            }
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(String.valueOf(nature) + " - Internal Server"));
            JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
            boolean showDownload = true;
            while (!JSLaunchConfigurationHelper.isBrowserDebugCompatible((String)wc.getAttribute("browserExecutable", ""))) {
                IPreferenceStore store;
                String pref;
                String browserPath = null;
                if (nature.equals("Firefox") && ((pref = (store = DebugUiPlugin.getDefault().getPreferenceStore()).getString("com.aptana.ide.debug.ui.skip_firefox_check")) == null || !pref.equals("always"))) {
                    browserPath = this.showBrowserNotFoundDialog(showDownload);
                }
                if (browserPath == null) {
                    wc.delete();
                    return null;
                }
                if (browserPath.length() == 0) {
                    JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
                } else {
                    wc.setAttribute("browserExecutable", browserPath);
                }
                showDownload = false;
            }
            return wc.doSave();
        }
        catch (CoreException e) {
            DebugUiPlugin.log(e);
            return null;
        }
    }

    private ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.aptana.ide.debug.core.jsLaunchConfigurationType");
    }

    private String showBrowserNotFoundDialog(final boolean download) {
        final String[] path = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (Display.getCurrent().getActiveShell() == null) {
                    return;
                }
                MessageDialogWithToggle md = new MessageDialogWithToggle(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.Startup_Notification, null, Messages.Startup_AptanaRequiresFirefox, 2, new String[]{IDialogConstants.PROCEED_LABEL, StringUtils.ellipsify((String)CoreStrings.BROWSE), download ? Messages.Startup_Download : Messages.Startup_CheckAgain}, 0, Messages.Startup_DontAskAgain, false);
                md.setPrefKey("com.aptana.ide.debug.ui.skip_firefox_check");
                md.setPrefStore(DebugUiPlugin.getDefault().getPreferenceStore());
                int returnCode = md.open();
                switch (returnCode) {
                    case 256: {
                        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                        if ("win32".equals(Platform.getOS())) {
                            fileDialog.setFilterExtensions(new String[]{"*.exe"});
                            fileDialog.setFilterNames(new String[]{Messages.Startup_ExecutableFiles});
                        }
                        path[0] = fileDialog.open();
                        break;
                    }
                    case 257: {
                        if (download) {
                            WorkbenchHelper.launchBrowser((String)"http://www.getfirefox.com");
                        }
                        path[0] = "";
                    }
                }
            }
        });
        return path[0];
    }
}

