/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.doms;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.syncing.doms.Messages;
import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.actions.UploadAction;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.FileEditorInput;

public final class Sync {
    public static void uploadCurrentEditor() {
        IEditorPart editor = CoreUIUtils.getActiveEditor();
        if (editor == null) {
            if (!Sync.uploadCurrentSelection()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Sync_TTL_UnableToUpload, (String)Messages.Sync_ERR_YouMustHaveACurrentlyOpenEditorToUpload);
            }
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            Sync.upload((IAdaptable)((FileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            Sync.upload(((IPathEditorInput)input).getPath());
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            try {
                Sync.upload((IAdaptable)EFS.getStore((URI)editorInput.getURI()));
            }
            catch (CoreException coreException) {}
        } else {
            Sync.uploadCurrentSelection();
        }
    }

    public static boolean uploadCurrentSelection() {
        try {
            ISelection selection;
            IViewPart viewPart = CoreUIUtils.findView((String)"com.aptana.ide.ui.io.fileExplorerView");
            if (viewPart != null && viewPart instanceof CommonNavigator && (selection = ((CommonNavigator)viewPart).getCommonViewer().getSelection()) instanceof IStructuredSelection) {
                Sync.upload((IStructuredSelection)selection);
                return true;
            }
        }
        catch (PartInitException partInitException) {}
        return false;
    }

    public static void upload(IStructuredSelection selection) {
        UploadAction action = new UploadAction();
        action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        action.setSelection((ISelection)selection);
        action.run(null);
    }

    public static void upload(IAdaptable file) {
        Sync.upload((IStructuredSelection)new StructuredSelection((Object)file));
    }

    public static void upload(IPath path) {
        try {
            Sync.upload((IAdaptable)EFS.getStore((URI)URIUtil.toURI((IPath)path)));
        }
        catch (CoreException coreException) {}
    }

    public static void downloadCurrentEditor() {
        IEditorPart editor = CoreUIUtils.getActiveEditor();
        if (editor == null) {
            if (!Sync.downloadCurrentSelection()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Sync_TTL_UnableToDownload, (String)Messages.Sync_ERR_YouMustHaveACurrentlyOpenEditorToDownload);
            }
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            Sync.download((IAdaptable)((FileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            Sync.download(((IPathEditorInput)input).getPath());
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            try {
                Sync.download((IAdaptable)EFS.getStore((URI)editorInput.getURI()));
            }
            catch (CoreException coreException) {}
        } else {
            Sync.downloadCurrentSelection();
        }
    }

    public static boolean downloadCurrentSelection() {
        try {
            ISelection selection;
            IViewPart viewPart = CoreUIUtils.findView((String)"com.aptana.ide.ui.io.fileExplorerView");
            if (viewPart != null && viewPart instanceof CommonNavigator && (selection = ((CommonNavigator)viewPart).getCommonViewer().getSelection()) instanceof IStructuredSelection) {
                Sync.download((IStructuredSelection)selection);
                return true;
            }
        }
        catch (PartInitException partInitException) {}
        return false;
    }

    public static void download(IStructuredSelection selection) {
        DownloadAction action = new DownloadAction();
        action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        action.setSelection((ISelection)selection);
        action.run(null);
    }

    public static void download(IAdaptable file) {
        Sync.download((IStructuredSelection)new StructuredSelection((Object)file));
    }

    public static void download(IPath path) {
        try {
            Sync.download((IAdaptable)EFS.getStore((URI)URIUtil.toURI((IPath)path)));
        }
        catch (CoreException coreException) {}
    }
}

